/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gwt.user.client.ui.tabs;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.TabPanel;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.user.client.ui.JucoDropdownTab;
import de.justsoftware.gwt.user.client.ui.tabs.DropdownTabData;
import de.justsoftware.gwt.user.client.ui.tabs.TabData;
import de.justsoftware.gwt.user.client.ui.tabs.TabbedView;
import de.justsoftware.gwt.user.client.ui.tabs.TabbedViewImpl;
import de.justsoftware.onx.common.presentation.client.ui.DOMHelper;
import de.justsoftware.onx.common.presentation.client.ui.HasCount;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TabbedViewImpl
implements TabbedView {
    private static final String TABBED_WIDGET_CSS_CLASS = "tabbed-widget";
    private static final String CSS_CLASS_HIDDEN = "hidden";
    private static final int MINIMUM_TAB_PANEL_WIDTH = 765;
    private final FlowPanel _tabWidget = new FlowPanel();
    private final TabPanel _tabPanel = new TabPanel();
    private final JucoDropdownTab _addContentTab = new JucoDropdownTab("+ " + I18nMediator.BASIC_CONSTANTS.add());
    private final JucoDropdownTab _moreTab = new JucoDropdownTab(I18nMediator.BASIC_CONSTANTS.moreTabTitle());
    private final Map<String, NavLinkWithCount> _dropdownLinks = Maps.newHashMap();
    private final Map<String, TablinkWithCount> _tabLinks = Maps.newHashMap();
    private final Map<String, Integer> _widthCache = Maps.newHashMap();
    private final int _extraTabLinkPadding;
    private ImmutableList<TabData> _currentTabData = ImmutableList.of();
    private ImmutableList<DropdownTabData> _currentDropdownTabs = ImmutableList.of();
    private int _tabPanelWidth = 0;
    private int _addContentTabWidth = 0;
    private int _moreButtonWidth = 0;
    private int _showFilterLinkWidth = 0;
    private HandlerRegistration _attachTabsHandler = null;

    public TabbedViewImpl(int extraTabLinkPadding, @Nullable String additionalStyleName, @Nullable TabbedView.Presenter presenter) {
        this._extraTabLinkPadding = extraTabLinkPadding;
        this._tabWidget.addStyleName(TABBED_WIDGET_CSS_CLASS);
        this._moreTab.addStyleName("dropdown-link");
        this._moreTab.addStyleName("app-hover-color");
        this._moreTab.addStyleName("app-border-color");
        this._addContentTab.addStyleName("dropdown-link");
        this._addContentTab.addStyleName("app-hover-color");
        this._addContentTab.addStyleName("app-border-color");
        if (!Strings.isNullOrEmpty((String)additionalStyleName)) {
            this._tabWidget.addStyleName(additionalStyleName);
        }
        this._tabWidget.add((Widget)this._tabPanel);
        this._tabWidget.addAttachHandler((AttachEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setTabs(Iterable<TabData> tabs, Iterable<DropdownTabData> dropdownTabs) {
        this._tabPanel.clear();
        this._addContentTab.clear();
        this._currentTabData = ImmutableList.copyOf(tabs);
        this._currentDropdownTabs = ImmutableList.copyOf(dropdownTabs);
        this._tabLinks.clear();
        this._dropdownLinks.clear();
        if (this._tabPanel.isAttached()) {
            this.renderTabs(true);
        } else {
            this.removeAttachTabsHandler();
            this._attachTabsHandler = this._tabPanel.addAttachHandler((AttachEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void removeAttachTabsHandler() {
        if (this._attachTabsHandler != null) {
            this._attachTabsHandler.removeHandler();
            this._attachTabsHandler = null;
        }
    }

    private void renderTabs(boolean loadData) {
        this._moreTab.clear();
        this._addContentTab.clear();
        this.measureStatics();
        int availableWidth = this._tabPanelWidth - this._extraTabLinkPadding;
        if (this._currentDropdownTabs.isEmpty()) {
            this._addContentTab.addStyleName(CSS_CLASS_HIDDEN);
        } else {
            this._addContentTab.removeStyleName(CSS_CLASS_HIDDEN);
            availableWidth -= this._addContentTabWidth;
        }
        Optional activeTab = FluentIterable.from((Iterable)this._currentTabData).firstMatch(TabData.IS_ACTIVE);
        if (activeTab.isPresent()) {
            TabData tabData = (TabData)activeTab.get();
            TablinkWithCount tabLink = this.getTabLink(tabData);
            availableWidth -= this.getTabWidth(tabLink);
        }
        boolean lastTabFitted = true;
        TablinkWithCount lastVisibleTab = null;
        for (int i = 0; i < this._currentTabData.size(); ++i) {
            boolean tabFits;
            boolean lastTab = i == this._currentTabData.size() - 1;
            TabData tabData = (TabData)this._currentTabData.get(i);
            TablinkWithCount tabLink = this.getTabLink(tabData);
            if (tabData.isActive()) {
                this.addActiveTab(tabData, tabLink, loadData);
                continue;
            }
            int tabLinkWidth = this.getTabWidth(tabLink);
            boolean bl = lastTab ? availableWidth - tabLinkWidth > 0 : (tabFits = availableWidth - (tabLinkWidth + this._moreButtonWidth) > 0);
            if (lastTabFitted && tabFits) {
                tabLink.removeStyleName(CSS_CLASS_HIDDEN);
                availableWidth -= tabLinkWidth;
                lastVisibleTab = tabLink;
            } else {
                lastTabFitted = false;
                this.addLinkToMoreTab(tabLink);
            }
            this.addIfNotYetAdded((Widget)tabLink);
        }
        this.addMoreTabIfNeeded(availableWidth, lastVisibleTab);
        this.addDropdownTabs((Iterable)this._currentDropdownTabs);
        this.addIfNotYetAdded((Widget)this._addContentTab);
    }

    private int getTabWidth(TablinkWithCount link) {
        String key = link.getText();
        Integer cached = (Integer)this._widthCache.get(key);
        if (cached != null) {
            return cached;
        }
        TablinkWithCount clone = new TablinkWithCount(link);
        int width = this.getWidth((Widget)clone) + this._extraTabLinkPadding;
        this._widthCache.put(key, width);
        return width;
    }

    private int getWidth(Widget tabWidget) {
        TabPanel contextPanel = new TabPanel();
        contextPanel.add(tabWidget);
        int width = DOMHelper.computeOrEstimateWidth((Widget)tabWidget, (Widget)contextPanel, (String)TABBED_WIDGET_CSS_CLASS);
        return width;
    }

    private void measureStatics() {
        if (this._tabPanelWidth == 0) {
            int measuredWidth = DOMHelper.computeOrEstimateWidth((Widget)this._tabPanel);
            this._tabPanelWidth = measuredWidth > 765 ? measuredWidth : 765;
            this._tabPanelWidth -= 40;
        }
        if (this._addContentTabWidth == 0) {
            this._addContentTabWidth = this.getWidth((Widget)new JucoDropdownTab("+ " + I18nMediator.BASIC_CONSTANTS.add()));
        }
        if (this._moreButtonWidth == 0) {
            this._moreButtonWidth = this.getWidth((Widget)new JucoDropdownTab(I18nMediator.BASIC_CONSTANTS.moreTabTitle()));
        }
    }

    public void handleResize() {
        if (this._currentTabData != null) {
            this.reset();
            this.renderTabs(false);
        }
    }

    public void reset() {
        this._tabPanelWidth = 0;
        this._addContentTabWidth = 0;
        this._moreButtonWidth = 0;
        this._showFilterLinkWidth = 0;
        this._widthCache.clear();
    }

    private void addMoreTabIfNeeded(int availableWidth, TablinkWithCount lastVisibleTab) {
        if (this._moreTab.getMenuWiget().getWidgetCount() > 0) {
            if (availableWidth < this._moreButtonWidth && lastVisibleTab != null) {
                this.addLinkToMoreTab(lastVisibleTab);
            }
            this._moreTab.removeStyleName(CSS_CLASS_HIDDEN);
        } else {
            this._moreTab.addStyleName(CSS_CLASS_HIDDEN);
        }
        this.addIfNotYetAdded((Widget)this._moreTab);
    }

    private void addLinkToMoreTab(TablinkWithCount tabLink) {
        tabLink.addStyleName(CSS_CLASS_HIDDEN);
        NavLinkWithCount dropdownLink = this.createDropdownLink(tabLink);
        this._moreTab.add((Widget)dropdownLink);
        this._dropdownLinks.put(dropdownLink.getAnchor().getTargetHistoryToken(), dropdownLink);
    }

    @Nonnull
    private NavLinkWithCount createDropdownLink(TablinkWithCount tabLink) {
        NavLinkWithCount navLink = new NavLinkWithCount();
        navLink.setTargetHistoryToken(tabLink.getAnchor().getTargetHistoryToken());
        navLink.setText(tabLink.getText());
        navLink.setTitle(tabLink.getText());
        navLink.setCount(tabLink._count.longValue());
        return navLink;
    }

    private void addActiveTab(TabData tabData, TablinkWithCount tabLink, boolean loadData) {
        this.addIfNotYetAdded((Widget)tabLink);
        tabLink.setActive(true);
        tabLink.removeStyleName(CSS_CLASS_HIDDEN);
        this.addStyles((Widget)tabLink.getTabPane(), (Iterable)tabData.getCSSClass());
        TabData.TabSelectHandler tabSelectHandler = tabData.getTabSelectHandler();
        if (loadData && tabSelectHandler != null) {
            tabSelectHandler.handleTabSelection(tabLink.getTabPane());
        }
    }

    private void addIfNotYetAdded(Widget w) {
        if (w.isAttached() || w.getParent() != null) {
            return;
        }
        this._tabPanel.add(w);
    }

    private void addDropdownTabs(Iterable<DropdownTabData> dropdownTabs) {
        for (DropdownTabData tabData : dropdownTabs) {
            NavLink navLink = new NavLink();
            navLink.setText(tabData._title);
            navLink.setTitle(tabData._title);
            navLink.addClickHandler(tabData._clickHandler);
            this._addContentTab.add((Widget)navLink);
        }
    }

    @Nonnull
    private TablinkWithCount getTabLink(TabData tabData) {
        TablinkWithCount existingTab = (TablinkWithCount)this._tabLinks.get(tabData.getTabToken());
        if (existingTab != null) {
            return existingTab;
        }
        TablinkWithCount tabLink = new TablinkWithCount();
        tabLink.setTargetHistoryToken(tabData.getTabToken());
        tabLink.setText(tabData.getTabTitle());
        tabLink.setTitle(tabData.getTabTitle());
        Long itemCount = tabData.getItemCount();
        if (itemCount != null) {
            tabLink.setCount(itemCount.longValue());
        }
        tabLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this._tabLinks.put(tabData.getTabToken(), tabLink);
        return tabLink;
    }

    public void setTabCount(String tabToken, long count) {
        TablinkWithCount tablink;
        HasCount hasCount = (HasCount)this._dropdownLinks.get(tabToken);
        if (hasCount != null) {
            hasCount.setCount(count);
        }
        if ((tablink = (TablinkWithCount)this._tabLinks.get(tabToken)) != null) {
            tablink.setCount(count);
        }
    }

    private void addStyles(Widget widget, Iterable<String> styles) {
        for (String s : styles) {
            widget.addStyleName(s);
        }
    }

    public Widget asWidget() {
        return this._tabWidget;
    }

    public void setVisible(boolean visible) {
        this._tabWidget.setVisible(visible);
    }
}

