/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gwt.user.client.ui;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;

public class Accordion
extends Composite
implements HasWidgets {
    private static final String OPENED_STYLE = "accordion-opened";
    private static final String CLOSED_STYLE = "accordion-closed";
    private static final String FIRST_STYLE = "accordion-first";
    private static final String CONTENT_STYLE = "accordion-content";
    private static final String HEAD_STYLE = "accordion-head";
    private static final String HEAD_FOCUS_STYLE = "accordion-focusPanel";
    private final Panel _content = new FlowPanel();
    private Widget _lastHeaderWidget = null;

    public Accordion() {
        this.initWidget((Widget)this._content);
    }

    @Deprecated
    public void add(Widget w) {
        if (this._lastHeaderWidget == null) {
            this._lastHeaderWidget = w;
        } else {
            this.add(this._lastHeaderWidget, w);
            this._lastHeaderWidget = null;
        }
    }

    public void add(Widget headerWidget, Widget content) {
        boolean first = !this._content.iterator().hasNext();
        FocusPanel focusPanel = new FocusPanel(headerWidget);
        focusPanel.addStyleName(HEAD_FOCUS_STYLE);
        this._content.add((Widget)focusPanel);
        this._content.add(content);
        content.setVisible(false);
        content.addStyleName(CONTENT_STYLE);
        headerWidget.addStyleName("clearfix");
        headerWidget.addStyleName(HEAD_STYLE);
        headerWidget.addStyleName(CLOSED_STYLE);
        if (first) {
            headerWidget.addStyleName(FIRST_STYLE);
        }
        focusPanel.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        focusPanel.addMouseOverHandler((MouseOverHandler)new /* Unavailable Anonymous Inner Class!! */);
        focusPanel.addMouseOutHandler((MouseOutHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void closeAll() {
        boolean isContent = false;
        for (Widget w : this) {
            if (isContent) {
                w.setVisible(false);
            } else {
                FocusPanel focusPanel = (FocusPanel)w;
                Widget header = (Widget)focusPanel.iterator().next();
                header.removeStyleName(OPENED_STYLE);
                header.addStyleName(CLOSED_STYLE);
            }
            isContent = !isContent;
        }
    }

    public void open(Widget content) {
        this.closeAll();
        Widget header = null;
        boolean isContent = false;
        for (Widget w : this) {
            if (isContent) {
                if (w == content) {
                    FocusPanel focusPanel = (FocusPanel)header;
                    Widget headerWidget = (Widget)focusPanel.iterator().next();
                    content.setVisible(true);
                    headerWidget.removeStyleName(CLOSED_STYLE);
                    headerWidget.addStyleName(OPENED_STYLE);
                }
            } else {
                header = w;
            }
            isContent = !isContent;
        }
    }

    public void clear() {
        this._lastHeaderWidget = null;
        this._content.clear();
    }

    public Iterator<Widget> iterator() {
        return this._content.iterator();
    }

    public boolean remove(Widget w) {
        return this._content.remove(w);
    }
}

