/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.presentation.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.HTMLUtil;
import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageType;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.google.common.base.Function;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.InlineHyperlink;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.events.EventManager;
import de.justsoftware.onx.common.presentation.client.ui.JucoSafeHtmlTemplates;
import de.justsoftware.onx.common.presentation.client.ui.personpopup.PersonPopupManager;
import de.justsoftware.onx.common.presentation.client.ui.personpopup.PersonPopupPresenter;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.components.presentation.client.ui.AnchorPanel;
import de.justsoftware.onx.design.client.util.CssClassUtil;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import javax.annotation.Nonnull;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PersonUtil {
    @Deprecated
    public static final PersonId DELETED_USER_ID_TYPED = new PersonId(-1L);

    private PersonUtil() {
    }

    @Nonnull
    public static Function<PersonTeaserModel, Widget> profileLink(@Nonnull ClientFactory clientFactory, PopupOption popupOption) {
        return input -> input != null ? PersonUtil.profileLink((PersonTeaserModel)input, (ClientFactory)clientFactory, (PopupOption)popupOption) : null;
    }

    @Deprecated
    public static Widget profileLink(String linkText, PersonId personId) {
        if (personId == null || personId.equals((Object)DELETED_USER_ID_TYPED)) {
            return PersonUtil.createhighlightedHTML((String)I18nMediator.PROFILE.deletedUser());
        }
        return PersonUtil.createHighlightedInlineHyperlink((PersonId)personId, (String)linkText);
    }

    public static Widget profileLink(@Nonnull String linkText, @Nonnull PersonTeaserModel person) {
        if (person.isDeleted()) {
            return PersonUtil.createhighlightedHTML((String)I18nMediator.PROFILE.deletedUser());
        }
        if (!person.isVisible()) {
            return PersonUtil.createhighlightedHTML((String)linkText);
        }
        return PersonUtil.createHighlightedInlineHyperlink((PersonId)((PersonId)person.getId()), (String)linkText);
    }

    private static InlineHyperlink createHighlightedInlineHyperlink(@Nonnull PersonId id, @Nonnull String linkText) {
        InlineHyperlink link = new InlineHyperlink(linkText, "/people/profile/" + String.valueOf(id));
        link.setHTML(HTMLUtil.highlightedHtmlEscape((String)linkText));
        return link;
    }

    private static HTML createhighlightedHTML(@Nonnull String text) {
        InlineHTML result = new InlineHTML(HTMLUtil.highlightedHtmlEscape((String)text));
        result.setTitle(HTMLUtil.removeHighlightTag((String)text));
        return result;
    }

    public static SafeHtml profileLinkAsHtml(@Nonnull PersonTeaserModel person) {
        if (person.isDeleted() || !person.isVisible()) {
            return JucoSafeHtmlTemplates.INSTANCE.inlineLabel(StringUtil.breakWord((String)PersonUtil.fullName((PersonTeaserModel)person)));
        }
        return JucoSafeHtmlTemplates.INSTANCE.inlineHyperlink(StringUtil.breakWord((String)PersonUtil.fullName((PersonTeaserModel)person)), UriUtils.fromSafeConstant((String)("#/people/profile/" + String.valueOf(person.getId()))));
    }

    public static Widget profileLink(@Nonnull PersonTeaserModel person, ClickHandler clickHandler) {
        String linkText = PersonUtil.fullName((PersonTeaserModel)person);
        if (person.isDeleted()) {
            return new HTML(HTMLUtil.highlightedHtmlEscape((String)linkText));
        }
        Anchor anchor = new Anchor(linkText);
        anchor.setHTML(HTMLUtil.highlightedHtmlEscape((String)linkText));
        anchor.addClickHandler(event -> {
            History.newItem((String)("/people/profile/" + String.valueOf(person.getId())));
            clickHandler.onClick(event);
        });
        return anchor;
    }

    public static Widget profileLink(PersonTeaserModel person, ClientFactory clientFactory, PopupOption popupOption) {
        return PersonUtil.profileLink((PersonTeaserModel)person, (boolean)false, (ClientFactory)clientFactory, (PopupOption)popupOption);
    }

    public static Widget profileInlineLink(PersonTeaserModel person, ClientFactory clientFactory, PopupOption popupOption) {
        String linkText = HTMLUtil.removeHighlightTag((String)PersonUtil.fullName((PersonTeaserModel)person));
        if (person.isDeleted()) {
            return new InlineLabel(I18nMediator.PROFILE.deletedUser());
        }
        if (!person.isVisible()) {
            return new InlineLabel(linkText);
        }
        InlineHyperlink link = new InlineHyperlink(linkText, "/people/profile/" + String.valueOf(person.getId()));
        if (popupOption == PopupOption.WITH_POPUP) {
            PersonUtil.createProfilePopup((PersonTeaserModel)person, (ClientFactory)clientFactory, (Widget)link, (boolean)false);
        }
        return link;
    }

    public static Widget profileLink(PersonTeaserModel person, boolean breakWord, ClientFactory clientFactory, PopupOption popupOption) {
        Widget profileLink = PersonUtil.profileLink((String)(breakWord ? StringUtil.breakWord((String)PersonUtil.fullName((PersonTeaserModel)person)) : PersonUtil.fullName((PersonTeaserModel)person)), (PersonTeaserModel)person);
        if (popupOption == PopupOption.WITH_POPUP && person.isVisible() && !person.isDeleted()) {
            PersonUtil.createProfilePopup((PersonTeaserModel)person, (ClientFactory)clientFactory, (Widget)profileLink, (boolean)false);
        }
        return profileLink;
    }

    public static void createProfilePopup(PersonTeaserModel person, ClientFactory clientFactory, Widget relativeTo, boolean fixEmptyRelativeTo) {
        new PersonPopupManager((popupContainer, popupRoot, cb) -> {
            PersonPopupPresenter popupPresenter = new PersonPopupPresenter(clientFactory, person);
            popupPresenter.init(() -> {
                popupPresenter.show((HasWidgets.ForIsWidget)popupRoot);
                cb.call();
            });
        }).fixEmptyRelativeTo(fixEmptyRelativeTo).withOpenStrategy(PersonPopupManager.Toggler.openDelayed((int)800)).withCloseStrategy(PersonPopupManager.Toggler.autoCloseDelayed((int)100, (EventManager)clientFactory.eventManager())).bindRelativeTo(relativeTo);
    }

    public static String fullName(@Nonnull PersonTeaserModel person) {
        if (person.isDeleted()) {
            return I18nMediator.PROFILE.deletedUser();
        }
        return PersonUtil.getAnnotatedName((String)person.getFullName(), (boolean)person.isBlocked(), (boolean)person.isActive());
    }

    public static String getAnnotatedName(String name, boolean personIsBlocked, boolean personIsActive) {
        Object prefix = personIsBlocked && !personIsActive ? I18nMediator.PROFILE.deactivatedBlockedPerson() + " " : (personIsBlocked ? I18nMediator.PROFILE.blockedPerson() + " " : (!personIsActive ? I18nMediator.PROFILE.deactivatedPerson() + " " : ""));
        return (String)prefix + name;
    }

    public static Widget createImage(@Nonnull PersonTeaserModel person, @Nonnull ImageSize size) {
        Image image = PersonUtil.createImageWidget((PersonTeaserModel)person, (ImageSize)size);
        if (!PersonUtil.isProfileLinked((PersonTeaserModel)person)) {
            return image;
        }
        AnchorPanel ap = new AnchorPanel();
        PersonUtil.addImage((AnchorPanel)ap, (PersonTeaserModel)person, (ImageSize)size);
        return ap;
    }

    public static void addImage(@Nonnull AnchorPanel panel, @Nonnull PersonTeaserModel person, @Nonnull ImageSize size) {
        Image icon = PersonUtil.createImageWidget((PersonTeaserModel)person, (ImageSize)size);
        panel.add((Widget)icon);
        if (PersonUtil.isProfileLinked((PersonTeaserModel)person)) {
            panel.setTargetHistoryToken("/people/profile/" + String.valueOf(person.getId()));
        } else {
            panel.addStyleName("disabled");
        }
    }

    private static Image createImageWidget(@Nonnull PersonTeaserModel person, @Nonnull ImageSize size) {
        Image image = new Image(ImageUrlUtil.getImageUrl((ImageSize)size, (ImageType)ImageType.USER_IMAGE, (String)person.getLogo()));
        image.addStyleName("userimage");
        image.addStyleName(CssClassUtil.asWellFormedAndNamespaced((String)size.name()));
        return image;
    }

    private static boolean isProfileLinked(@Nonnull PersonTeaserModel person) {
        return !person.isDeleted() && person.isVisible();
    }
}

