/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.account.presentation.ui;

import com.freiheit.toro.account.presentation.ui.SuperAdminFunctionsWidget;
import com.freiheit.toro.admin.presentation.ui.AdminMediator;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.HorizontalRule;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.freiheit.toro.util.client.WidgetUtil;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.administration.shared.i18n.AdministrationMessages;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.JCDialogBox;
import de.justsoftware.onx.common.presentation.client.ui.upload.OnUploadHandler;
import de.justsoftware.onx.common.shared.i18n.LocalizedMessages;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.document.presentation.client.ui.HtmlDocumentUploadWidget;
import de.justsoftware.onx.migration.presentation.client.ImportMediator;
import de.justsoftware.onx.migration.shared.model.ImportResult;
import de.justsoftware.onx.search.shared.model.SearchIndexType;
import de.justsoftware.onx.visibility.presentation.shared.VisibilityControllerAsync;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class SuperAdminFunctionsWidget
extends Composite {
    private final FlowPanel _panel = new FlowPanel();
    private final ClientFactory _clientFactory;

    public SuperAdminFunctionsWidget(ClientFactory clientFactory, ImmutableSet<Action> allowedActions) {
        this._clientFactory = clientFactory;
        this.initWidget((Widget)this._panel);
        this.addStyleName("superadmin-panel");
        this.addMainControls(allowedActions);
        this.addSyncControls(allowedActions);
        this.addImportControls(allowedActions);
        this.addSearchControls(allowedActions);
        this.addEntityWorkflowControls(allowedActions);
        this.addMiscControls(allowedActions);
    }

    @Nonnull
    private LocalizedMessages localizedMessages() {
        return this._clientFactory.localizedMessages();
    }

    @Nonnull
    private AdministrationMessages administrationMessages() {
        return this.localizedMessages().administration();
    }

    private void addImportControls(ImmutableSet<Action> allowedActions) {
        SuperAdminControlGroup controls = this.createControlGroup(this.administrationMessages().importExportHeader());
        if (allowedActions.contains((Object)StaticAction.ADMIN_IMPORT_EXTERNAL_PERSONS)) {
            JCButton importBtn = new JCButton(this.administrationMessages().importUsers());
            importBtn.addClickHandler(clickEvent -> {
                JCDialogBox popup = WidgetUtil.showPopUp((int)3, (String)this.administrationMessages().importStarted());
                ImportMediator.getInstance().importExternalPersons((AsyncCallback)new ImportFinishedCallback(this, popup));
            });
            controls.add((IsWidget)importBtn);
            controls.add((IsWidget)new JCButton(this.administrationMessages().uploadCSVImportFile(), clickEvent -> this.showUploadDialog("/toro/import/csv-upload", this.administrationMessages().uploadCSVImportFile(), (Iterable)ImmutableList.of((Object)".csv"), false)));
            JCButton exportCsvBtn = new JCButton(this.administrationMessages().downloadCSVImportFile(), clickEvent -> SuperAdminFunctionsWidget.downloadFile((String)"/toro/import/csv-download"));
            controls.add((IsWidget)exportCsvBtn);
            JCButton exportCsvAccountsBtn = new JCButton(this.administrationMessages().downloadCSVAccountsFile(), clickEvent -> SuperAdminFunctionsWidget.downloadFile((String)"/toro/import/csv-accounts-download"));
            controls.add((IsWidget)exportCsvAccountsBtn);
            JCButton importExternalUserGroups = new JCButton(this.administrationMessages().importExternalUserGroups());
            importExternalUserGroups.addClickHandler(clickEvent -> {
                JCDialogBox popup = WidgetUtil.showPopUp((int)3, (String)this.administrationMessages().importStarted());
                ImportMediator.getInstance().importExternalUserGroups((AsyncCallback)new ImportFinishedCallback(this, popup));
            });
            controls.add((IsWidget)importExternalUserGroups);
        }
    }

    private SuperAdminControlGroup createControlGroup(String name) {
        return new SuperAdminControlGroup(this, name);
    }

    private void addSyncControls(ImmutableSet<Action> allowedActions) {
        SuperAdminControlGroup controls = this.createControlGroup(this.administrationMessages().syncHeader());
        if (allowedActions.contains((Object)StaticAction.ADMIN_KAFKA_ADMIN)) {
            controls.addDebouncedButtonWithHelp(this.administrationMessages().syncPermissions(), this.administrationMessages().done(), this.administrationMessages().syncPermissionsHelp(), arg_0 -> ((AdminMediator)AdminMediator.getInstance()).syncAllPermissions(arg_0));
            controls.addDebouncedButtonWithHelp(this.administrationMessages().syncJustPeople(), this.administrationMessages().done(), this.administrationMessages().syncJustPeopleHelp(), arg_0 -> ((AdminMediator)AdminMediator.getInstance()).syncJustPeople(arg_0));
            controls.addDebouncedButtonWithHelp(this.administrationMessages().syncJustDrive(), this.administrationMessages().done(), this.administrationMessages().syncJustDriveHelp(), arg_0 -> ((AdminMediator)AdminMediator.getInstance()).syncJustDrive(arg_0));
            controls.addDebouncedButtonWithHelp(this.administrationMessages().syncConversationNodes(), this.administrationMessages().done(), this.administrationMessages().syncConversationNodesHelp(), arg_0 -> ((AdminMediator)AdminMediator.getInstance()).syncConversationNodes(arg_0));
            controls.addDebouncedButtonWithHelp(this.administrationMessages().syncChatPermissions(), this.administrationMessages().done(), this.administrationMessages().syncChatPermissionsHelp(), arg_0 -> ((AdminMediator)AdminMediator.getInstance()).syncChatPermissions(arg_0));
        }
    }

    private void addMiscControls(ImmutableSet<Action> allowedActions) {
        SuperAdminControlGroup controls = this.createControlGroup(this.administrationMessages().miscHeader());
        if (allowedActions.contains((Object)StaticAction.ADMIN_VISIBILITY_REINDEX)) {
            controls.addDebouncedButton(this.administrationMessages().updateVisibilities(), this.administrationMessages().updateVisibilitiesStarted(), arg_0 -> ((VisibilityControllerAsync)this._clientFactory.visibilityClientFactory().controller()).updateAll(arg_0));
        }
        if (allowedActions.contains((Object)StaticAction.ADMIN_SYSTEM_ADMINISTRATION)) {
            controls.addDebouncedButton(this.administrationMessages().adjustEntityStatus(), this.administrationMessages().adjustEntityStatusDone(), arg_0 -> ((AdminMediator)AdminMediator.getInstance()).adjustEntityStatus(arg_0));
        }
        if (allowedActions.contains((Object)StaticAction.ADMIN_SYSTEM_ADMINISTRATION)) {
            controls.addDebouncedButton(this.administrationMessages().runDriveHistoryCompactionJob(), this.administrationMessages().driveHistoryCompactionJobStarted(), arg_0 -> ((AdminMediator)AdminMediator.getInstance()).runDriveHistoryCompactionJob(arg_0));
        }
        if (allowedActions.contains((Object)StaticAction.ADMIN_MIGRATE_NOTIFICATIONS)) {
            controls.addDebouncedButton(this.administrationMessages().runNotificationMigrationJob(), this.administrationMessages().runNotificationMigrationJobStarted(), arg_0 -> ((AdminMediator)AdminMediator.getInstance()).runMigrateNotificationJob(arg_0));
        }
        if (allowedActions.contains((Object)StaticAction.ADMIN_KAFKA_ADMIN)) {
            controls.addDebouncedButton(this.administrationMessages().indexEntityAnchors(), this.administrationMessages().indexEntityAnchorsStarted(), arg_0 -> ((AdminMediator)AdminMediator.getInstance()).indexEntityAnchors(arg_0));
        }
    }

    private void addSearchControls(ImmutableSet<Action> allowedActions) {
        if (allowedActions.contains((Object)StaticAction.ADMIN_SEARCH_REINDEX)) {
            SuperAdminControlGroup searchControls = this.createControlGroup(this.administrationMessages().searchHeader());
            searchControls.addDebouncedButton(this.administrationMessages().reindexEverything(), this.administrationMessages().searchIndexingSuccessfullyTriggered(), SuperAdminFunctionsWidget.reindexSolrJustSocialCore(null));
            searchControls.addDebouncedButton(this.administrationMessages().reindexPeople(), this.administrationMessages().searchIndexingSuccessfullyTriggered(), SuperAdminFunctionsWidget.reindexSolrJustSocialCore((SearchIndexType)SearchIndexType.PEOPLE));
            searchControls.addDebouncedButton(this.administrationMessages().reindexNews(), this.administrationMessages().searchIndexingSuccessfullyTriggered(), SuperAdminFunctionsWidget.reindexSolrJustSocialCore((SearchIndexType)SearchIndexType.NEWS));
            searchControls.addDebouncedButton(this.administrationMessages().reindexWiki(), this.administrationMessages().searchIndexingSuccessfullyTriggered(), SuperAdminFunctionsWidget.reindexSolrJustSocialCore((SearchIndexType)SearchIndexType.WIKI));
            searchControls.addDebouncedButton(this.administrationMessages().reindexChats(), this.administrationMessages().searchIndexingSuccessfullyTriggered(), SuperAdminFunctionsWidget.reindexSolrJustSocialCore((SearchIndexType)SearchIndexType.CHAT));
            searchControls.addDebouncedButton(this.administrationMessages().reindexDrive(), this.administrationMessages().searchIndexingSuccessfullyTriggered(), SuperAdminFunctionsWidget.reindexSolrJustSocialCore((SearchIndexType)SearchIndexType.DRIVE));
            searchControls.addDebouncedButton(this.administrationMessages().reindexDriveMetadata(), this.administrationMessages().searchIndexingSuccessfullyTriggered(), arg_0 -> ((AdminMediator)AdminMediator.getInstance()).reindexDriveMetadata(arg_0));
            searchControls.add((IsWidget)new HorizontalRule());
            searchControls.addDebouncedButton(this.administrationMessages().reindexPeopleUserGroups(), this.administrationMessages().reindexPeopleUserGroupsStarted(), arg_0 -> ((AdminMediator)AdminMediator.getInstance()).reindexPeopleUserGroups(arg_0));
            searchControls.addDebouncedButton(this.administrationMessages().reindexChatCore(), this.administrationMessages().searchIndexingSuccessfullyTriggered(), arg_0 -> ((AdminMediator)AdminMediator.getInstance()).reindexChatCore(arg_0));
        }
    }

    private static Consumer<AsyncCallback<Void>> reindexSolrJustSocialCore(@Nullable SearchIndexType searchIndexType) {
        return callback -> AdminMediator.getInstance().reindexSolrJustSocialCore(searchIndexType, callback);
    }

    private void addEntityWorkflowControls(Set<? extends Action> allowedActions) {
        if (allowedActions.contains(StaticAction.ADMIN_SYSTEM_ADMINISTRATION)) {
            SuperAdminControlGroup controls = this.createControlGroup(this.administrationMessages().memberMigrationWorkflowHeader());
            ImmutableSet activeOrderedEntityTypes = HostPropertiesMediator.getHostPropertiesBean().getActiveOrderedEntityTypes();
            controls.add((IsWidget)new JCButton(this.administrationMessages().memberMigrationAllEntityTypes(), (ClickHandler)new MigrateEntityWorkflowMemberRolesClickHandler(this, activeOrderedEntityTypes)));
            for (EntityType entityType : activeOrderedEntityTypes) {
                controls.add((IsWidget)new JCButton(this.administrationMessages().memberMigrationOf(entityType), (ClickHandler)new MigrateEntityWorkflowMemberRolesClickHandler(this, entityType)));
            }
        }
    }

    private void addMainControls(ImmutableSet<Action> allowedActions) {
        SuperAdminControlGroup controls = this.createControlGroup(this.administrationMessages().mainHeader());
        if (allowedActions.contains((Object)StaticAction.ADMIN_FLUSH_CACHE)) {
            controls.addConfirmButton(this.administrationMessages().flushCaches(), this.administrationMessages().flushCachesQuestion(), this.administrationMessages().flushCachesDone(), arg_0 -> ((AdminMediator)AdminMediator.getInstance()).flushCache(arg_0));
            controls.addDebouncedButton(this.administrationMessages().reloadOverrideLess(), this.administrationMessages().done(), arg_0 -> ((AdminMediator)AdminMediator.getInstance()).reloadOverrideLess(arg_0));
        }
        if (allowedActions.contains((Object)StaticAction.ADMIN_RELOAD_CONFIG)) {
            controls.add((IsWidget)new JCButton(this.administrationMessages().reloadConfigFile(), clickEvent -> AdminMediator.getInstance().reloadConfigFile((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */)));
        }
        if (allowedActions.contains((Object)StaticAction.ADMIN_CSV_EXPORT)) {
            JCButton exportBtn = new JCButton(this.administrationMessages().exportPlatformMembersCsv(), clickEvent -> SuperAdminFunctionsWidget.downloadFile((String)"/toro/export/platformMembers"));
            controls.add((IsWidget)exportBtn);
        }
        if (allowedActions.contains((Object)StaticAction.ADMIN_IMPORT_EXTERNAL_PERSONS)) {
            controls.add((IsWidget)new JCButton(this.administrationMessages().licenseInformation(), clickEvent -> AdminMediator.getInstance().getLicenseInfo((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */)));
        }
    }

    private void showUploadDialog(@Nonnull String uploadURL, @Nonnull String dialogHeader, @Nonnull Iterable<String> fileTypes, boolean showMessagePopupAfterUploadComplete) {
        LoadCSRFSuccessCallback onCsrfLoaded = () -> this.newUploadDialog(uploadURL, dialogHeader, fileTypes, showMessagePopupAfterUploadComplete);
        this.loadCSRFTokenAsync(onCsrfLoaded);
    }

    @CheckForNull
    public static native String getJustToken();

    public static native void downloadFile(String var0);

    private void loadCSRFTokenAsync(LoadCSRFSuccessCallback successCallback) {
        RequestBuilder rb = new RequestBuilder(RequestBuilder.POST, URL.encode((String)"/toro/upload/csrftoken"));
        String token = SuperAdminFunctionsWidget.getJustToken();
        if (!Strings.isNullOrEmpty((String)token)) {
            rb.setHeader("just-token", token);
        }
        try {
            rb.sendRequest(null, (RequestCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (RequestException e) {
            WidgetUtil.showPopUp((int)1, (String)e.getMessage());
        }
    }

    private void newUploadDialog(@Nonnull String uploadURL, @Nonnull String dialogHeader, @Nonnull Iterable<String> fileTypes, boolean showMessagePopupAfterUploadComplete) {
        JCDialogBox dialogBox = new JCDialogBox(false, true);
        dialogBox.setText(dialogHeader);
        HtmlDocumentUploadWidget documentUploadWidget = new HtmlDocumentUploadWidget(uploadURL);
        documentUploadWidget.setAcceptedFileTypes(fileTypes);
        4 onUploadHandler = new /* Unavailable Anonymous Inner Class!! */;
        documentUploadWidget.setOnUploadHandler((OnUploadHandler)onUploadHandler);
        documentUploadWidget.setShowMessagePopUpAfterUploadComplete(showMessagePopupAfterUploadComplete);
        documentUploadWidget.setWidth("350px");
        documentUploadWidget.addCancelClickHandler(I18nMediator.BASIC_CONSTANTS.cancel(), clickEvent -> dialogBox.hide());
        dialogBox.setContent((IsWidget)documentUploadWidget);
        dialogBox.center();
    }

    private void showImportResultError() {
        WidgetUtil.showPopUp((int)0, (String)I18nMediator.IMPORT.errorCreatingImportResult());
    }

    private static int getIntValue(@Nullable JSONValue json) {
        if (json == null) {
            return 0;
        }
        JSONNumber number = json.isNumber();
        try {
            return number != null ? (int)number.doubleValue() : 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Nonnull
    private static DateWithoutTimezone getDateValue(@Nullable JSONValue json) {
        if (json == null) {
            return new DateWithoutTimezone();
        }
        JSONNumber number = json.isNumber();
        try {
            return number != null ? new DateWithoutTimezone((long)number.doubleValue()) : new DateWithoutTimezone();
        }
        catch (NumberFormatException e) {
            return new DateWithoutTimezone();
        }
    }

    @CheckForNull
    private ImportResult parseImportResultFromJSON(JSONValue json) {
        JSONObject object = json.isObject();
        if (object == null) {
            return null;
        }
        int processedCount = SuperAdminFunctionsWidget.getIntValue((JSONValue)object.get("processedCount"));
        int insertedCount = SuperAdminFunctionsWidget.getIntValue((JSONValue)object.get("insertedCount"));
        int updatedCount = SuperAdminFunctionsWidget.getIntValue((JSONValue)object.get("updatedCount"));
        int failedCount = SuperAdminFunctionsWidget.getIntValue((JSONValue)object.get("failedCount"));
        int skippedCount = SuperAdminFunctionsWidget.getIntValue((JSONValue)object.get("skippedCount"));
        int successfulImports = SuperAdminFunctionsWidget.getIntValue((JSONValue)object.get("successfulImports"));
        int failedImports = SuperAdminFunctionsWidget.getIntValue((JSONValue)object.get("failedImports"));
        DateWithoutTimezone startDate = SuperAdminFunctionsWidget.getDateValue((JSONValue)object.get("startDate"));
        DateWithoutTimezone endDate = SuperAdminFunctionsWidget.getDateValue((JSONValue)object.get("endDate"));
        return new ImportResult(processedCount, insertedCount, updatedCount, failedCount, skippedCount, startDate, endDate, successfulImports, failedImports);
    }
}

