/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.search.business;

import de.justsoftware.search.authorization.AuthorizationContext;
import de.justsoftware.search.business.PermissionService;
import de.justsoftware.search.business.SearchService;
import de.justsoftware.search.business.model.DriveFileTypeResultCount;
import de.justsoftware.search.business.model.Filter;
import de.justsoftware.search.business.model.SearchResult;
import de.justsoftware.search.business.model.SearchResultParentDto;
import de.justsoftware.search.business.model.SearchTypeResultCount;
import de.justsoftware.search.business.model.SolrSearchResult;
import de.justsoftware.search.business.model.SolrSearchResultDto;
import de.justsoftware.search.model.JustSocialSolrCoreSearchFields;
import de.justsoftware.search.shared.model.GlobalAdditionalFields;
import de.justsoftware.search.shared.model.ProfileId;
import de.justsoftware.search.shared.model.SearchDriveFileType;
import de.justsoftware.search.shared.model.SearchParam;
import de.justsoftware.search.shared.model.SearchResponse;
import de.justsoftware.search.shared.model.SearchType;
import de.justsoftware.search.shared.model.SearchableId;
import de.justsoftware.search.shared.model.SortBy;
import de.justsoftware.search.shared.model.SortDirection;
import de.justsoftware.search.util.CollectionUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 %2\u00020\u0001:\u0001%B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007JB\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J+\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\u0019\b\u0002\u0010\u001d\u001a\u0013\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\u0002\b H\u0012J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0012J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001bH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lde/justsoftware/search/business/SearchService;", "", "solrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "permissionService", "Lde/justsoftware/search/business/PermissionService;", "<init>", "(Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/search/business/PermissionService;)V", "search", "Lde/justsoftware/search/business/model/SearchResult;", "authContext", "Lde/justsoftware/search/authorization/AuthorizationContext;", "query", "", "offset", "", "count", "filters", "Lde/justsoftware/search/business/model/Filter;", "sortBy", "Lde/justsoftware/search/shared/model/SortBy;", "sortDirection", "Lde/justsoftware/search/shared/model/SortDirection;", "Lde/justsoftware/search/shared/model/SearchResponse;", "searchParam", "Lde/justsoftware/search/shared/model/SearchParam;", "buildSolrQuery", "Lorg/apache/solr/client/solrj/SolrQuery;", "params", "configure", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "buildSolrQueryForNames", "send", "Lorg/apache/solr/client/solrj/response/QueryResponse;", "solrQuery", "Companion", "search-service"})
@SourceDebugExtension(value={"SMAP\nSearchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchService.kt\nde/justsoftware/search/business/SearchService\n+ 2 CollectionUtils.kt\nde/justsoftware/search/util/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 LoggerUtils.kt\nde/justsoftware/search/util/LoggerUtilsKt\n*L\n1#1,308:1\n10#2:309\n1619#3:310\n1863#3:311\n1864#3:313\n1620#3:314\n1187#3,2:315\n1261#3,4:317\n1557#3:321\n1628#3,3:322\n1557#3:325\n1628#3,3:326\n1557#3:329\n1628#3,3:330\n1#4:312\n8#5:333\n7#5,3:334\n*S KotlinDebug\n*F\n+ 1 SearchService.kt\nde/justsoftware/search/business/SearchService\n*L\n88#1:309\n88#1:310\n88#1:311\n88#1:313\n88#1:314\n98#1:315,2\n98#1:317,4\n105#1:321\n105#1:322,3\n111#1:325\n111#1:326,3\n118#1:329\n118#1:330,3\n88#1:312\n195#1:333\n195#1:334,3\n*E\n"})
public class SearchService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SolrClient solrClient;
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String SEARCH_TYPE_FILTER_TAG = "search_type_filter";
    @NotNull
    private static final String FILE_TYPE_FILTER_TAG = "file_type_filter";
    @NotNull
    private static final String FILE_TYPE_FILTER_FIELD;
    @NotNull
    private static final String REQUESTED_FIELDS;
    @NotNull
    private static final String REQUESTED_FIELDS_FOR_PARENT_INFO;

    public SearchService(@Qualifier(value="justSocialCoreLeaderSolrClient") @NotNull SolrClient solrClient, @NotNull PermissionService permissionService) {
        Intrinsics.checkNotNullParameter((Object)solrClient, (String)"solrClient");
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        this.solrClient = solrClient;
        this.permissionService = permissionService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public SearchResult search(@NotNull AuthorizationContext authContext, @NotNull String query, int offset, int count, @Nullable Filter filters, @NotNull SortBy sortBy, @NotNull SortDirection sortDirection) {
        List list;
        Collection<SolrSearchResultDto> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list2;
        void $this$map$iv2;
        Object v8;
        Iterable $i$f$map2;
        List searchTypeResultCounts;
        Object object;
        Object destination$iv$iv4;
        List $this$map$iv3;
        Iterable capacity$iv2;
        Map parentInfo;
        SearchResponse searchResponse;
        QueryResponse searchQueryResponse;
        block16: {
            List list3;
            Object v4;
            Iterable $this$associateTo$iv$iv2;
            block15: {
                Object object2;
                Object element$iv$iv;
                void $this$mapNotNullTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
                Intrinsics.checkNotNullParameter((Object)query, (String)"query");
                Intrinsics.checkNotNullParameter((Object)sortBy, (String)"sortBy");
                Intrinsics.checkNotNullParameter((Object)sortDirection, (String)"sortDirection");
                searchQueryResponse = this.send(this.buildSolrQuery(new SearchParam(authContext.getTenantId(), authContext.getProfileId(), query, null, null, null, null, null, null, null, null, null, null, null, null, null, false, offset, count, sortBy, sortDirection, 131064, null), arg_0 -> SearchService.search$lambda$0(filters, arg_0)));
                searchResponse = Companion.access$toSearchResponse((Companion)Companion, (QueryResponse)searchQueryResponse);
                Iterable $this$mapNotNullToSet$iv = searchResponse.getResults();
                boolean $i$f$mapNotNullToSet2 = false;
                Iterable iterable = $this$mapNotNullToSet$iv;
                String[] destination$iv$iv2 = (String[])new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
                boolean $i$f$mapNotNullTo2 = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                    String it$iv$iv;
                    element$iv$iv = element$iv$iv$iv;
                    boolean bl = false;
                    de.justsoftware.search.shared.model.SearchResult it = (de.justsoftware.search.shared.model.SearchResult)element$iv$iv;
                    boolean bl2 = false;
                    SearchableId searchableId = it.getParentId();
                    if ((searchableId != null ? searchableId.toCanonicalId() : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Set parentIds = (Set)destination$iv$iv2;
                if (parentIds.isEmpty()) {
                    object2 = MapsKt.emptyMap();
                } else {
                    void $this$associateTo$iv$iv2;
                    void $this$associate$iv;
                    destination$iv$iv2 = new String[]{CollectionsKt.joinToString$default((Iterable)parentIds, (CharSequence)" OR ", null, null, (int)0, null, SearchService::search$lambda$2, (int)30, null)};
                    SolrQuery solrQuery = this.buildSolrQueryForNames(count).addFilterQuery(destination$iv$iv2).setHighlight(false);
                    Intrinsics.checkNotNullExpressionValue((Object)solrQuery, (String)"setHighlight(...)");
                    Iterable $i$f$mapNotNullToSet2 = this.send(solrQuery).getBeans(SolrSearchResult.class);
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapNotNullToSet2, (String)"getBeans(...)");
                    $i$f$mapNotNullToSet2 = $i$f$mapNotNullToSet2;
                    boolean $i$f$associate = false;
                    int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    void $i$f$mapNotNullTo2 = $this$associate$iv;
                    Map destination$iv$iv3 = new LinkedHashMap(capacity$iv2);
                    boolean $i$f$associateTo = false;
                    for (Object element$iv$iv2 : $this$associateTo$iv$iv2) {
                        element$iv$iv = destination$iv$iv3;
                        SolrSearchResult it = (SolrSearchResult)element$iv$iv2;
                        boolean bl = false;
                        it = TuplesKt.to((Object)it.getId(), (Object)new SearchResultParentDto(it.getId(), it.getName(), SearchType.valueOf((String)it.getType())));
                        element$iv$iv.put(it.getFirst(), it.getSecond());
                    }
                    object2 = destination$iv$iv3;
                }
                parentInfo = object2;
                List list4 = searchQueryResponse.getFacetFields();
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getFacetFields(...)");
                $this$associateTo$iv$iv2 = list4;
                for (Object $i$f$associateTo : $this$associateTo$iv$iv2) {
                    FacetField it = (FacetField)$i$f$associateTo;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"type")) continue;
                    v4 = $i$f$associateTo;
                    break block15;
                }
                v4 = null;
            }
            FacetField $i$f$associate = v4;
            if ($i$f$associate != null && (capacity$iv2 = $i$f$associate.getValues()) != null) {
                void $this$mapTo$iv$iv2;
                $this$associateTo$iv$iv2 = capacity$iv2;
                boolean $i$f$map2 = false;
                void $i$f$associateTo = $this$map$iv3;
                destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it;
                    FacetField.Count bl = (FacetField.Count)item$iv$iv2;
                    object = destination$iv$iv4;
                    boolean bl4 = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    object.add((SearchTypeResultCount)new SearchTypeResultCount(SearchType.valueOf((String)string), (Number)it.getCount()));
                }
                list3 = (List)destination$iv$iv4;
            } else {
                list3 = null;
            }
            searchTypeResultCounts = list3;
            List list5 = searchQueryResponse.getFacetFields();
            Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"getFacetFields(...)");
            $i$f$map2 = list5;
            for (Object destination$iv$iv4 : $i$f$map2) {
                FacetField it = (FacetField)destination$iv$iv4;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)FILE_TYPE_FILTER_FIELD)) continue;
                v8 = destination$iv$iv4;
                break block16;
            }
            v8 = null;
        }
        capacity$iv2 = v8;
        if (capacity$iv2 != null && ($this$map$iv3 = capacity$iv2.getValues()) != null) {
            void $this$mapTo$iv$iv3;
            $i$f$map2 = $this$map$iv3;
            boolean $i$f$map3 = false;
            destination$iv$iv4 = $this$map$iv2;
            Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                void it;
                FacetField.Count bl4 = (FacetField.Count)item$iv$iv;
                object = destination$iv$iv5;
                boolean bl = false;
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                object.add(new DriveFileTypeResultCount(SearchDriveFileType.valueOf((String)string), (Number)it.getCount()));
            }
            list2 = (List)destination$iv$iv5;
        } else {
            list2 = null;
        }
        List fileTypeResultCounts = list2;
        capacity$iv2 = searchResponse.getResults();
        long l = searchQueryResponse.getResults().getNumFound();
        long l2 = searchQueryResponse.getResults().getStart() + (long)searchQueryResponse.getResults().size();
        boolean $i$f$map4 = false;
        $this$map$iv2 = $this$map$iv;
        Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            de.justsoftware.search.shared.model.SearchResult item$iv$iv2 = (de.justsoftware.search.shared.model.SearchResult)item$iv$iv;
            collection = destination$iv$iv6;
            boolean bl = false;
            Map map = parentInfo;
            SearchableId searchableId = it.getParentId();
            collection.add(SolrSearchResultDto.Companion.toDto((de.justsoftware.search.shared.model.SearchResult)it, (SearchResultParentDto)map.get(searchableId != null ? searchableId.toCanonicalId() : null)));
        }
        collection = (List)destination$iv$iv6;
        List list6 = searchTypeResultCounts;
        if (list6 == null) {
            list6 = CollectionsKt.emptyList();
        }
        if ((list = fileTypeResultCounts) == null) {
            list = CollectionsKt.emptyList();
        }
        List list7 = list;
        List list8 = list6;
        List list9 = collection;
        long l3 = l;
        long l4 = l2;
        return new SearchResult(l4, l3, list9, list8, list7);
    }

    @NotNull
    public SearchResponse search(@NotNull SearchParam searchParam) {
        Intrinsics.checkNotNullParameter((Object)searchParam, (String)"searchParam");
        QueryResponse response = this.send(SearchService.buildSolrQuery$default((SearchService)this, (SearchParam)searchParam, null, (int)2, null));
        return Companion.access$toSearchResponse((Companion)Companion, (QueryResponse)response);
    }

    private SolrQuery buildSolrQuery(SearchParam params, Function1<? super SolrQuery, Unit> configure) {
        Object[] objectArray;
        Date modifiedBefore;
        Date modifiedAfter;
        String[] stringArray;
        SolrQuery solrQuery;
        SolrQuery $this$buildSolrQuery_u24lambda_u2410 = solrQuery = new SolrQuery();
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)params.getQuery())) {
            $this$buildSolrQuery_u24lambda_u2410.setQuery(params.getQuery());
        }
        $this$buildSolrQuery_u24lambda_u2410.setHighlight(true);
        String[] stringArray2 = new String[]{Companion.access$toSortField((Companion)Companion, (SortBy)params.getSortBy()) + " " + (params.getSortDirection() == SortDirection.ASC ? "asc" : "desc")};
        $this$buildSolrQuery_u24lambda_u2410.add("sort", stringArray2);
        stringArray2 = new String[]{String.valueOf(params.getOffset())};
        $this$buildSolrQuery_u24lambda_u2410.set("start", stringArray2);
        stringArray2 = new String[]{String.valueOf(params.getCount())};
        $this$buildSolrQuery_u24lambda_u2410.set("rows", stringArray2);
        stringArray2 = new String[]{REQUESTED_FIELDS + (params.getIncludeContent() ? ", content" : "")};
        $this$buildSolrQuery_u24lambda_u2410.set("fl", stringArray2);
        stringArray2 = new String[]{params.getTenantId().toCanonicalId()};
        $this$buildSolrQuery_u24lambda_u2410.add("tenantId", stringArray2);
        ProfileId profileId = params.getSearcherId();
        if (profileId != null) {
            String searchRoles = CollectionsKt.joinToString$default((Iterable)this.permissionService.getSearchRoles(profileId), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            stringArray = new String[]{searchRoles};
            $this$buildSolrQuery_u24lambda_u2410.add("justRoles", stringArray);
        }
        if ((modifiedAfter = params.getModifiedAfter()) != null) {
            stringArray = new String[]{"modify_date:{" + modifiedAfter.toInstant() + " TO *]"};
            $this$buildSolrQuery_u24lambda_u2410.addFilterQuery(stringArray);
        }
        if ((modifiedBefore = params.getModifiedBefore()) != null) {
            objectArray = new String[]{"modify_date:[* TO " + modifiedBefore.toInstant() + "}"};
            $this$buildSolrQuery_u24lambda_u2410.addFilterQuery((String[])objectArray);
        }
        Companion.addFieldFilterQuery$default((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u2410, (String)"type", (Collection)params.getType(), null, (int)4, null);
        Companion.addFieldFilterQuery$default((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u2410, (String)"just_app_id", (Collection)params.getApp(), null, (int)4, null);
        objectArray = new String[]{"name", "name_substring"};
        Companion.access$addEDisMaxFilterQueries((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u2410, (List)CollectionsKt.listOf((Object[])objectArray), (String)params.getName());
        Companion.access$addEDisMaxFilterQueries((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u2410, (String)"content", (String)params.getContent());
        Companion.access$addFieldFilterQuery((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u2410, (String)"tags", (Collection)params.getTag(), (String)" AND ");
        Companion.addFieldFilterQuery$default((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u2410, (String)"id", (Collection)params.getId(), null, (int)4, null);
        Companion.addFieldFilterQuery$default((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u2410, (String)"!id", (Collection)params.getExcludeId(), null, (int)4, null);
        Companion.addFieldFilterQuery$default((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u2410, (String)"parent_id", (Collection)params.getParentId(), null, (int)4, null);
        Companion.access$addDynamicFieldFilters((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u2410, (String)"searchable_fields_", (Map)params.getSearchableFields());
        Companion.access$addDynamicFieldFilters((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u2410, (String)"additional_fields_", (Map)params.getAdditionalFields());
        Companion.access$addDynamicFieldFilters((Companion)Companion, (SolrQuery)$this$buildSolrQuery_u24lambda_u2410, (String)"!additional_fields_", (Map)params.getExcludeAdditionalFields());
        $this$buildSolrQuery_u24lambda_u2410.setRequestHandler("justSearch");
        configure.invoke((Object)$this$buildSolrQuery_u24lambda_u2410);
        return solrQuery;
    }

    static /* synthetic */ SolrQuery buildSolrQuery$default(SearchService searchService, SearchParam searchParam, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildSolrQuery");
        }
        if ((n & 2) != 0) {
            function1 = SearchService::buildSolrQuery$lambda$9;
        }
        return searchService.buildSolrQuery(searchParam, function1);
    }

    private SolrQuery buildSolrQueryForNames(int count) {
        SolrQuery solrQuery;
        SolrQuery $this$buildSolrQueryForNames_u24lambda_u2411 = solrQuery = new SolrQuery();
        boolean bl = false;
        String[] stringArray = new String[]{REQUESTED_FIELDS_FOR_PARENT_INFO};
        $this$buildSolrQueryForNames_u24lambda_u2411.set("fl", stringArray);
        stringArray = new String[]{String.valueOf(count)};
        $this$buildSolrQueryForNames_u24lambda_u2411.set("rows", stringArray);
        return solrQuery;
    }

    private QueryResponse send(SolrQuery solrQuery) {
        QueryResponse queryResponse;
        try {
            queryResponse = this.solrClient.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
        }
        catch (Exception e) {
            LOG.error("Error occurred while executing query " + solrQuery, (Throwable)e);
            throw e;
        }
        return queryResponse;
    }

    private static final Unit search$lambda$0(Filter $filters, SolrQuery $this$buildSolrQuery) {
        Intrinsics.checkNotNullParameter((Object)$this$buildSolrQuery, (String)"$this$buildSolrQuery");
        String[] stringArray = new String[]{"{!ex=search_type_filter}type"};
        $this$buildSolrQuery.addFacetField(stringArray);
        stringArray = new String[]{"{!ex=file_type_filter}" + FILE_TYPE_FILTER_FIELD};
        $this$buildSolrQuery.addFacetField(stringArray);
        Filter filter = $filters;
        if ((filter != null ? filter.getApp() : null) != null) {
            stringArray = new String[]{"just_app_id:" + $filters.getApp()};
            $this$buildSolrQuery.addFilterQuery(stringArray);
        }
        Filter filter2 = $filters;
        if ((filter2 != null ? filter2.getSearchType() : null) != null) {
            stringArray = new String[]{"{!tag=search_type_filter}type:" + $filters.getSearchType()};
            $this$buildSolrQuery.addFilterQuery(stringArray);
        }
        Filter filter3 = $filters;
        if ((filter3 != null ? filter3.getFileType() : null) != null) {
            stringArray = new String[]{"{!tag=file_type_filter}" + FILE_TYPE_FILTER_FIELD + ":" + $filters.getFileType()};
            $this$buildSolrQuery.addFilterQuery(stringArray);
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence search$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "id:" + it;
    }

    private static final Unit buildSolrQuery$lambda$9(SolrQuery solrQuery) {
        Intrinsics.checkNotNullParameter((Object)solrQuery, (String)"<this>");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        FILE_TYPE_FILTER_FIELD = "additional_fields_" + GlobalAdditionalFields.FILE_TYPE;
        JustSocialSolrCoreSearchFields $this$REQUESTED_FIELDS_u24lambda_u2412 = JustSocialSolrCoreSearchFields.INSTANCE;
        boolean bl = false;
        REQUESTED_FIELDS = "id, type, just_app_id, modify_date, name, parent_id, additional_fields_*";
        JustSocialSolrCoreSearchFields $this$REQUESTED_FIELDS_FOR_PARENT_INFO_u24lambda_u2413 = JustSocialSolrCoreSearchFields.INSTANCE;
        boolean bl2 = false;
        REQUESTED_FIELDS_FOR_PARENT_INFO = "id, name, type";
    }
}

