/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.business.item.impl;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.permission.business.item.ItemService;
import de.justsoftware.permission.business.item.model.Item;
import de.justsoftware.permission.business.item.model.ItemId;
import de.justsoftware.permission.persistence.ItemDAO;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ItemServiceImpl
implements ItemService {
    private final ItemDAO _dao;

    @Autowired
    public ItemServiceImpl(ItemDAO itemDAO) {
        this._dao = itemDAO;
    }

    public void storeItems(List<Item> items) {
        this._dao.storeItems(items);
    }

    public void deleteItems(Set<ItemId> itemIds) {
        this._dao.deleteItems(itemIds);
    }

    public ImmutableListMultimap<ItemId, Item> getPaths(Set<ItemId> itemIds) {
        HashSet<ItemId> missing = new HashSet<ItemId>(itemIds);
        HashSet<ItemId> loaded = new HashSet<ItemId>();
        HashMap allItems = new HashMap();
        while (!missing.isEmpty()) {
            ImmutableMap byId = this._dao.getByIds((Set)ImmutableSet.copyOf(missing));
            allItems.putAll(byId);
            loaded.addAll(missing);
            missing.clear();
            for (Item item : byId.values()) {
                item.getParentId().ifPresent(parentId -> {
                    if (!loaded.contains(parentId)) {
                        missing.add((ItemId)parentId);
                    }
                });
            }
        }
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        for (Item item : allItems.values()) {
            Optional currentId;
            LinkedList<Item> items = new LinkedList<Item>();
            Item currentItem = item;
            do {
                items.addFirst(currentItem);
                currentId = currentItem.getParentId();
                if (currentId.isPresent()) continue;
                result.putAll((Object)item.getId(), items);
            } while ((currentItem = (Item)allItems.get(currentId.orElse(null))) != null);
        }
        return result.build();
    }
}

