/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.connector.notification;

import de.justsoftware.news.connector.notification.NotificationConnector;
import de.justsoftware.news.domain.channel.Channel;
import de.justsoftware.news.domain.channel.ChannelRepo;
import de.justsoftware.news.domain.comment.PostComment;
import de.justsoftware.news.domain.comment.PostCommentRepo;
import de.justsoftware.news.domain.commentNotifications.CommentNotificationsReceivers;
import de.justsoftware.news.domain.commentNotifications.CommentNotificationsRepo;
import de.justsoftware.news.domain.post.Post;
import de.justsoftware.news.domain.post.PostRepo;
import de.justsoftware.news.domain.reaction.Reaction;
import de.justsoftware.news.domain.reaction.ReactionRepo;
import de.justsoftware.news.domain.settings.SettingsRepo;
import de.justsoftware.news.domain.subscription.SubscriptionRepoWrapper;
import de.justsoftware.news.domain.user.Profile;
import de.justsoftware.news.domain.user.ProfileRepo;
import de.justsoftware.news.events.PostCommentCreatedEvent;
import de.justsoftware.news.events.PostCommentUpdatedMentionsEvent;
import de.justsoftware.news.events.PostDeletedEvent;
import de.justsoftware.news.events.PostPublishedEvent;
import de.justsoftware.news.events.PostReadEvent;
import de.justsoftware.news.events.PostUpdatedMentions;
import de.justsoftware.news.id.CommentId;
import de.justsoftware.news.id.ItemId;
import de.justsoftware.news.id.LikeableId;
import de.justsoftware.news.id.ProfileId;
import de.justsoftware.news.id.TenantId;
import de.justsoftware.news.id.UserId;
import de.justsoftware.news.util.QuillUtils;
import de.justsoftware.notificationclient.NotificationProducer;
import de.justsoftware.notificationclient.model.Notification;
import de.justsoftware.notificationclient.model.NotificationBuilder;
import de.justsoftware.notificationclient.model.NotificationType;
import io.micrometer.observation.annotation.Observed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Observed
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 >2\u00020\u0001:\u0002>?BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001dH\u0017J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001fH\u0017J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020!H\u0017J\u0010\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020#H\u0017J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020%H\u0017J@\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\b\u00101\u001a\u0004\u0018\u000102H\u0012J6\u00103\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0012J6\u00104\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0012J6\u00105\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0012J6\u00106\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0012JV\u00107\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u00108\u001a\u0002092\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020\u00170;2\n\b\u0002\u0010=\u001a\u0004\u0018\u000102H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092D\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lde/justsoftware/news/connector/notification/NotificationConnector;", "", "channelRepo", "Lde/justsoftware/news/domain/channel/ChannelRepo;", "commentRepo", "Lde/justsoftware/news/domain/comment/PostCommentRepo;", "commentNotificationsRepo", "Lde/justsoftware/news/domain/commentNotifications/CommentNotificationsRepo;", "notificationProducer", "Lde/justsoftware/notificationclient/NotificationProducer;", "postRepo", "Lde/justsoftware/news/domain/post/PostRepo;", "profileRepo", "Lde/justsoftware/news/domain/user/ProfileRepo;", "settingsRepo", "Lde/justsoftware/news/domain/settings/SettingsRepo;", "subscriptionRepoWrapper", "Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;", "reactionRepo", "Lde/justsoftware/news/domain/reaction/ReactionRepo;", "<init>", "(Lde/justsoftware/news/domain/channel/ChannelRepo;Lde/justsoftware/news/domain/comment/PostCommentRepo;Lde/justsoftware/news/domain/commentNotifications/CommentNotificationsRepo;Lde/justsoftware/notificationclient/NotificationProducer;Lde/justsoftware/news/domain/post/PostRepo;Lde/justsoftware/news/domain/user/ProfileRepo;Lde/justsoftware/news/domain/settings/SettingsRepo;Lde/justsoftware/news/domain/subscription/SubscriptionRepoWrapper;Lde/justsoftware/news/domain/reaction/ReactionRepo;)V", "appId", "", "postPublished", "", "event", "Lde/justsoftware/news/events/PostPublishedEvent;", "postRead", "Lde/justsoftware/news/events/PostReadEvent;", "postUpdatedMentions", "Lde/justsoftware/news/events/PostUpdatedMentions;", "postCommentCreated", "Lde/justsoftware/news/events/PostCommentCreatedEvent;", "postDeleted", "Lde/justsoftware/news/events/PostDeletedEvent;", "postCommentUpdatedMentions", "Lde/justsoftware/news/events/PostCommentUpdatedMentionsEvent;", "sendForPublishedPost", "tenantId", "Lde/justsoftware/news/id/TenantId;", "channelTitle", "post", "Lde/justsoftware/news/domain/post/Post;", "author", "Lde/justsoftware/news/domain/user/Profile;", "receiverIds", "", "Lde/justsoftware/news/id/UserId;", "additionalMailInfo", "Lde/justsoftware/news/connector/notification/NotificationConnector$MailInfo;", "sendForMentionedInComment", "sendForMentionedInPost", "sendForNewCommentResponse", "sendForNewComment", "sendNotifications", "notificationType", "Lde/justsoftware/notificationclient/model/NotificationType;", "localText", "", "Ljava/util/Locale;", "mailInfo", "Companion", "MailInfo", "news-service"})
@SourceDebugExtension(value={"SMAP\nNotificationConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationConnector.kt\nde/justsoftware/news/connector/notification/NotificationConnector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,393:1\n774#2:394\n865#2,2:395\n774#2:397\n865#2,2:398\n1557#2:400\n1628#2,3:401\n1557#2:404\n1628#2,3:405\n1557#2:408\n1628#2,3:409\n1557#2:412\n1628#2,3:413\n1#3:416\n*S KotlinDebug\n*F\n+ 1 NotificationConnector.kt\nde/justsoftware/news/connector/notification/NotificationConnector\n*L\n64#1:394\n64#1:395,2\n89#1:397\n89#1:398,2\n158#1:400\n158#1:401,3\n175#1:404\n175#1:405,3\n179#1:408\n179#1:409,3\n360#1:412\n360#1:413,3\n*E\n"})
public class NotificationConnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelRepo channelRepo;
    @NotNull
    private final PostCommentRepo commentRepo;
    @NotNull
    private final CommentNotificationsRepo commentNotificationsRepo;
    @NotNull
    private final NotificationProducer notificationProducer;
    @NotNull
    private final PostRepo postRepo;
    @NotNull
    private final ProfileRepo profileRepo;
    @NotNull
    private final SettingsRepo settingsRepo;
    @NotNull
    private final SubscriptionRepoWrapper subscriptionRepoWrapper;
    @NotNull
    private final ReactionRepo reactionRepo;
    @NotNull
    private final String appId;
    @NotNull
    private static final Logger log;

    public NotificationConnector(@NotNull ChannelRepo channelRepo, @NotNull PostCommentRepo commentRepo, @NotNull CommentNotificationsRepo commentNotificationsRepo, @NotNull NotificationProducer notificationProducer, @NotNull PostRepo postRepo, @NotNull ProfileRepo profileRepo, @NotNull SettingsRepo settingsRepo, @NotNull SubscriptionRepoWrapper subscriptionRepoWrapper, @NotNull ReactionRepo reactionRepo) {
        Intrinsics.checkNotNullParameter((Object)channelRepo, (String)"channelRepo");
        Intrinsics.checkNotNullParameter((Object)commentRepo, (String)"commentRepo");
        Intrinsics.checkNotNullParameter((Object)commentNotificationsRepo, (String)"commentNotificationsRepo");
        Intrinsics.checkNotNullParameter((Object)notificationProducer, (String)"notificationProducer");
        Intrinsics.checkNotNullParameter((Object)postRepo, (String)"postRepo");
        Intrinsics.checkNotNullParameter((Object)profileRepo, (String)"profileRepo");
        Intrinsics.checkNotNullParameter((Object)settingsRepo, (String)"settingsRepo");
        Intrinsics.checkNotNullParameter((Object)subscriptionRepoWrapper, (String)"subscriptionRepoWrapper");
        Intrinsics.checkNotNullParameter((Object)reactionRepo, (String)"reactionRepo");
        this.channelRepo = channelRepo;
        this.commentRepo = commentRepo;
        this.commentNotificationsRepo = commentNotificationsRepo;
        this.notificationProducer = notificationProducer;
        this.postRepo = postRepo;
        this.profileRepo = profileRepo;
        this.settingsRepo = settingsRepo;
        this.subscriptionRepoWrapper = subscriptionRepoWrapper;
        this.reactionRepo = reactionRepo;
        this.appId = "news";
    }

    /*
     * WARNING - void declaration
     */
    @Async
    @EventListener(value={PostPublishedEvent.class})
    public void postPublished(@NotNull PostPublishedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            ProfileId it;
            void $this$filterTo$iv$iv2;
            if (!event.getCreateNotification()) {
                return;
            }
            Iterable $this$filter$iv2 = this.subscriptionRepoWrapper.getNotificationSubscribers(event.getPost().getChannelId());
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (ProfileId)element$iv$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)event.getPost().getAuthorId()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List channelSubscribers = (List)destination$iv$iv;
            Profile author = this.profileRepo.getById(event.getPost().getAuthorId());
            Channel channel = this.channelRepo.getByIdAndDeletedFalse(event.getPost().getChannelId());
            boolean allowAdditionalInfoInMailNotification = this.settingsRepo.getByTenantId(event.getTenantId()).getAllowAdditionalInfoInMailNotification();
            MailInfo additionalMailInfo = allowAdditionalInfoInMailNotification ? new MailInfo(author.getName(), event.getPost().getText()) : null;
            this.sendForPublishedPost(event.getTenantId(), channel.getTitle(), event.getPost(), author, (Collection)channelSubscribers, additionalMailInfo);
            Iterable iterable2 = QuillUtils.Companion.extractMentions(event.getPost().getJsonContent());
            boolean $i$f$filter2 = false;
            it = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                UserId it2 = (UserId)element$iv$iv;
                boolean bl = false;
                if (!(!CollectionsKt.contains((Iterable)channelSubscribers, (Object)it2))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List mentions = (List)destination$iv$iv2;
            this.sendForMentionedInPost(event.getTenantId(), channel.getTitle(), event.getPost(), author, (Collection)mentions);
        }
        catch (Exception exception) {
            log.error("Error sending notifications for published Post.", (Throwable)exception);
        }
    }

    @Async
    @EventListener
    public void postRead(@NotNull PostReadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.notificationProducer.archiveAllNotificationsFor(event.getPostId().toTypedString(), SetsKt.setOf((Object)NotificationType.POSTING_ON_SUBSCRIPTION), event.getProfileId().toTypedString());
    }

    @Async
    @EventListener(value={PostUpdatedMentions.class})
    public void postUpdatedMentions(@NotNull PostUpdatedMentions event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            Profile author = this.profileRepo.getById(event.getPost().getAuthorId());
            Channel channel = this.channelRepo.getByIdAndDeletedFalse(event.getPost().getChannelId());
            this.sendForMentionedInPost(event.getTenantId(), channel.getTitle(), event.getPost(), author, event.getNewMentions());
        }
        catch (Exception exception) {
            log.error("Error sending notifications for new mentions in updated Comment.", (Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Async
    @EventListener(value={PostCommentCreatedEvent.class})
    public void postCommentCreated(@NotNull PostCommentCreatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            Post post = this.postRepo.getByIdAndDeletedFalse(event.getPostId());
            Channel channel = this.channelRepo.getByIdAndDeletedFalse(post.getChannelId());
            Profile commentAuthor = this.profileRepo.getById(event.getAuthorId());
            CommentNotificationsReceivers commentNotificationsReceivers = this.commentNotificationsRepo.getProfileIds(post.getId());
            Set profilesNotificationOn = commentNotificationsReceivers.component1();
            Set profilesNotificationOff = commentNotificationsReceivers.component2();
            Set mentions = QuillUtils.Companion.extractMentions(event.getJsonContent());
            this.sendForMentionedInComment(event.getTenantId(), channel.getTitle(), post, commentAuthor, (Collection)mentions);
            Set noReceivers = SetsKt.plus((Set)SetsKt.plus((Set)profilesNotificationOff, (Object)event.getAuthorId()), (Iterable)mentions);
            if (event.getParentId() instanceof CommentId) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                ProfileId initialCommentAuthor = this.commentRepo.getById((CommentId)event.getParentId()).getAuthorId();
                Iterable iterable = this.commentRepo.findAllByParentIdOrderByCreatedAtAsc((ItemId)event.getParentId());
                boolean $i$f$map = false;
                void var14_19 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    void it;
                    PostComment postComment = (PostComment)item$iv$iv2;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getAuthorId());
                }
                Set otherAnsweringAuthors = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                Set receivers = SetsKt.minus((Set)SetsKt.plus((Set)SetsKt.plus((Set)profilesNotificationOn, (Iterable)otherAnsweringAuthors), (Object)initialCommentAuthor), (Iterable)noReceivers);
                this.sendForNewCommentResponse(event.getTenantId(), channel.getTitle(), post, commentAuthor, (Collection)receivers);
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Collection collection;
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                Iterable otherAnsweringAuthors = this.reactionRepo.findAllByItemId((LikeableId)event.getPostId());
                boolean $i$f$map22 = false;
                void $i$f$map = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    Object item$iv$iv2 = (Reaction)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getProfileId());
                }
                Set likers = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                Iterable $i$f$map22 = this.commentRepo.findAllByParentIdOrderByCreatedAtAsc((ItemId)event.getPostId());
                boolean $i$f$map3 = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    void it;
                    PostComment bl = (PostComment)item$iv$iv2;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(it.getAuthorId());
                }
                Set commentators = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                Set receivers = SetsKt.minus((Set)SetsKt.plus((Set)SetsKt.plus((Set)SetsKt.plus((Set)profilesNotificationOn, (Iterable)likers), (Iterable)commentators), (Object)post.getAuthorId()), (Iterable)noReceivers);
                this.sendForNewComment(event.getTenantId(), channel.getTitle(), post, commentAuthor, (Collection)receivers);
            }
        }
        catch (Exception exception) {
            log.error("Error sending notifications for new Comment.", (Throwable)exception);
        }
    }

    @Async
    @EventListener(value={PostDeletedEvent.class})
    public void postDeleted(@NotNull PostDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.notificationProducer.deleteAllNotificationsFor(event.getPostId().toTypedString());
    }

    @Async
    @EventListener(value={PostCommentUpdatedMentionsEvent.class})
    public void postCommentUpdatedMentions(@NotNull PostCommentUpdatedMentionsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            Post post = this.postRepo.getByIdAndDeletedFalse(event.getPostId());
            Channel channel = this.channelRepo.getByIdAndDeletedFalse(post.getChannelId());
            Profile author = this.profileRepo.getById(post.getAuthorId());
            this.sendForMentionedInComment(event.getTenantId(), channel.getTitle(), post, author, event.getNewMentions());
        }
        catch (Exception exception) {
            log.error("Error sending notifications for mentions in updated Comment.", (Throwable)exception);
        }
    }

    private void sendForPublishedPost(TenantId tenantId, String channelTitle, Post post, Profile author, Collection<? extends UserId> receiverIds, MailInfo additionalMailInfo) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Locale.GERMAN, (Object)(author.getName() + " hat den Beitrag ver\u00f6ffentlicht.")), TuplesKt.to((Object)Locale.ENGLISH, (Object)(author.getName() + " has published a post."))};
        Map localText = MapsKt.mapOf((Pair[])pairArray);
        this.sendNotifications(tenantId, channelTitle, post, receiverIds, NotificationType.POSTING_ON_SUBSCRIPTION, localText, additionalMailInfo);
    }

    private void sendForMentionedInComment(TenantId tenantId, String channelTitle, Post post, Profile author, Collection<? extends UserId> receiverIds) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Locale.GERMAN, (Object)(author.getName() + " hat dich in einem Kommentar erw\u00e4hnt.")), TuplesKt.to((Object)Locale.ENGLISH, (Object)(author.getName() + " mentioned you in a comment."))};
        Map localText = MapsKt.mapOf((Pair[])pairArray);
        NotificationConnector.sendNotifications$default((NotificationConnector)this, (TenantId)tenantId, (String)channelTitle, (Post)post, receiverIds, (NotificationType)NotificationType.COMMENT_ON_WORKSTREAM_WITH_MENTION, (Map)localText, null, (int)64, null);
    }

    private void sendForMentionedInPost(TenantId tenantId, String channelTitle, Post post, Profile author, Collection<? extends UserId> receiverIds) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Locale.GERMAN, (Object)(author.getName() + " hat dich in einem Beitrag erw\u00e4hnt.")), TuplesKt.to((Object)Locale.ENGLISH, (Object)(author.getName() + " mentioned you in a post."))};
        Map localText = MapsKt.mapOf((Pair[])pairArray);
        NotificationConnector.sendNotifications$default((NotificationConnector)this, (TenantId)tenantId, (String)channelTitle, (Post)post, receiverIds, (NotificationType)NotificationType.POSTING_WITH_MENTION, (Map)localText, null, (int)64, null);
    }

    private void sendForNewCommentResponse(TenantId tenantId, String channelTitle, Post post, Profile author, Collection<? extends UserId> receiverIds) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Locale.GERMAN, (Object)(author.getName() + " hat einen Kommentar des Beitrages beantwortet.")), TuplesKt.to((Object)Locale.ENGLISH, (Object)(author.getName() + " answered a comment of this post."))};
        Map localText = MapsKt.mapOf((Pair[])pairArray);
        NotificationConnector.sendNotifications$default((NotificationConnector)this, (TenantId)tenantId, (String)channelTitle, (Post)post, receiverIds, (NotificationType)NotificationType.COMMENT_ON_ENTITY_SUBSCRIPTION, (Map)localText, null, (int)64, null);
    }

    private void sendForNewComment(TenantId tenantId, String channelTitle, Post post, Profile author, Collection<? extends UserId> receiverIds) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Locale.GERMAN, (Object)(author.getName() + " hat den Beitrag kommentiert.")), TuplesKt.to((Object)Locale.ENGLISH, (Object)(author.getName() + " commented on this post."))};
        Map localText = MapsKt.mapOf((Pair[])pairArray);
        NotificationConnector.sendNotifications$default((NotificationConnector)this, (TenantId)tenantId, (String)channelTitle, (Post)post, receiverIds, (NotificationType)NotificationType.COMMENT_ON_ENTITY_SUBSCRIPTION, (Map)localText, null, (int)64, null);
    }

    /*
     * WARNING - void declaration
     */
    private void sendNotifications(TenantId tenantId, String channelTitle, Post post, Collection<? extends UserId> receiverIds, NotificationType notificationType, Map<Locale, String> localText, MailInfo mailInfo) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (receiverIds.isEmpty()) {
            return;
        }
        Iterable iterable = receiverIds;
        NotificationBuilder notificationBuilder = Notification.builder((UUID)tenantId.getValue(), (String)this.appId, (String)post.getTitle(), (String)((String)MapsKt.getValue(localText, (Object)Locale.GERMAN)), (NotificationType)notificationType).withLocalizedText(localText);
        boolean $i$f$map = false;
        void var10_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserId userId = (UserId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toTypedString());
        }
        MailInfo mailInfo2 = mailInfo;
        MailInfo mailInfo3 = mailInfo;
        iterable = notificationBuilder.withReceivers(CollectionsKt.toSet((Iterable)((List)destination$iv$iv))).withPayload(this.appId).withTargetId(post.getId().toTypedString()).withDefaultMailContainerName(channelTitle).withMailAuthorName(mailInfo2 != null ? mailInfo2.getAuthorName() : null).withDefaultMailReplacementText(mailInfo3 != null ? mailInfo3.getPreviewText() : null).build();
        NotificationProducer notificationProducer = this.notificationProducer;
        Iterable p0 = iterable;
        boolean bl = false;
        notificationProducer.dispatchNotification((Notification)p0);
    }

    static /* synthetic */ void sendNotifications$default(NotificationConnector notificationConnector, TenantId tenantId, String string, Post post, Collection collection, NotificationType notificationType, Map map, MailInfo mailInfo, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendNotifications");
        }
        if ((n & 0x40) != 0) {
            mailInfo = null;
        }
        notificationConnector.sendNotifications(tenantId, string, post, collection, notificationType, map, mailInfo);
    }

    static {
        Logger logger = LoggerFactory.getLogger(NotificationConnector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

