/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.news.connector.drive;

import de.justsoftware.news.connector.drive.DriveApiAddException;
import de.justsoftware.news.connector.drive.DriveApiDeleteException;
import de.justsoftware.news.connector.drive.DriveDocument;
import de.justsoftware.news.id.DocumentId;
import de.justsoftware.news.id.DriveFileReferenceId;
import de.justsoftware.news.id.ProfileId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/news/connector/drive/DriveApiConnector;", "", "driveInternalUrl", "", "restTemplate", "Lorg/springframework/web/client/RestTemplate;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/client/RestTemplate;)V", "addFiles", "", "Lde/justsoftware/news/connector/drive/DriveDocument;", "tempIds", "Lde/justsoftware/news/id/DocumentId;", "itemId", "Lde/justsoftware/news/id/DriveFileReferenceId;", "userId", "Lde/justsoftware/news/id/ProfileId;", "deleteFile", "", "documentId", "news-service"})
@SourceDebugExtension(value={"SMAP\nDriveApiConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DriveApiConnector.kt\nde/justsoftware/news/connector/drive/DriveApiConnector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1557#2:88\n1628#2,3:89\n1557#2:92\n1628#2,3:93\n1557#2:96\n1628#2,3:97\n1557#2:100\n1628#2,2:101\n1630#2:104\n1#3:103\n*S KotlinDebug\n*F\n+ 1 DriveApiConnector.kt\nde/justsoftware/news/connector/drive/DriveApiConnector\n*L\n44#1:88\n44#1:89,3\n55#1:92\n55#1:93,3\n56#1:96\n56#1:97,3\n66#1:100\n66#1:101,2\n66#1:104\n*E\n"})
public class DriveApiConnector {
    @NotNull
    private final String driveInternalUrl;
    @NotNull
    private final RestTemplate restTemplate;

    public DriveApiConnector(@Value(value="${just.drive.internal}") @NotNull String driveInternalUrl, @NotNull RestTemplate restTemplate) {
        Intrinsics.checkNotNullParameter((Object)driveInternalUrl, (String)"driveInternalUrl");
        Intrinsics.checkNotNullParameter((Object)restTemplate, (String)"restTemplate");
        this.driveInternalUrl = driveInternalUrl;
        this.restTemplate = restTemplate;
    }

    public /* synthetic */ DriveApiConnector(String string, RestTemplate restTemplate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            restTemplate = new RestTemplate();
        }
        this(string, restTemplate);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<DriveDocument> addFiles(@NotNull List<DocumentId> tempIds, @NotNull DriveFileReferenceId itemId, @NotNull ProfileId userId) {
        LinkedHashMap entry;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Collection<UUID> collection2;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter(tempIds, (String)"tempIds");
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        if (tempIds.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Pair[] pairArray = new Pair[3];
        pairArray[0] = TuplesKt.to((Object)"targetItemId", (Object)itemId.toTypedString());
        Iterable iterable = tempIds;
        String string = "tempFileIds";
        int n = 1;
        Pair[] pairArray2 = pairArray;
        String string2 = this.driveInternalUrl + "/tmp/move";
        RestTemplate restTemplate = this.restTemplate;
        boolean $i$f$map = false;
        void var7_12 = $this$map$iv2;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            DocumentId documentId = (DocumentId)item$iv$iv2;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getValue());
        }
        collection2 = (List)destination$iv$iv;
        pairArray2[n] = TuplesKt.to((Object)string, (Object)collection2);
        pairArray[2] = TuplesKt.to((Object)"ownerId", (Object)userId.getValue());
        ResponseEntity it = restTemplate.postForEntity(string2, (Object)MapsKt.mapOf((Pair[])pairArray), Map.class, new Object[0]);
        boolean bl = false;
        Map body = (Map)it.getBody();
        if (it.getStatusCode() != HttpStatus.OK || (destination$iv$iv = body) == null || destination$iv$iv.isEmpty()) {
            Collection collection3 = tempIds;
            HttpStatusCode httpStatusCode = it.getStatusCode();
            Intrinsics.checkNotNullExpressionValue((Object)httpStatusCode, (String)"getStatusCode(...)");
            throw new DriveApiAddException(collection3, httpStatusCode);
        }
        Iterable $i$f$mapTo22 = body.values();
        boolean $i$f$map2 = false;
        item$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv3;
            Object t = item$iv$iv3 = iterator.next();
            collection = destination$iv$iv2;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)entry, (String)"null cannot be cast to non-null type java.util.LinkedHashMap<*, *>");
            collection.add((LinkedHashMap)entry);
        }
        $this$map$iv = (List)destination$iv$iv2;
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            entry = (LinkedHashMap)item$iv$iv3;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            Object v = ((Map)entry).get("id");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            DocumentId documentId = DocumentId.Companion.fromStringValue((String)v);
            Object v2 = ((Map)entry).get("mimeType");
            Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type kotlin.String");
            String string3 = (String)v2;
            Object v3 = ((Map)entry).get("name");
            Intrinsics.checkNotNull(v3, (String)"null cannot be cast to non-null type kotlin.String");
            String string4 = (String)v3;
            Object v4 = ((Map)entry).get("size");
            Intrinsics.checkNotNull(v4, (String)"null cannot be cast to non-null type kotlin.Int");
            collection.add(new DriveDocument(documentId, string3, string4, ((Integer)v4).intValue()));
        }
        List documents = (List)destination$iv$iv2;
        $this$map$iv = tempIds;
        $i$f$map2 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            Object v9;
            block7: {
                entry = (DocumentId)item$iv$iv3;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                Iterable iterable2 = documents;
                for (Object t : iterable2) {
                    void tempId;
                    DriveDocument doc = (DriveDocument)t;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)doc.getDocumentId(), (Object)tempId)) continue;
                    v9 = t;
                    break block7;
                }
                v9 = null;
            }
            Intrinsics.checkNotNull(v9);
            collection.add(v9);
        }
        return (List)destination$iv$iv2;
    }

    public void deleteFile(@NotNull DocumentId documentId, @NotNull ProfileId userId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        try {
            this.restTemplate.delete(this.driveInternalUrl + "/file/" + documentId.getValue() + "/delete?deletingUser=" + userId.getValue(), new Object[0]);
        }
        catch (HttpClientErrorException ex) {
            throw new DriveApiDeleteException(documentId, ex);
        }
    }
}

