/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.drive.controller;

import de.justsoftware.mobile.gateway.drive.controller.DriveController;
import de.justsoftware.mobile.gateway.drive.service.DriveService;
import de.justsoftware.mobile.gateway.util.RestOperationsKt;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.reactive.function.client.WebClient;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/drive"})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\"\u0010\u0010\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017J\u0012\u0010\u0014\u001a\u00020\u000b2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017J \u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/mobile/gateway/drive/controller/DriveController;", "", "driveService", "Lde/justsoftware/mobile/gateway/drive/service/DriveService;", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "<init>", "(Lde/justsoftware/mobile/gateway/drive/service/DriveService;Lorg/springframework/web/reactive/function/client/WebClient;)V", "downloadAttachment", "", "documentId", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "downloadAttachmentPreview", "downloadAttachmentVideoStream", "Lorg/springframework/http/ResponseEntity;", "Lorg/springframework/core/io/Resource;", "getUnauthorizedAttachmentVideoUrl", "download", "uri", "Ljava/net/URI;", "Companion", "mobile-gateway"})
public class DriveController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DriveService driveService;
    @NotNull
    private final WebClient webClient;

    public DriveController(@NotNull DriveService driveService, @NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)driveService, (String)"driveService");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.driveService = driveService;
        this.webClient = webClient;
    }

    @GetMapping(value={"/attachment/{documentId}"})
    public void downloadAttachment(@PathVariable(value="documentId") @NotNull String documentId, @NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.download(this.driveService.getDownloadAttachmentUri(documentId), request, response);
    }

    @GetMapping(value={"/attachment/{documentId}/preview"})
    public void downloadAttachmentPreview(@PathVariable(value="documentId") @NotNull String documentId, @NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.download(this.driveService.getDownloadAttachmentPreviewUri(documentId), request, response);
    }

    @GetMapping(value={"/attachment/{documentId}/video"})
    @NotNull
    public ResponseEntity<Resource> downloadAttachmentVideoStream(@PathVariable(value="documentId") @NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return RestOperationsKt.redirectOnSameHostTo((String)this.driveService.getDownloadAttachmentVideoStreamUrl(documentId));
    }

    @GetMapping(value={"/attachment/{documentId}/video/url"})
    @NotNull
    public String getUnauthorizedAttachmentVideoUrl(@PathVariable(value="documentId") @NotNull String documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        return this.driveService.getUnauthorizedAttachmentVideoUrl(documentId);
    }

    private void download(URI uri, HttpServletRequest request, HttpServletResponse response) {
        WebClient.RequestHeadersSpec requestHeadersSpec = this.webClient.get().uri(uri);
        Intrinsics.checkNotNullExpressionValue((Object)requestHeadersSpec, (String)"uri(...)");
        Companion.access$copyHeadersAndDownload((Companion)Companion, (WebClient.RequestHeadersSpec)requestHeadersSpec, (HttpServletRequest)request, (HttpServletResponse)response);
    }
}

