/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security.oauth2;

import de.justsoftware.gateway.security.JustAuthenticationException;
import de.justsoftware.gateway.security.LoginCookieHandler;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.http.MediaType;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.server.resource.web.server.BearerTokenServerAuthenticationEntryPoint;
import org.springframework.security.web.server.DelegatingServerAuthenticationEntryPoint;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationEntryPoint;
import org.springframework.security.web.server.savedrequest.NoOpServerRequestCache;
import org.springframework.security.web.server.savedrequest.ServerRequestCache;
import org.springframework.security.web.server.util.matcher.AndServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.MediaTypeServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.NegatedServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.stereotype.Service;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@ParametersAreNonnullByDefault
@Service
public class JustOauthLoginAuthenticationEntryPoint
implements ServerAuthenticationEntryPoint {
    public static final String JUST = "/oauth2/authorization/just";
    private static final ServerWebExchangeMatcher DIRECT_BROWSER_ACCESS_MATCHER = JustOauthLoginAuthenticationEntryPoint.createDirectBrowserAccessMatcher();
    private DelegatingServerAuthenticationEntryPoint _entryPoint = this.createAuthenticationEntryPoint("/oauth2/authorization/just");

    JustOauthLoginAuthenticationEntryPoint() {
    }

    public Mono<Void> commence(ServerWebExchange exchange, AuthenticationException ex) {
        if (ex instanceof JustAuthenticationException) {
            return this.logoutAndRedirectToErrorPage(exchange, ex, ((JustAuthenticationException)ex).getErrorCode().toString());
        }
        if (ex instanceof OAuth2AuthenticationException) {
            return this.logoutAndRedirectToErrorPage(exchange, ex, ((OAuth2AuthenticationException)ex).getError().getErrorCode());
        }
        return this._entryPoint.commence(exchange, ex);
    }

    @Nonnull
    private Mono<Void> logoutAndRedirectToErrorPage(ServerWebExchange exchange, AuthenticationException ex, String errorCode) {
        ServerWebExchange cleanedExchange = LoginCookieHandler.removeJustLoginCookies((ServerWebExchange)exchange);
        RedirectServerAuthenticationEntryPoint redirect = new RedirectServerAuthenticationEntryPoint("/oauth2/login?errorCode=" + errorCode);
        return redirect.commence(cleanedExchange, ex);
    }

    @Nonnull
    private DelegatingServerAuthenticationEntryPoint createAuthenticationEntryPoint(@Nullable String idpLoginPage) {
        ArrayList<DelegatingServerAuthenticationEntryPoint.DelegateEntry> delegateEntryPoints = new ArrayList<DelegatingServerAuthenticationEntryPoint.DelegateEntry>();
        if (idpLoginPage != null) {
            String defaultLoginPage = "/oauth2/login";
            PathPatternParserServerWebExchangeMatcher loginPageMatcher = new PathPatternParserServerWebExchangeMatcher("/oauth2/login");
            AndServerWebExchangeMatcher matcher = new AndServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{DIRECT_BROWSER_ACCESS_MATCHER, new NegatedServerWebExchangeMatcher((ServerWebExchangeMatcher)loginPageMatcher)});
            RedirectServerAuthenticationEntryPoint entryPoint = new RedirectServerAuthenticationEntryPoint(idpLoginPage);
            entryPoint.setRequestCache((ServerRequestCache)NoOpServerRequestCache.getInstance());
            delegateEntryPoints.add(new DelegatingServerAuthenticationEntryPoint.DelegateEntry((ServerWebExchangeMatcher)matcher, (ServerAuthenticationEntryPoint)entryPoint));
        }
        BearerTokenServerAuthenticationEntryPoint bearerTokenEntryPoint = new BearerTokenServerAuthenticationEntryPoint();
        DelegatingServerAuthenticationEntryPoint delegatingEntryPoint = new DelegatingServerAuthenticationEntryPoint(delegateEntryPoints);
        delegatingEntryPoint.setDefaultEntryPoint((ServerAuthenticationEntryPoint)bearerTokenEntryPoint);
        return delegatingEntryPoint;
    }

    @Nonnull
    private static ServerWebExchangeMatcher createDirectBrowserAccessMatcher() {
        MediaTypeServerWebExchangeMatcher htmlMatcher = new MediaTypeServerWebExchangeMatcher(new MediaType[]{MediaType.APPLICATION_XHTML_XML, MediaType.TEXT_HTML, MediaType.TEXT_PLAIN});
        htmlMatcher.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
        ServerWebExchangeMatcher xhrMatcher = exchange -> {
            if (exchange.getRequest().getHeaders().getOrEmpty((Object)"X-Requested-With").contains("XMLHttpRequest")) {
                return ServerWebExchangeMatcher.MatchResult.match();
            }
            return ServerWebExchangeMatcher.MatchResult.notMatch();
        };
        NegatedServerWebExchangeMatcher notXhrMatcher = new NegatedServerWebExchangeMatcher(xhrMatcher);
        NegatedServerWebExchangeMatcher notApiMatcher = new NegatedServerWebExchangeMatcher(exchange -> {
            String path = exchange.getRequest().getURI().getPath();
            return path.contains("/graphql/") || path.contains("/api/") ? ServerWebExchangeMatcher.MatchResult.match() : ServerWebExchangeMatcher.MatchResult.notMatch();
        });
        return new AndServerWebExchangeMatcher(new ServerWebExchangeMatcher[]{notApiMatcher, notXhrMatcher, htmlMatcher});
    }

    @Nonnull
    private String toAuthorizeUrl(ClientRegistration defaultRegistration) {
        return String.format("/oauth2/authorization/%s", defaultRegistration.getRegistrationId());
    }

    public void setDefaultIdp(@Nullable ClientRegistration defaultIdp) {
        if (defaultIdp == null) {
            this.setDefaultLoginPage(JUST);
            return;
        }
        this.setDefaultLoginPage(this.toAuthorizeUrl(defaultIdp));
    }

    private void setDefaultLoginPage(String url) {
        this._entryPoint = this.createAuthenticationEntryPoint(url);
    }
}

