/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security.oauth2;

import de.justsoftware.gateway.security.oauth2.ClientTarget;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.jwt.JwtValidators;
import org.springframework.security.oauth2.jwt.NimbusReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.stereotype.Component;

@RefreshScope
@Component
@ParametersAreNonnullByDefault
public class JustLoginClients {
    private static final Logger LOG = LoggerFactory.getLogger(JustLoginClients.class);
    private final ClientRegistration _toroDesktopClient;
    private final ClientRegistration _toroMobileClient;
    private final ClientRegistration _authMobileClient;
    private final ClientRegistration _authDesktopClient;
    private final String _domainPrefix;
    @CheckForNull
    private final String _publicKey;
    private ReactiveJwtDecoder _justAuthDecoder;

    public JustLoginClients(@Value(value="${just.toro.oauth.clientId}") String toroLoginClientId, @Value(value="${just.toro.oauth.clientSecret}") String toroLoginClientSecret, @Value(value="${just.toro.oauth.clientIdMobile}") String toroMobileClientId, @Value(value="${just.common.system.domainprefix}") String domainPrefix, @Value(value="${just.auth.jwk.publicKey:#{null}}") String publicKey) {
        this._toroDesktopClient = ClientRegistration.withRegistrationId((String)"just").clientId(toroLoginClientId).clientSecret(toroLoginClientSecret).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC).providerConfigurationMetadata(Map.of("targets", Set.of(ClientTarget.DESKTOP))).redirectUri(domainPrefix + "/login/oauth2/code/just").scope(new String[]{"api"}).authorizationUri(domainPrefix + "/toro/oauth/authorize").tokenUri(domainPrefix + "/toro/oauth/token").userInfoUri(domainPrefix + "/toro/api/v1/person/current").userNameAttributeName("email").build();
        this._toroMobileClient = ClientRegistration.withRegistrationId((String)"just_mobile").clientId(toroMobileClientId).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).providerConfigurationMetadata(Map.of("targets", Set.of(ClientTarget.MOBILE_SOCIAL))).scope(new String[]{"api"}).authorizationUri(domainPrefix + "/toro/oauth/authorize").redirectUri(domainPrefix + "/login/oauth2/code/just_mobile").tokenUri(domainPrefix + "/toro/oauth/token").userInfoUri(domainPrefix + "/toro/api/v1/person/current").userNameAttributeName("email").build();
        this._authDesktopClient = this.getJustAuthProviderConfig("just-auth-login", domainPrefix).clientSecret(toroLoginClientSecret).providerConfigurationMetadata(Map.of("targets", Set.of(ClientTarget.DESKTOP), "end_session_endpoint", domainPrefix + "/auth/connect/logout", "defaultProvider", false)).redirectUri(domainPrefix + "/login/oauth2/code/just-auth-login").clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_BASIC).userNameAttributeName("sub").build();
        this._authMobileClient = this.getJustAuthProviderConfig("just-auth-mobile-login", domainPrefix).providerConfigurationMetadata(Map.of("targets", Set.of(ClientTarget.MOBILE_SOCIAL))).userNameAttributeName("sub").build();
        this._publicKey = publicKey;
        this._domainPrefix = domainPrefix;
    }

    @Nonnull
    private ClientRegistration.Builder getJustAuthProviderConfig(String clientId, String domainPrefix) {
        String issuer = domainPrefix + "/auth";
        return ClientRegistration.withRegistrationId((String)clientId).clientId(clientId).issuerUri(issuer).authorizationUri(domainPrefix + "/auth/oauth2/authorize").tokenUri(domainPrefix + "/auth/oauth2/token").redirectUri(domainPrefix + "/login/oauth2/code/" + clientId).jwkSetUri(domainPrefix + "/auth/oauth2/jwks").scope(new String[]{"openid"}).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE);
    }

    @Nonnull
    private ReactiveJwtDecoder createJustAuthDecoder(String domainPrefix, String publicKeyString) {
        try {
            String issuer = domainPrefix + "/auth";
            byte[] publicKeyBytes = Base64.getDecoder().decode(publicKeyString);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKey publicKey = (RSAPublicKey)keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            OAuth2TokenValidator jwtValidator = JwtValidators.createDefaultWithIssuer((String)issuer);
            NimbusReactiveJwtDecoder jwtDecoder = NimbusReactiveJwtDecoder.withPublicKey((RSAPublicKey)publicKey).build();
            jwtDecoder.setJwtValidator(jwtValidator);
            return jwtDecoder;
        }
        catch (RuntimeException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Nonnull
    public ClientRegistration getToroDesktopClient() {
        return this._toroDesktopClient;
    }

    @Nonnull
    public ClientRegistration getToroMobileClient() {
        return this._toroMobileClient;
    }

    @Nonnull
    public ClientRegistration getJustAuthDesktopClient() {
        return this._authDesktopClient;
    }

    @Nonnull
    public ClientRegistration getJustAuthMobileClient() {
        return this._authMobileClient;
    }

    @CheckForNull
    public ReactiveJwtDecoder getJustAuthDecoder() {
        if (this._justAuthDecoder == null && this._publicKey != null) {
            this._justAuthDecoder = this.createJustAuthDecoder(this._domainPrefix, this._publicKey);
        }
        return this._justAuthDecoder;
    }
}

