/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.mybatis.type;

import com.google.common.base.Preconditions;
import de.justsoftware.drive.mybatis.SupportedJdbcDriver;
import de.justsoftware.drive.mybatis.type.AbstractDriverSpecificTypeHandler;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

@ParametersAreNonnullByDefault
public abstract class AbstractDriverSpecificTypeHandler<T>
extends BaseTypeHandler<T> {
    private static final ThreadLocal<SupportedJdbcDriver> HOLDER = new ThreadLocal();
    private final SupportedJdbcDriver _jdbcDriver = (SupportedJdbcDriver)Preconditions.checkNotNull((Object)((SupportedJdbcDriver)HOLDER.get()));

    public static void setJdbcDriver(@Nullable SupportedJdbcDriver newDriver) {
        HOLDER.set(newDriver);
    }

    public final void setNonNullParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        switch (1.$SwitchMap$de$justsoftware$drive$mybatis$SupportedJdbcDriver[this._jdbcDriver.ordinal()]) {
            case 1: {
                this.setNonNullParameterOracle(ps, i, parameter, jdbcType);
                return;
            }
            case 2: {
                this.setNonNullParameterPostgres(ps, i, parameter, jdbcType);
                return;
            }
        }
        this.throwUnsupported();
    }

    @Nonnull
    private T throwUnsupported() {
        throw new UnsupportedOperationException("behavior for " + String.valueOf(this._jdbcDriver) + " not defined");
    }

    public final T getNullableResult(ResultSet rs, String columnName) throws SQLException {
        switch (1.$SwitchMap$de$justsoftware$drive$mybatis$SupportedJdbcDriver[this._jdbcDriver.ordinal()]) {
            case 1: {
                return (T)this.getNullableResultOracle(rs, columnName);
            }
            case 2: {
                return (T)this.getNullableResultPostgres(rs, columnName);
            }
        }
        return (T)this.throwUnsupported();
    }

    public final T getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        switch (1.$SwitchMap$de$justsoftware$drive$mybatis$SupportedJdbcDriver[this._jdbcDriver.ordinal()]) {
            case 1: {
                return (T)this.getNullableResultOracle(rs, columnIndex);
            }
            case 2: {
                return (T)this.getNullableResultPostgres(rs, columnIndex);
            }
        }
        return (T)this.throwUnsupported();
    }

    public final T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        switch (1.$SwitchMap$de$justsoftware$drive$mybatis$SupportedJdbcDriver[this._jdbcDriver.ordinal()]) {
            case 1: {
                return (T)this.getNullableResultOracle(cs, columnIndex);
            }
            case 2: {
                return (T)this.getNullableResultPostgres(cs, columnIndex);
            }
        }
        return (T)this.throwUnsupported();
    }

    protected abstract void setNonNullParameterPostgres(PreparedStatement var1, int var2, T var3, @Nullable JdbcType var4) throws SQLException;

    protected abstract void setNonNullParameterOracle(PreparedStatement var1, int var2, T var3, @Nullable JdbcType var4) throws SQLException;

    @CheckForNull
    protected abstract T getNullableResultOracle(ResultSet var1, String var2) throws SQLException;

    @CheckForNull
    protected abstract T getNullableResultPostgres(ResultSet var1, String var2) throws SQLException;

    @CheckForNull
    protected abstract T getNullableResultPostgres(ResultSet var1, int var2) throws SQLException;

    @CheckForNull
    protected abstract T getNullableResultOracle(ResultSet var1, int var2) throws SQLException;

    @CheckForNull
    protected abstract T getNullableResultPostgres(CallableStatement var1, int var2) throws SQLException;

    @CheckForNull
    protected abstract T getNullableResultOracle(CallableStatement var1, int var2) throws SQLException;
}

