/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.document.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import de.justsoftware.drive.business.change.ChangeModificationService;
import de.justsoftware.drive.business.change.ChangeService;
import de.justsoftware.drive.business.common.CachingMapLoader;
import de.justsoftware.drive.business.document.DocumentListService;
import de.justsoftware.drive.business.document.impl.DocumentListServiceImpl;
import de.justsoftware.drive.business.exception.UnknownResourceBusinessException;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.business.person.PersonService;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentListBO;
import de.justsoftware.drive.common.document.model.DocumentListEntryBO;
import de.justsoftware.drive.common.document.model.DocumentSortField;
import de.justsoftware.drive.common.document.model.DocumentSortParams;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.MicroblogEntryBO;
import de.justsoftware.drive.common.document.model.PublishedFilter;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.common.person.model.PersonBO;
import de.justsoftware.drive.common.person.model.PersonId;
import java.text.Collator;
import java.time.Instant;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class DocumentListServiceImpl
implements DocumentListService {
    private static final DocumentListEntryBO.Visitor<Optional<PersonId>> GET_OWNER_ID = new /* Unavailable Anonymous Inner Class!! */;
    private static final DocumentListEntryBO.Visitor<Optional<Instant>> GET_CHANGE_DATE = new /* Unavailable Anonymous Inner Class!! */;
    private static final DocumentListEntryBO.Visitor<String> GET_NAME = new /* Unavailable Anonymous Inner Class!! */;
    private static final DocumentListEntryBO.Visitor<Long> GET_SIZE = new /* Unavailable Anonymous Inner Class!! */;
    final FolderService _folderService;
    final PersonService _personService;
    final ChangeModificationService _changeModificationService;
    final ChangeService _changeService;

    @Autowired
    public DocumentListServiceImpl(FolderService folderService, PersonService personService, ChangeModificationService changeModificationService, ChangeService changeService) {
        this._folderService = folderService;
        this._personService = personService;
        this._changeModificationService = changeModificationService;
        this._changeService = changeService;
    }

    public DocumentListBO getCurrentDocumentList(DocumentId folderId, DocumentSortParams sortParams, PublishedFilter publishedFilter) {
        ImmutableMap lastVersions = this._folderService.getLastVersionsOfDocuments((Set)ImmutableSet.of((Object)folderId), publishedFilter);
        DocumentVersionId newestVersion = (DocumentVersionId)lastVersions.get((Object)folderId);
        if (newestVersion == null) {
            throw new UnknownResourceBusinessException("Could not load document list for folder id " + String.valueOf(folderId));
        }
        return this.getDocumentList(newestVersion, sortParams, publishedFilter);
    }

    @Nonnull
    @VisibleForTesting
    DocumentListBO getDocumentList(DocumentVersionId folderVersionId, DocumentSortParams sortParams, PublishedFilter publishedFilter) {
        ChangeBO changeBO = (ChangeBO)this._changeService.getChangesByIds((Set)ImmutableSet.of((Object)folderVersionId)).get((Object)folderVersionId);
        ImmutableSet ids = ImmutableSet.of((Object)folderVersionId);
        ImmutableList pathIds = this._folderService.getPath((Set)ids, publishedFilter).get((Object)folderVersionId);
        ImmutableSet pathIdSet = ImmutableSet.copyOf((Collection)pathIds);
        if (pathIdSet.isEmpty()) {
            throw new UnknownResourceBusinessException("No path found for folder version " + String.valueOf(folderVersionId));
        }
        ImmutableMap folderVersionById = this._folderService.getFolderVersionsByIds((Set)pathIdSet);
        if (!pathIdSet.equals((Object)folderVersionById.keySet())) {
            throw new UnknownResourceBusinessException("Not a folder version or path contains gaps " + String.valueOf(folderVersionId));
        }
        ImmutableList path = FluentIterable.from((Iterable)pathIds).transform(Functions.forMap((Map)folderVersionById)).toList();
        ImmutableList.Builder folderContentsBuilder = ImmutableList.builder();
        if (changeBO != null && changeBO.getItemId().getType().equals((Object)ItemType.ENTITY)) {
            folderContentsBuilder.add((Object)new MicroblogEntryBO(changeBO.getItemId()));
        }
        folderContentsBuilder.addAll((Iterable)this._folderService.getFolderContents((Set)ids).get((Object)folderVersionId));
        ImmutableList folderContents = folderContentsBuilder.build();
        CachingMapLoader personCache = new CachingMapLoader(arg_0 -> ((PersonService)this._personService).getPersonsByIds(arg_0));
        ImmutableSet pathOwners = FluentIterable.from((Iterable)path).transform(DocumentVersionBO.GET_OWNER).toSet();
        personCache.addMissing((Iterable)pathOwners);
        ImmutableList orderDocuments = this.orderDocuments((Collection)folderContents, sortParams, Suppliers.memoize(() -> {
            personCache.addMissing((Iterable)FluentIterable.from((Iterable)folderContents).filter(DocumentVersionBO.class).transform(DocumentVersionBO.GET_OWNER));
            return personCache;
        }));
        ImmutableSet contentOwners = FluentIterable.from((Iterable)orderDocuments).filter(DocumentVersionBO.class).transform(DocumentVersionBO.GET_OWNER).toSet();
        personCache.addMissing((Iterable)contentOwners);
        return new DocumentListBO(path, folderContents.size(), orderDocuments, ImmutableMap.copyOf((Map)personCache.get((Set)Sets.union((Set)pathOwners, (Set)contentOwners))));
    }

    @Nonnull
    @VisibleForTesting
    ImmutableList<DocumentListEntryBO> orderDocuments(Collection<? extends DocumentListEntryBO> folderContents, DocumentSortParams sortParams, Supplier<? extends Function<PersonId, PersonBO>> personCache) {
        if (folderContents.size() < sortParams.getOffset()) {
            return ImmutableList.of();
        }
        Ordering order = this.ordering(sortParams, personCache);
        return ImmutableList.copyOf((Iterable)Iterables.skip((Iterable)order.leastOf(folderContents, sortParams.getLimit() + sortParams.getOffset()), (int)sortParams.getOffset()));
    }

    @Nonnull
    private Ordering<DocumentListEntryBO> ordering(DocumentSortParams sortParams, Supplier<? extends Function<PersonId, PersonBO>> personCache) {
        Ordering fieldOrdering = this.fieldOrdering(sortParams, personCache);
        switch (5.$SwitchMap$de$justsoftware$drive$common$model$SortDirection[sortParams.getSortDirection().ordinal()]) {
            case 1: {
                return fieldOrdering;
            }
            case 2: {
                return fieldOrdering.reverse();
            }
        }
        return fieldOrdering;
    }

    @Nonnull
    private Ordering<DocumentListEntryBO> fieldOrdering(DocumentSortParams sortParams, Supplier<? extends Function<PersonId, PersonBO>> personCache) {
        Collator collator = Collator.getInstance(sortParams.getLocale());
        collator.setStrength(0);
        Ordering nameOrdering = Ordering.from((Comparator)collator).onResultOf((Function)GET_NAME);
        DocumentSortField field = sortParams.getSortField();
        switch (5.$SwitchMap$de$justsoftware$drive$common$document$model$DocumentSortField[field.ordinal()]) {
            case 1: {
                Function f = Functions.compose((Function)PersonBO.SORT_NAME, (Function)((Function)personCache.get()));
                return Ordering.from((Comparator)collator).onResultOf(Functions.compose((Function)f, (Function)Functions.compose(Optional::orNull, (Function)GET_OWNER_ID))).nullsFirst().compound((Comparator)nameOrdering);
            }
            case 2: {
                return Ordering.natural().onResultOf((Function)GET_SIZE).compound((Comparator)nameOrdering);
            }
            case 3: {
                return Ordering.natural().nullsFirst().onResultOf(Functions.compose(Optional::orNull, (Function)GET_CHANGE_DATE)).compound((Comparator)nameOrdering);
            }
            case 4: {
                return nameOrdering;
            }
        }
        throw new UnsupportedOperationException("no function defined for " + String.valueOf(field));
    }
}

