/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config;

import de.justsoftware.chat.config.CommonConfigProperties;
import de.justsoftware.chat.config.JunoClientConfiguration;
import de.justsoftware.chat.mobile.service.JunoRestClientService;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClient;
import reactor.netty.transport.ClientTransport;

@Configuration
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0017J\"\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0017J\"\u0010\f\u001a\u00020\u00072\b\b\u0001\u0010\r\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0017\u00a8\u0006\u000f"}, d2={"Lde/justsoftware/chat/config/JunoClientConfiguration;", "", "<init>", "()V", "junoHttpClient", "Lreactor/netty/http/client/HttpClient;", "junoApnsRestClient", "Lde/justsoftware/chat/mobile/service/JunoRestClientService;", "junoBasePathApns", "", "commonConfigProperties", "Lde/justsoftware/chat/config/CommonConfigProperties;", "junoFcmRestClient", "junoBasePathFcm", "Companion", "chat-service"})
public class JunoClientConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long TIMEOUT_SECONDS = 60L;

    @Bean
    @NotNull
    public HttpClient junoHttpClient() {
        ClientTransport clientTransport = ((HttpClient)((HttpClient)HttpClient.create().option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)60000)).responseTimeout(Duration.ofSeconds(60L)).proxyWithSystemProperties()).doOnConnected(arg_0 -> JunoClientConfiguration.junoHttpClient$lambda$1(JunoClientConfiguration::junoHttpClient$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)clientTransport, (String)"doOnConnected(...)");
        return (HttpClient)clientTransport;
    }

    @Bean
    @NotNull
    public JunoRestClientService junoApnsRestClient(@Value(value="${just.juno.baseurl.apns}") @NotNull String junoBasePathApns, @NotNull HttpClient junoHttpClient, @NotNull CommonConfigProperties commonConfigProperties) {
        Intrinsics.checkNotNullParameter((Object)junoBasePathApns, (String)"junoBasePathApns");
        Intrinsics.checkNotNullParameter((Object)junoHttpClient, (String)"junoHttpClient");
        Intrinsics.checkNotNullParameter((Object)commonConfigProperties, (String)"commonConfigProperties");
        return new JunoRestClientService(junoBasePathApns + "/v1", junoHttpClient, commonConfigProperties);
    }

    @Bean
    @NotNull
    public JunoRestClientService junoFcmRestClient(@Value(value="${just.juno.baseurl.fcm}") @NotNull String junoBasePathFcm, @NotNull HttpClient junoHttpClient, @NotNull CommonConfigProperties commonConfigProperties) {
        Intrinsics.checkNotNullParameter((Object)junoBasePathFcm, (String)"junoBasePathFcm");
        Intrinsics.checkNotNullParameter((Object)junoHttpClient, (String)"junoHttpClient");
        Intrinsics.checkNotNullParameter((Object)commonConfigProperties, (String)"commonConfigProperties");
        return new JunoRestClientService(junoBasePathFcm + "/v1", junoHttpClient, commonConfigProperties);
    }

    private static final Unit junoHttpClient$lambda$0(Connection connection) {
        connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler(60L, TimeUnit.SECONDS)).addHandlerLast((ChannelHandler)new WriteTimeoutHandler(60L, TimeUnit.SECONDS));
        return Unit.INSTANCE;
    }

    private static final void junoHttpClient$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

