/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.totp;

import de.justsoftware.authorization.config.FeatureToggleService;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.totp.TOTPAuthentication;
import de.justsoftware.authorization.totp.TOTPAuthenticationService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/authorization/totp/TOTPAuthenticationSuccessHandler;", "Lorg/springframework/security/web/authentication/AuthenticationSuccessHandler;", "featureToggleService", "Lde/justsoftware/authorization/config/FeatureToggleService;", "systemDomainPrefix", "", "totpAuthenticationService", "Lde/justsoftware/authorization/totp/TOTPAuthenticationService;", "<init>", "(Lde/justsoftware/authorization/config/FeatureToggleService;Ljava/lang/String;Lde/justsoftware/authorization/totp/TOTPAuthenticationService;)V", "onAuthenticationSuccess", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "authentication", "Lorg/springframework/security/core/Authentication;", "just-authorization-server"})
public class TOTPAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    @NotNull
    private final FeatureToggleService featureToggleService;
    @NotNull
    private final String systemDomainPrefix;
    @NotNull
    private final TOTPAuthenticationService totpAuthenticationService;

    public TOTPAuthenticationSuccessHandler(@NotNull FeatureToggleService featureToggleService, @Value(value="${just.common.system.domainprefix}") @NotNull String systemDomainPrefix, @NotNull TOTPAuthenticationService totpAuthenticationService) {
        Intrinsics.checkNotNullParameter((Object)featureToggleService, (String)"featureToggleService");
        Intrinsics.checkNotNullParameter((Object)systemDomainPrefix, (String)"systemDomainPrefix");
        Intrinsics.checkNotNullParameter((Object)totpAuthenticationService, (String)"totpAuthenticationService");
        this.featureToggleService = featureToggleService;
        this.systemDomainPrefix = systemDomainPrefix;
        this.totpAuthenticationService = totpAuthenticationService;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onAuthenticationSuccess(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Authentication authentication) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
        if (this.featureToggleService.isMFAEnabled()) {
            Object object = authentication.getPrincipal();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type de.justsoftware.authorization.oauth2.JustUser");
            if (this.totpAuthenticationService.isMFARequired((JustUser)object)) {
                SecurityContextHolder.getContext().setAuthentication((Authentication)new TOTPAuthentication(authentication, null));
                SimpleUrlAuthenticationSuccessHandler successHandler = new SimpleUrlAuthenticationSuccessHandler("/totp/register");
                successHandler.setAlwaysUseDefaultTargetUrl(true);
                successHandler.onAuthenticationSuccess(request, response, authentication);
                return;
            }
        }
        SavedRequestAwareAuthenticationSuccessHandler handler = new SavedRequestAwareAuthenticationSuccessHandler();
        handler.setDefaultTargetUrl(this.systemDomainPrefix);
        handler.onAuthenticationSuccess(request, response, authentication);
    }
}

