/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.totp;

import com.atlassian.onetime.core.TOTP;
import com.atlassian.onetime.model.EmailAddress;
import com.atlassian.onetime.model.Issuer;
import com.atlassian.onetime.model.TOTPSecret;
import com.atlassian.onetime.service.DefaultTOTPService;
import com.atlassian.onetime.service.RandomSecretProvider;
import com.atlassian.onetime.service.TOTPVerificationResult;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import de.justsoftware.authorization.controller.TOTPDeviceResponse;
import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.oauth2.JustUserDetailService;
import de.justsoftware.authorization.settings.SettingsService;
import de.justsoftware.authorization.settings.TenantSettings;
import de.justsoftware.authorization.totp.TOTPAuthenticationException;
import de.justsoftware.authorization.totp.TOTPAuthenticationService;
import de.justsoftware.authorization.totp.TOTPDevice;
import de.justsoftware.authorization.totp.TOTPDeviceRepository;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import kotlin.Metadata;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \"2\u00020\u0001:\u0001\"B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\tH\u0012J\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\tH\u0012J\u001a\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001a2\b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lde/justsoftware/authorization/totp/TOTPAuthenticationService;", "", "userService", "Lde/justsoftware/authorization/oauth2/JustUserDetailService;", "settingsService", "Lde/justsoftware/authorization/settings/SettingsService;", "totpDeviceRepository", "Lde/justsoftware/authorization/totp/TOTPDeviceRepository;", "mfaEncryptionPassword", "", "systemDomainPrefix", "<init>", "(Lde/justsoftware/authorization/oauth2/JustUserDetailService;Lde/justsoftware/authorization/settings/SettingsService;Lde/justsoftware/authorization/totp/TOTPDeviceRepository;Ljava/lang/String;Ljava/lang/String;)V", "textEncryptor", "Lorg/springframework/security/crypto/encrypt/TextEncryptor;", "getTextEncryptor", "()Lorg/springframework/security/crypto/encrypt/TextEncryptor;", "isDeviceConfirmed", "", "username", "addDevice", "Lde/justsoftware/authorization/controller/TOTPDeviceResponse;", "checkTOTPCode", "", "code", "findDevice", "Lde/justsoftware/authorization/totp/TOTPDevice;", "name", "generateQRCode", "device", "verifyCode", "isMFARequired", "user", "Lde/justsoftware/authorization/oauth2/JustUser;", "Companion", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nTOTPAuthenticationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TOTPAuthenticationService.kt\nde/justsoftware/authorization/totp/TOTPAuthenticationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1#2:146\n*E\n"})
public class TOTPAuthenticationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JustUserDetailService userService;
    @NotNull
    private final SettingsService settingsService;
    @NotNull
    private final TOTPDeviceRepository totpDeviceRepository;
    @NotNull
    private final String systemDomainPrefix;
    @NotNull
    private final TextEncryptor textEncryptor;
    private static final Logger log = LoggerFactory.getLogger(TOTPAuthenticationService.class);
    @NotNull
    private static final String TEXT_ENCRYPTOR_SALT = "5ab5ea80dcb641d373626bc8671e5006";

    public TOTPAuthenticationService(@NotNull JustUserDetailService userService, @NotNull SettingsService settingsService, @NotNull TOTPDeviceRepository totpDeviceRepository, @Value(value="${just.auth.mfaEncryptionPassword}") @NotNull String mfaEncryptionPassword, @Value(value="${just.common.system.domainprefix}") @NotNull String systemDomainPrefix) {
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        Intrinsics.checkNotNullParameter((Object)settingsService, (String)"settingsService");
        Intrinsics.checkNotNullParameter((Object)totpDeviceRepository, (String)"totpDeviceRepository");
        Intrinsics.checkNotNullParameter((Object)mfaEncryptionPassword, (String)"mfaEncryptionPassword");
        Intrinsics.checkNotNullParameter((Object)systemDomainPrefix, (String)"systemDomainPrefix");
        this.userService = userService;
        this.settingsService = settingsService;
        this.totpDeviceRepository = totpDeviceRepository;
        this.systemDomainPrefix = systemDomainPrefix;
        TextEncryptor textEncryptor = Encryptors.delux((CharSequence)mfaEncryptionPassword, (CharSequence)TEXT_ENCRYPTOR_SALT);
        Intrinsics.checkNotNullExpressionValue((Object)textEncryptor, (String)"delux(...)");
        this.textEncryptor = textEncryptor;
    }

    @NotNull
    public TextEncryptor getTextEncryptor() {
        return this.textEncryptor;
    }

    public boolean isDeviceConfirmed(@NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        TOTPDevice device = this.findDevice(username);
        return device != null && device.getConfirmed();
    }

    @NotNull
    public TOTPDeviceResponse addDevice(@NotNull String username) {
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        JustUser user = this.userService.loadUserByUsername(username);
        TOTPDevice device = this.totpDeviceRepository.findTOTPDeviceByProfileId(user.getProfileId());
        if (device == null) {
            ProfileId profileId = user.getProfileId();
            String string = this.getTextEncryptor().encrypt(RandomSecretProvider.Companion.generateSecret().getBase32Encoded());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encrypt(...)");
            device = new TOTPDevice(null, profileId, string, false, null, 25, null);
        }
        this.totpDeviceRepository.upsertDevice(device);
        String string = this.getTextEncryptor().decrypt(device.getEncryptedSecret());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decrypt(...)");
        return new TOTPDeviceResponse(string, this.generateQRCode(device, username));
    }

    public void checkTOTPCode(@Nullable String code) {
        Authentication currentAuthentication = SecurityContextHolder.getContext().getAuthentication();
        if (!currentAuthentication.isAuthenticated()) {
            boolean bl = false;
            throw new InsufficientAuthenticationException("User not authenticated");
        }
        String string = currentAuthentication.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        TOTPDevice device = this.findDevice(string);
        if (device != null) {
            boolean isCodeCorrect = this.verifyCode(device, code);
            if (!isCodeCorrect) {
                throw new TOTPAuthenticationException("Wrong code provided");
            }
            if (!device.getConfirmed()) {
                this.totpDeviceRepository.setTOTPDeviceConfirmed(device.getId());
            }
        } else {
            log.debug("User " + currentAuthentication.getName() + " has no 2FA device registered.");
        }
    }

    private TOTPDevice findDevice(String name) {
        JustUser user = this.userService.loadUserByUsername(name);
        return this.totpDeviceRepository.findTOTPDeviceByProfileId(user.getProfileId());
    }

    private String generateQRCode(TOTPDevice device, String username) {
        String domain = new URI(this.systemDomainPrefix).getHost();
        DefaultTOTPService defaultTOTPService = new DefaultTOTPService(null, null, 3, null);
        String string = this.getTextEncryptor().decrypt(device.getEncryptedSecret());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decrypt(...)");
        TOTPSecret tOTPSecret = TOTPSecret.Companion.fromBase32EncodedString(string);
        EmailAddress emailAddress = new EmailAddress(username);
        Intrinsics.checkNotNull((Object)domain);
        String string2 = defaultTOTPService.generateTOTPUrl(tOTPSecret, emailAddress, new Issuer(domain)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String totpUri = string2;
        BitMatrix matrix = new MultiFormatWriter().encode(totpUri, BarcodeFormat.QR_CODE, 300, 300);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)matrix, (String)"png", (OutputStream)stream);
        Base64 base64 = (Base64)Base64.Default;
        byte[] byArray = stream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return Base64.encode$default((Base64)base64, (byte[])byArray, (int)0, (int)0, (int)6, null);
    }

    public boolean verifyCode(@NotNull TOTPDevice device, @Nullable String code) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        CharSequence charSequence = code;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            log.warn("No TOTP code provided.");
            throw new TOTPAuthenticationException("No code provided");
        }
        DefaultTOTPService defaultTOTPService = new DefaultTOTPService(null, null, 3, null);
        TOTP tOTP = new TOTP(code);
        String string = this.getTextEncryptor().decrypt(device.getEncryptedSecret());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decrypt(...)");
        TOTPVerificationResult result = defaultTOTPService.verify(tOTP, TOTPSecret.Companion.fromBase32EncodedString(string));
        return result.isSuccess();
    }

    public boolean isMFARequired(@NotNull JustUser user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (user.getTenantId() == null) {
            return false;
        }
        TenantSettings tenantSettings = this.settingsService.get(user.getTenantId());
        if (tenantSettings == null) {
            return false;
        }
        boolean isMfaMandatory = tenantSettings.getMfaMandatory();
        if (isMfaMandatory) {
            return true;
        }
        TOTPDevice totpDevice = this.totpDeviceRepository.findTOTPDeviceByProfileId(user.getProfileId());
        if (totpDevice != null && totpDevice.getConfirmed()) {
            return true;
        }
        return TenantSettings.Companion.getMFA_MANDATORY_DEFAULT();
    }
}

