/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2.client;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import de.justsoftware.authorization.config.JustOauthClients;
import de.justsoftware.authorization.id.ItemIdDeserializer;
import de.justsoftware.authorization.id.ItemIdSerializer;
import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.oauth2.client.ExposedRegisteredClientRepositoryKt;
import de.justsoftware.authorization.oauth2.client.Oauth2Authorizations;
import de.justsoftware.authorization.oauth2.client.OauthTokenService;
import de.justsoftware.authorization.oauth2.client.RegisteredClients;
import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.ISqlExpressionBuilder;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.OpKt;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.QueryKt;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.DeleteStatement;
import org.jetbrains.exposed.sql.statements.UpsertStatement;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.jackson2.SecurityJackson2Modules;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationCode;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.OAuth2TokenType;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.jackson2.OAuth2AuthorizationServerJackson2Module;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J*\u0010\u000f\u001a\u00020\f*\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0012J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u001bH\u0012J \u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0019H\u0012J\u001c\u0010 \u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020\u00192\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0012J\u001e\u0010,\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020+0*H\u0016J\u0010\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u000200H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u00061"}, d2={"Lde/justsoftware/authorization/oauth2/client/ExposedOauth2AuthorizationService;", "Lorg/springframework/security/oauth2/server/authorization/OAuth2AuthorizationService;", "Lde/justsoftware/authorization/oauth2/client/OauthTokenService;", "registeredClientRepository", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;", "<init>", "(Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/json/JsonMapper;", "save", "", "authorization", "Lorg/springframework/security/oauth2/server/authorization/OAuth2Authorization;", "setProfileAndTenantId", "Lde/justsoftware/authorization/oauth2/client/Oauth2Authorizations;", "it", "Lorg/jetbrains/exposed/sql/statements/UpsertStatement;", "", "client", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClient;", "remove", "findById", "id", "", "toOauth2Authorization", "Lorg/jetbrains/exposed/sql/ResultRow;", "parseMap", "", "", "data", "findByToken", "token", "tokenType", "Lorg/springframework/security/oauth2/server/authorization/OAuth2TokenType;", "deleteMobileTokensForProfile", "", "profileId", "Lde/justsoftware/authorization/id/ProfileId;", "countMobileTokensForProfile", "getMobileClientIds", "", "Ljava/util/UUID;", "countTokensForProfileAndClients", "registeredClientIds", "deleteExpiredTokens", "expiredFor", "Ljava/time/Duration;", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nExposedOauth2AuthorizationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExposedOauth2AuthorizationService.kt\nde/justsoftware/authorization/oauth2/client/ExposedOauth2AuthorizationService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Queries.kt\norg/jetbrains/exposed/sql/QueriesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,316:1\n1#2:317\n121#3,5:318\n121#3,5:323\n121#3,5:332\n1557#4:328\n1628#4,3:329\n*S KotlinDebug\n*F\n+ 1 ExposedOauth2AuthorizationService.kt\nde/justsoftware/authorization/oauth2/client/ExposedOauth2AuthorizationService\n*L\n131#1:318,5\n279#1:323,5\n308#1:332,5\n291#1:328\n291#1:329,3\n*E\n"})
public class ExposedOauth2AuthorizationService
implements OAuth2AuthorizationService,
OauthTokenService {
    @NotNull
    private final RegisteredClientRepository registeredClientRepository;
    @NotNull
    private final JsonMapper objectMapper;

    public ExposedOauth2AuthorizationService(@NotNull RegisteredClientRepository registeredClientRepository) {
        Intrinsics.checkNotNullParameter((Object)registeredClientRepository, (String)"registeredClientRepository");
        this.registeredClientRepository = registeredClientRepository;
        Module[] moduleArray = new Module[]{ItemIdSerializer.INSTANCE, ItemIdDeserializer.INSTANCE};
        ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)ExtensionsKt.jacksonMapperBuilder().addModule((Module)new OAuth2AuthorizationServerJackson2Module())).addModules((Iterable)SecurityJackson2Modules.getModules((ClassLoader)this.getClass().getClassLoader()))).addModules(moduleArray)).build();
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"build(...)");
        this.objectMapper = (JsonMapper)objectMapper;
    }

    @NotNull
    public JsonMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void save(@NotNull OAuth2Authorization authorization) {
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        RegisteredClient registeredClient = this.registeredClientRepository.findById(authorization.getRegisteredClientId());
        Intrinsics.checkNotNull((Object)registeredClient);
        RegisteredClient client = registeredClient;
        QueriesKt.upsert$default((Table)((Table)Oauth2Authorizations.INSTANCE), (Column[])new Column[0], null, null, null, (arg_0, arg_1) -> ExposedOauth2AuthorizationService.save$lambda$1(authorization, this, client, arg_0, arg_1), (int)14, null);
    }

    private void setProfileAndTenantId(Oauth2Authorizations $this$setProfileAndTenantId, UpsertStatement<Long> it, OAuth2Authorization authorization, RegisteredClient client) {
        block2: {
            block1: {
                Object principal = authorization.getAttributes().get(Principal.class.getName());
                if (!(principal instanceof AbstractAuthenticationToken)) break block1;
                Object user = ((AbstractAuthenticationToken)principal).getPrincipal();
                if (!(user instanceof JustUser)) break block2;
                if (((JustUser)user).getTenantId() != null) {
                    it.set($this$setProfileAndTenantId.getPrincipalTenantId(), (Object)((JustUser)user).getTenantId().getValue());
                }
                it.set($this$setProfileAndTenantId.getPrincipalProfileId(), (Object)((JustUser)user).getProfileId().toTypedString());
                break block2;
            }
            TenantId tenantId = ExposedRegisteredClientRepositoryKt.tenantId((RegisteredClient)client);
            if (tenantId == null) break block2;
            TenantId tenantId2 = tenantId;
            boolean bl = false;
            it.set($this$setProfileAndTenantId.getPrincipalTenantId(), (Object)tenantId2.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void remove(@NotNull OAuth2Authorization authorization) {
        void $this$remove_u24lambda_u243;
        Intrinsics.checkNotNullParameter((Object)authorization, (String)"authorization");
        Table $this$deleteWhere_u24default$iv = (Table)Oauth2Authorizations.INSTANCE;
        Integer limit$iv = null;
        boolean $i$f$deleteWhere = false;
        ISqlExpressionBuilder iSqlExpressionBuilder = (ISqlExpressionBuilder)SqlExpressionBuilder.INSTANCE;
        Oauth2Authorizations oauth2Authorizations = (Oauth2Authorizations)$this$deleteWhere_u24default$iv;
        Table table = $this$deleteWhere_u24default$iv;
        Transaction transaction = TransactionManager.Companion.current();
        DeleteStatement.Companion companion = DeleteStatement.Companion;
        boolean bl = false;
        Op op = SqlExpressionBuilder.INSTANCE.eqEntityIDValue((ExpressionWithColumnType)$this$remove_u24lambda_u243.getId(), (Object)UUID.fromString(authorization.getId()));
        companion.where(transaction, table, op, false, limit$iv);
    }

    @Nullable
    public OAuth2Authorization findById(@NotNull String id) {
        OAuth2Authorization oAuth2Authorization;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ResultRow resultRow = (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)Oauth2Authorizations.INSTANCE)).where(SqlExpressionBuilder.INSTANCE.eqEntityIDValue((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getId(), (Object)UUID.fromString(id)))));
        if (resultRow != null) {
            ResultRow it = resultRow;
            boolean bl = false;
            oAuth2Authorization = this.toOauth2Authorization(it);
        } else {
            oAuth2Authorization = null;
        }
        return oAuth2Authorization;
    }

    private OAuth2Authorization toOauth2Authorization(ResultRow it) {
        String refreshTokenValue;
        String oidcIdTokenValue;
        CharSequence authorizationCode;
        String authorizationCodeValue;
        UUID registeredClientId = (UUID)it.get((Expression)Oauth2Authorizations.INSTANCE.getRegisteredClientId());
        RegisteredClient registeredClient = this.registeredClientRepository.findById(registeredClientId.toString());
        if (registeredClient == null) {
            throw new DataRetrievalFailureException("The RegisteredClient with id '" + registeredClientId + "' was not found in the RegisteredClientRepository.");
        }
        RegisteredClient registeredClient2 = registeredClient;
        String profileId = (String)it.get((Expression)Oauth2Authorizations.INSTANCE.getPrincipalProfileId());
        OAuth2Authorization.Builder builder = OAuth2Authorization.withRegisteredClient((RegisteredClient)registeredClient2).id(((UUID)((EntityID)it.get((Expression)Oauth2Authorizations.INSTANCE.getId())).getValue()).toString()).principalName((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getPrincipalName())).authorizationGrantType(new AuthorizationGrantType((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAuthorizationGrantType()))).authorizedScopes(StringUtils.commaDelimitedListToSet((String)((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAuthorizedScopes())))).attributes(arg_0 -> ExposedOauth2AuthorizationService.toOauth2Authorization$lambda$6(this, it, profileId, arg_0));
        Instant tokenIssuedAt = null;
        Instant tokenExpiresAt = null;
        String accessTokenValue = (String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenValue());
        CharSequence charSequence = accessTokenValue;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            tokenIssuedAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenIssuedAt());
            tokenExpiresAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenExpiresAt());
            Map accessTokenMetadata = this.parseMap((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenMetadata()));
            OAuth2AccessToken.TokenType tokenType = OAuth2AccessToken.TokenType.BEARER;
            Intrinsics.checkNotNullExpressionValue((Object)tokenType, (String)"BEARER");
            OAuth2AccessToken.TokenType tokenType2 = tokenType;
            Set set = StringUtils.commaDelimitedListToSet((String)((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenScopes())));
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"commaDelimitedListToSet(...)");
            Set accessTokenScopes = set;
            OAuth2AccessToken accessToken = new OAuth2AccessToken(tokenType2, accessTokenValue, tokenIssuedAt, tokenExpiresAt, accessTokenScopes);
            builder.token((OAuth2Token)accessToken, arg_0 -> ExposedOauth2AuthorizationService.toOauth2Authorization$lambda$8(accessTokenMetadata, profileId, it, arg_0));
        }
        if (StringUtils.hasText((String)(authorizationCodeValue = (String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAuthorizationCodeValue())))) {
            tokenIssuedAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenIssuedAt());
            tokenExpiresAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenExpiresAt());
            Map authorizationCodeMetadata = this.parseMap((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getAuthorizationCodeMetadata()));
            authorizationCode = new OAuth2AuthorizationCode(authorizationCodeValue, tokenIssuedAt, tokenExpiresAt);
            builder.token((OAuth2Token)authorizationCode, arg_0 -> ExposedOauth2AuthorizationService.toOauth2Authorization$lambda$9(authorizationCodeMetadata, arg_0));
        }
        if (!((authorizationCode = (CharSequence)(oidcIdTokenValue = (String)it.get((Expression)Oauth2Authorizations.INSTANCE.getOidcTokenValue()))) == null || StringsKt.isBlank((CharSequence)authorizationCode))) {
            tokenIssuedAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getOidcTokenIssuedAt());
            tokenExpiresAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getOidcTokenExpiresAt());
            Map oidcTokenMetadata = this.parseMap((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getOidcTokenMetadata()));
            OidcIdToken oidcToken = new OidcIdToken(oidcIdTokenValue, tokenIssuedAt, tokenExpiresAt, (Map)oidcTokenMetadata.get(OAuth2Authorization.Token.CLAIMS_METADATA_NAME));
            builder.token((OAuth2Token)oidcToken, arg_0 -> ExposedOauth2AuthorizationService.toOauth2Authorization$lambda$10(oidcTokenMetadata, arg_0));
        }
        if (StringUtils.hasText((String)(refreshTokenValue = (String)it.get((Expression)Oauth2Authorizations.INSTANCE.getRefreshTokenValue())))) {
            tokenIssuedAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getRefreshTokenIssuedAt());
            tokenExpiresAt = (Instant)it.get((Expression)Oauth2Authorizations.INSTANCE.getRefreshTokenExpiresAt());
            Map refreshTokenMetadata = this.parseMap((String)it.get((Expression)Oauth2Authorizations.INSTANCE.getRefreshTokenMetadata()));
            OAuth2RefreshToken refreshToken = new OAuth2RefreshToken(refreshTokenValue, tokenIssuedAt, tokenExpiresAt);
            builder.token((OAuth2Token)refreshToken, arg_0 -> ExposedOauth2AuthorizationService.toOauth2Authorization$lambda$11(refreshTokenMetadata, arg_0));
        }
        OAuth2Authorization oAuth2Authorization = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)oAuth2Authorization, (String)"build(...)");
        return oAuth2Authorization;
    }

    private Map<String, Object> parseMap(String data) {
        try {
            Map map;
            if (data == null) {
                map = MapsKt.emptyMap();
            } else {
                Object object = this.getObjectMapper().readValue(data, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
                map = (Map)object;
            }
            return map;
        }
        catch (JacksonException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    @Nullable
    public OAuth2Authorization findByToken(@NotNull String token, @Nullable OAuth2TokenType tokenType) {
        OAuth2Authorization oAuth2Authorization;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        OAuth2TokenType oAuth2TokenType = tokenType;
        Op predicate = Intrinsics.areEqual((Object)oAuth2TokenType, (Object)new OAuth2TokenType("code")) ? SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getAuthorizationCodeValue(), (Object)token) : (Intrinsics.areEqual((Object)oAuth2TokenType, (Object)OAuth2TokenType.REFRESH_TOKEN) ? SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getRefreshTokenValue(), (Object)token) : (Intrinsics.areEqual((Object)oAuth2TokenType, (Object)OAuth2TokenType.ACCESS_TOKEN) ? SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getAccessTokenValue(), (Object)token) : (Intrinsics.areEqual((Object)oAuth2TokenType, (Object)new OAuth2TokenType("id_token")) ? SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getOidcTokenValue(), (Object)token) : (Intrinsics.areEqual((Object)oAuth2TokenType, (Object)new OAuth2TokenType("state")) ? SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getState(), (Object)token) : SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getAccessTokenValue(), (Object)token)))));
        oAuth2TokenType = (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)Oauth2Authorizations.INSTANCE)).where(predicate)));
        if (oAuth2TokenType != null) {
            OAuth2TokenType it = oAuth2TokenType;
            boolean bl = false;
            oAuth2Authorization = this.toOauth2Authorization((ResultRow)it);
        } else {
            oAuth2Authorization = null;
        }
        return oAuth2Authorization;
    }

    /*
     * WARNING - void declaration
     */
    public int deleteMobileTokensForProfile(@NotNull ProfileId profileId) {
        void $this$deleteMobileTokensForProfile_u24lambda_u2413;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Set mobileClients = this.getMobileClientIds();
        Table $this$deleteWhere_u24default$iv = (Table)Oauth2Authorizations.INSTANCE;
        Integer limit$iv = null;
        boolean $i$f$deleteWhere = false;
        ISqlExpressionBuilder iSqlExpressionBuilder = (ISqlExpressionBuilder)SqlExpressionBuilder.INSTANCE;
        Oauth2Authorizations oauth2Authorizations = (Oauth2Authorizations)$this$deleteWhere_u24default$iv;
        Table table = $this$deleteWhere_u24default$iv;
        Transaction transaction = TransactionManager.Companion.current();
        DeleteStatement.Companion companion = DeleteStatement.Companion;
        boolean bl = false;
        Op op = OpKt.and((Expression)((Expression)SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)$this$deleteMobileTokensForProfile_u24lambda_u2413.getPrincipalProfileId(), (Object)profileId.toTypedString())), (Expression)((Expression)SqlExpressionBuilder.INSTANCE.inList((ExpressionWithColumnType)$this$deleteMobileTokensForProfile_u24lambda_u2413.getRegisteredClientId(), (Iterable)mobileClients)));
        return companion.where(transaction, table, op, false, limit$iv);
    }

    public int countMobileTokensForProfile(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Set mobileClients = this.getMobileClientIds();
        return this.countTokensForProfileAndClients(profileId, mobileClients);
    }

    /*
     * WARNING - void declaration
     */
    private Set<UUID> getMobileClientIds() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)RegisteredClients.INSTANCE)).where(ExposedOauth2AuthorizationService::getMobileClientIds$lambda$14);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResultRow resultRow = (ResultRow)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((UUID)((EntityID)it.get((Expression)RegisteredClients.INSTANCE.getId())).getValue());
        }
        Set mobileClients = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        return mobileClients;
    }

    public int countTokensForProfileAndClients(@NotNull ProfileId profileId, @NotNull Set<UUID> registeredClientIds) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(registeredClientIds, (String)"registeredClientIds");
        Query query = QueriesKt.selectAll((FieldSet)((FieldSet)Oauth2Authorizations.INSTANCE)).where(arg_0 -> ExposedOauth2AuthorizationService.countTokensForProfileAndClients$lambda$16(profileId, arg_0));
        if (!((Collection)registeredClientIds).isEmpty()) {
            QueryKt.andWhere((Query)query, arg_0 -> ExposedOauth2AuthorizationService.countTokensForProfileAndClients$lambda$17(registeredClientIds, arg_0));
        }
        return (int)query.count();
    }

    /*
     * WARNING - void declaration
     */
    public void deleteExpiredTokens(@NotNull Duration expiredFor) {
        void $this$deleteExpiredTokens_u24lambda_u2418;
        Intrinsics.checkNotNullParameter((Object)expiredFor, (String)"expiredFor");
        Instant maxExpiryTime = Instant.now().minus(expiredFor);
        Table $this$deleteWhere_u24default$iv = (Table)Oauth2Authorizations.INSTANCE;
        Integer limit$iv = null;
        boolean $i$f$deleteWhere = false;
        ISqlExpressionBuilder iSqlExpressionBuilder = (ISqlExpressionBuilder)SqlExpressionBuilder.INSTANCE;
        Oauth2Authorizations oauth2Authorizations = (Oauth2Authorizations)$this$deleteWhere_u24default$iv;
        Table table = $this$deleteWhere_u24default$iv;
        Transaction transaction = TransactionManager.Companion.current();
        DeleteStatement.Companion companion = DeleteStatement.Companion;
        boolean bl = false;
        Expression expression = (Expression)SqlExpressionBuilder.INSTANCE.isNull((Expression)$this$deleteExpiredTokens_u24lambda_u2418.getAccessTokenExpiresAt());
        ExpressionWithColumnType expressionWithColumnType = (ExpressionWithColumnType)$this$deleteExpiredTokens_u24lambda_u2418.getAccessTokenExpiresAt();
        Intrinsics.checkNotNull((Object)maxExpiryTime);
        Op op = OpKt.and((Expression)((Expression)OpKt.and((Expression)((Expression)OpKt.or((Expression)expression, (Expression)((Expression)SqlExpressionBuilder.INSTANCE.less(expressionWithColumnType, (Comparable)maxExpiryTime)))), (Expression)((Expression)OpKt.or((Expression)((Expression)SqlExpressionBuilder.INSTANCE.isNull((Expression)$this$deleteExpiredTokens_u24lambda_u2418.getRefreshTokenExpiresAt())), (Expression)((Expression)SqlExpressionBuilder.INSTANCE.less((ExpressionWithColumnType)$this$deleteExpiredTokens_u24lambda_u2418.getRefreshTokenExpiresAt(), (Comparable)maxExpiryTime)))))), (Expression)((Expression)OpKt.or((Expression)((Expression)SqlExpressionBuilder.INSTANCE.isNull((Expression)$this$deleteExpiredTokens_u24lambda_u2418.getAuthorizationCodeExpiresAt())), (Expression)((Expression)SqlExpressionBuilder.INSTANCE.less((ExpressionWithColumnType)$this$deleteExpiredTokens_u24lambda_u2418.getAuthorizationCodeExpiresAt(), (Comparable)maxExpiryTime)))));
        companion.where(transaction, table, op, false, limit$iv);
    }

    private static final Unit save$lambda$1(OAuth2Authorization $authorization, ExposedOauth2AuthorizationService this$0, RegisteredClient $client, Oauth2Authorizations $this$upsert, UpsertStatement it) {
        OAuth2Authorization.Token token;
        OAuth2Authorization.Token token2;
        OAuth2Authorization.Token token3;
        OAuth2Authorization.Token token4;
        OAuth2Authorization.Token token5;
        OAuth2Authorization.Token token6;
        OAuth2Authorization.Token token7;
        OAuth2Authorization.Token token8;
        OAuth2Authorization.Token token9;
        OAuth2Authorization.Token token10;
        OAuth2Authorization.Token token11;
        OAuth2Authorization.Token token12;
        OAuth2Authorization.Token token13;
        Intrinsics.checkNotNullParameter((Object)$authorization, (String)"$authorization");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$this$upsert, (String)"$this$upsert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Column column = $this$upsert.getId();
        UUID uUID = UUID.fromString($authorization.getId());
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
        it.setWithEntityIdValue(column, (Object)uUID);
        it.set($this$upsert.getRegisteredClientId(), (Object)UUID.fromString($authorization.getRegisteredClientId()));
        it.set($this$upsert.getPrincipalName(), (Object)$authorization.getPrincipalName());
        this$0.setProfileAndTenantId($this$upsert, it, $authorization, $client);
        it.set($this$upsert.getAuthorizationGrantType(), (Object)$authorization.getAuthorizationGrantType().getValue());
        it.set($this$upsert.getAuthorizedScopes(), (Object)StringUtils.collectionToCommaDelimitedString((Collection)$authorization.getAuthorizedScopes()));
        it.set($this$upsert.getState(), $authorization.getAttribute("state"));
        it.set($this$upsert.getAttributes(), (Object)this$0.getObjectMapper().writeValueAsString((Object)$authorization.getAttributes()));
        OAuth2Authorization.Token authorizationCodeToken = $authorization.getToken(OAuth2AuthorizationCode.class);
        it.set($this$upsert.getAuthorizationCodeValue(), (token13 = authorizationCodeToken) != null && (token13 = (OAuth2AuthorizationCode)token13.getToken()) != null ? token13.getTokenValue() : null);
        it.set($this$upsert.getAuthorizationCodeIssuedAt(), (token12 = authorizationCodeToken) != null && (token12 = (OAuth2AuthorizationCode)token12.getToken()) != null ? token12.getIssuedAt() : null);
        it.set($this$upsert.getAuthorizationCodeExpiresAt(), (token11 = authorizationCodeToken) != null && (token11 = (OAuth2AuthorizationCode)token11.getToken()) != null ? token11.getExpiresAt() : null);
        OAuth2Authorization.Token token14 = authorizationCodeToken;
        it.set($this$upsert.getAuthorizationCodeMetadata(), (Object)this$0.getObjectMapper().writeValueAsString((Object)(token14 != null ? token14.getMetadata() : null)));
        OAuth2Authorization.Token accessToken = $authorization.getAccessToken();
        it.set($this$upsert.getAccessTokenValue(), (token10 = accessToken) != null && (token10 = (OAuth2AccessToken)token10.getToken()) != null ? token10.getTokenValue() : null);
        it.set($this$upsert.getAccessTokenIssuedAt(), (token9 = accessToken) != null && (token9 = (OAuth2AccessToken)token9.getToken()) != null ? token9.getIssuedAt() : null);
        it.set($this$upsert.getAccessTokenExpiresAt(), (token8 = accessToken) != null && (token8 = (OAuth2AccessToken)token8.getToken()) != null ? token8.getExpiresAt() : null);
        OAuth2Authorization.Token token15 = accessToken;
        it.set($this$upsert.getAccessTokenMetadata(), (Object)this$0.getObjectMapper().writeValueAsString((Object)(token15 != null ? token15.getMetadata() : null)));
        it.set($this$upsert.getAccessTokenType(), (token7 = accessToken) != null && (token7 = (OAuth2AccessToken)token7.getToken()) != null && (token7 = token7.getTokenType()) != null ? token7.getValue() : null);
        OAuth2Authorization.Token token16 = accessToken;
        if (token16 != null && (token16 = (OAuth2AccessToken)token16.getToken()) != null) {
            boolean bl = false;
            it.set($this$upsert.getAccessTokenScopes(), (Object)StringUtils.collectionToCommaDelimitedString((Collection)((OAuth2AccessToken)accessToken.getToken()).getScopes()));
        }
        OAuth2Authorization.Token oidcIdToken = $authorization.getToken(OidcIdToken.class);
        it.set($this$upsert.getOidcTokenValue(), (token6 = oidcIdToken) != null && (token6 = (OidcIdToken)token6.getToken()) != null ? token6.getTokenValue() : null);
        it.set($this$upsert.getOidcTokenIssuedAt(), (token5 = oidcIdToken) != null && (token5 = (OidcIdToken)token5.getToken()) != null ? token5.getIssuedAt() : null);
        it.set($this$upsert.getOidcTokenExpiresAt(), (token4 = oidcIdToken) != null && (token4 = (OidcIdToken)token4.getToken()) != null ? token4.getExpiresAt() : null);
        OAuth2Authorization.Token token17 = oidcIdToken;
        it.set($this$upsert.getOidcTokenMetadata(), (Object)this$0.getObjectMapper().writeValueAsString((Object)(token17 != null ? token17.getMetadata() : null)));
        OAuth2Authorization.Token refreshToken = $authorization.getToken(OAuth2RefreshToken.class);
        it.set($this$upsert.getRefreshTokenValue(), (token3 = refreshToken) != null && (token3 = (OAuth2RefreshToken)token3.getToken()) != null ? token3.getTokenValue() : null);
        it.set($this$upsert.getRefreshTokenIssuedAt(), (token2 = refreshToken) != null && (token2 = (OAuth2RefreshToken)token2.getToken()) != null ? token2.getIssuedAt() : null);
        it.set($this$upsert.getRefreshTokenExpiresAt(), (token = refreshToken) != null && (token = (OAuth2RefreshToken)token.getToken()) != null ? token.getExpiresAt() : null);
        OAuth2Authorization.Token token18 = refreshToken;
        it.set($this$upsert.getRefreshTokenMetadata(), (Object)this$0.getObjectMapper().writeValueAsString((Object)(token18 != null ? token18.getMetadata() : null)));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final void toOauth2Authorization$lambda$6(ExposedOauth2AuthorizationService this$0, ResultRow $it, String $profileId, Map attributes) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        attributes.putAll(this$0.parseMap((String)$it.get((Expression)Oauth2Authorizations.INSTANCE.getAttributes())));
        if ($it.get((Expression)Oauth2Authorizations.INSTANCE.getAttributes()) == null && $profileId != null) {
            TenantId tenantId;
            ProfileId profileId = ProfileId.Companion.fromString($profileId);
            UUID uUID = (UUID)$it.get((Expression)Oauth2Authorizations.INSTANCE.getPrincipalTenantId());
            if (uUID != null) {
                void uuid;
                UUID uUID2 = uUID;
                ProfileId profileId2 = profileId;
                boolean bl = false;
                tenantId = TenantId.Companion.fromValue((UUID)uuid);
                profileId = profileId2;
            } else {
                tenantId = null;
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 512;
            String string = null;
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = true;
            List list = new ArrayList();
            String string2 = null;
            String string3 = (String)$it.get((Expression)Oauth2Authorizations.INSTANCE.getPrincipalName());
            TenantId tenantId2 = tenantId;
            ProfileId profileId3 = profileId;
            JustUser justUser = new JustUser(profileId3, tenantId2, string3, string2, list, bl4, bl3, bl2, bl, string, n, defaultConstructorMarker);
            UsernamePasswordAuthenticationToken principal = new UsernamePasswordAuthenticationToken((Object)justUser, null, (Collection)justUser.getAuthorities());
            Intrinsics.checkNotNull((Object)attributes);
            attributes.put(Principal.class.getName(), principal);
        }
    }

    private static final void toOauth2Authorization$lambda$8(Map $accessTokenMetadata, String $profileId, ResultRow $it, Map metadata) {
        Intrinsics.checkNotNullParameter((Object)$accessTokenMetadata, (String)"$accessTokenMetadata");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        metadata.putAll($accessTokenMetadata);
        if ($accessTokenMetadata.isEmpty()) {
            String string;
            Map claims = new LinkedHashMap();
            if ($profileId != null) {
                claims.put(ProfileId.Companion.getJsonKey(), $profileId);
            }
            Map map = claims;
            String string2 = TenantId.Companion.getJsonKey();
            UUID uUID = (UUID)$it.get((Expression)Oauth2Authorizations.INSTANCE.getPrincipalTenantId());
            if (uUID != null) {
                UUID uuid = uUID;
                boolean bl = false;
                string = TenantId.Companion.fromValue(uuid).toTypedString();
            } else {
                string = null;
            }
            String string3 = string;
            map.put(string2, string3);
            claims.put("username", $it.get((Expression)Oauth2Authorizations.INSTANCE.getPrincipalName()));
            claims.put("scope", $it.get((Expression)Oauth2Authorizations.INSTANCE.getAuthorizedScopes()));
            Intrinsics.checkNotNull((Object)metadata);
            metadata.put(OAuth2Authorization.Token.CLAIMS_METADATA_NAME, MapsKt.toMap((Map)claims));
        }
    }

    private static final void toOauth2Authorization$lambda$9(Map $authorizationCodeMetadata, Map metadata) {
        Intrinsics.checkNotNullParameter((Object)$authorizationCodeMetadata, (String)"$authorizationCodeMetadata");
        metadata.putAll($authorizationCodeMetadata);
    }

    private static final void toOauth2Authorization$lambda$10(Map $oidcTokenMetadata, Map metadata) {
        Intrinsics.checkNotNullParameter((Object)$oidcTokenMetadata, (String)"$oidcTokenMetadata");
        metadata.putAll($oidcTokenMetadata);
    }

    private static final void toOauth2Authorization$lambda$11(Map $refreshTokenMetadata, Map metadata) {
        Intrinsics.checkNotNullParameter((Object)$refreshTokenMetadata, (String)"$refreshTokenMetadata");
        metadata.putAll($refreshTokenMetadata);
    }

    private static final Op getMobileClientIds$lambda$14(SqlExpressionBuilder $this$where) {
        Intrinsics.checkNotNullParameter((Object)$this$where, (String)"$this$where");
        return (Op)$this$where.inList((ExpressionWithColumnType)RegisteredClients.INSTANCE.getClientId(), (Iterable)JustOauthClients.Companion.getMOBILE_CLIENT_IDS());
    }

    private static final Op countTokensForProfileAndClients$lambda$16(ProfileId $profileId, SqlExpressionBuilder $this$where) {
        Intrinsics.checkNotNullParameter((Object)$profileId, (String)"$profileId");
        Intrinsics.checkNotNullParameter((Object)$this$where, (String)"$this$where");
        return $this$where.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getPrincipalProfileId(), (Object)$profileId.toTypedString());
    }

    private static final Op countTokensForProfileAndClients$lambda$17(Set $registeredClientIds, SqlExpressionBuilder $this$andWhere) {
        Intrinsics.checkNotNullParameter((Object)$registeredClientIds, (String)"$registeredClientIds");
        Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
        return (Op)$this$andWhere.inList((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getRegisteredClientId(), (Iterable)$registeredClientIds);
    }
}

