/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.oauth2.client;

import de.justsoftware.authorization.config.JustOauthClients;
import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.oauth2.client.ExposedRegisteredClientRepositoryKt;
import de.justsoftware.authorization.oauth2.client.Oauth2Authorizations;
import de.justsoftware.authorization.oauth2.client.RegisteredClients;
import de.justsoftware.authorization.token.ApiToken;
import de.justsoftware.authorization.token.Scope;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.ISqlExpressionBuilder;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.QueryKt;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.DeleteStatement;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.springframework.security.crypto.keygen.Base64StringKeyGenerator;
import org.springframework.security.crypto.keygen.StringKeyGenerator;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.server.authorization.OAuth2Authorization;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.settings.ClientSettings;
import org.springframework.security.oauth2.server.authorization.settings.OAuth2TokenFormat;
import org.springframework.security.oauth2.server.authorization.settings.TokenSettings;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenClaimsSet;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Transactional
@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0017J \u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lde/justsoftware/authorization/oauth2/client/ApiTokenService;", "", "clientRepository", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;", "oauth2AuthorizationService", "Lorg/springframework/security/oauth2/server/authorization/OAuth2AuthorizationService;", "justOauthClients", "Lde/justsoftware/authorization/config/JustOauthClients;", "<init>", "(Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;Lorg/springframework/security/oauth2/server/authorization/OAuth2AuthorizationService;Lde/justsoftware/authorization/config/JustOauthClients;)V", "getClientRepository", "()Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;", "getOauth2AuthorizationService", "()Lorg/springframework/security/oauth2/server/authorization/OAuth2AuthorizationService;", "getJustOauthClients", "()Lde/justsoftware/authorization/config/JustOauthClients;", "accessTokenGenerator", "Lorg/springframework/security/crypto/keygen/StringKeyGenerator;", "deleteApiTokensForScope", "", "tenantId", "Lde/justsoftware/authorization/id/TenantId;", "scope", "", "Lde/justsoftware/authorization/token/Scope;", "generateApiTokenForScope", "Lde/justsoftware/authorization/token/ApiToken;", "getCurrentApiToken", "getOrCreateClientForScope", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClient;", "getClientIdForScope", "", "just-authorization-server"})
@SourceDebugExtension(value={"SMAP\nApiTokenService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiTokenService.kt\nde/justsoftware/authorization/oauth2/client/ApiTokenService\n+ 2 Queries.kt\norg/jetbrains/exposed/sql/QueriesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n121#2,5:160\n121#2,5:165\n1557#3:170\n1628#3,3:171\n1557#3:174\n1628#3,2:175\n1557#3:177\n1628#3,3:178\n1630#3:181\n1557#3:182\n1628#3,3:183\n1557#3:186\n1628#3,3:187\n*S KotlinDebug\n*F\n+ 1 ApiTokenService.kt\nde/justsoftware/authorization/oauth2/client/ApiTokenService\n*L\n56#1:160,5\n63#1:165,5\n65#1:170\n65#1:171,3\n118#1:174\n118#1:175,2\n122#1:177\n122#1:178,3\n118#1:181\n138#1:182\n138#1:183,3\n155#1:186\n155#1:187,3\n*E\n"})
public class ApiTokenService {
    @NotNull
    private final RegisteredClientRepository clientRepository;
    @NotNull
    private final OAuth2AuthorizationService oauth2AuthorizationService;
    @NotNull
    private final JustOauthClients justOauthClients;
    @NotNull
    private final StringKeyGenerator accessTokenGenerator;

    public ApiTokenService(@NotNull RegisteredClientRepository clientRepository, @NotNull OAuth2AuthorizationService oauth2AuthorizationService, @NotNull JustOauthClients justOauthClients) {
        Intrinsics.checkNotNullParameter((Object)clientRepository, (String)"clientRepository");
        Intrinsics.checkNotNullParameter((Object)oauth2AuthorizationService, (String)"oauth2AuthorizationService");
        Intrinsics.checkNotNullParameter((Object)justOauthClients, (String)"justOauthClients");
        this.clientRepository = clientRepository;
        this.oauth2AuthorizationService = oauth2AuthorizationService;
        this.justOauthClients = justOauthClients;
        this.accessTokenGenerator = (StringKeyGenerator)new Base64StringKeyGenerator(Base64.getUrlEncoder().withoutPadding(), 48);
    }

    @NotNull
    public RegisteredClientRepository getClientRepository() {
        return this.clientRepository;
    }

    @NotNull
    public OAuth2AuthorizationService getOauth2AuthorizationService() {
        return this.oauth2AuthorizationService;
    }

    @NotNull
    public JustOauthClients getJustOauthClients() {
        return this.justOauthClients;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteApiTokensForScope(@NotNull TenantId tenantId, @NotNull Set<? extends Scope> scope) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        String clientId = this.getClientIdForScope(tenantId, scope);
        RegisteredClient client = this.getClientRepository().findByClientId(clientId);
        if (client != null) {
            void $this$deleteApiTokensForScope_u24lambda_u240;
            Table $this$deleteWhere_u24default$iv = (Table)RegisteredClients.INSTANCE;
            Integer limit$iv = null;
            boolean $i$f$deleteWhere = false;
            ISqlExpressionBuilder iSqlExpressionBuilder = (ISqlExpressionBuilder)SqlExpressionBuilder.INSTANCE;
            RegisteredClients registeredClients = (RegisteredClients)$this$deleteWhere_u24default$iv;
            Table table = $this$deleteWhere_u24default$iv;
            Transaction transaction = TransactionManager.Companion.current();
            DeleteStatement.Companion companion = DeleteStatement.Companion;
            boolean bl = false;
            Op op = SqlExpressionBuilder.INSTANCE.eqEntityIDValue((ExpressionWithColumnType)$this$deleteApiTokensForScope_u24lambda_u240.getId(), (Object)UUID.fromString(client.getId()));
            companion.where(transaction, table, op, false, limit$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public ApiToken generateApiTokenForScope(@NotNull TenantId tenantId, @NotNull Set<? extends Scope> scope) {
        void $this$mapTo$iv$iv;
        void $this$generateApiTokenForScope_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        RegisteredClient client = this.getOrCreateClientForScope(tenantId, scope);
        Table $this$deleteWhere_u24default$iv = (Table)Oauth2Authorizations.INSTANCE;
        Integer limit$iv = null;
        boolean $i$f$deleteWhere = false;
        ISqlExpressionBuilder iSqlExpressionBuilder = (ISqlExpressionBuilder)SqlExpressionBuilder.INSTANCE;
        Oauth2Authorizations oauth2Authorizations = (Oauth2Authorizations)$this$deleteWhere_u24default$iv;
        Table table = $this$deleteWhere_u24default$iv;
        Transaction transaction = TransactionManager.Companion.current();
        Object object = DeleteStatement.Companion;
        boolean bl = false;
        Op op = SqlExpressionBuilder.INSTANCE.eq((ExpressionWithColumnType)$this$generateApiTokenForScope_u24lambda_u241.getRegisteredClientId(), (Object)UUID.fromString(client.getId()));
        object.where(transaction, table, op, false, limit$iv);
        Iterable $this$map$iv = scope;
        boolean $i$f$map = false;
        Iterable it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Scope scope2 = (Scope)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            object.add(it2.name());
        }
        Set scopes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Instant issuedAt = Instant.now();
        Instant expiresAt = issuedAt.plus(client.getTokenSettings().getAccessTokenTimeToLive());
        OAuth2TokenClaimsSet.Builder claimsBuilder = OAuth2TokenClaimsSet.builder();
        claimsBuilder.issuer(this.getJustOauthClients().getSystemDomainPrefix());
        claimsBuilder.subject(client.getClientId()).audience(CollectionsKt.listOf((Object)client.getClientId())).issuedAt(issuedAt).expiresAt(expiresAt).notBefore(issuedAt).id(UUID.randomUUID().toString());
        if (!CollectionUtils.isEmpty((Collection)scopes)) {
            claimsBuilder.claim("scope", (Object)scopes);
        }
        OAuth2TokenClaimsSet accessTokenClaimsSet = claimsBuilder.build();
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, this.accessTokenGenerator.generateKey(), accessTokenClaimsSet.getIssuedAt(), accessTokenClaimsSet.getExpiresAt(), scopes);
        OAuth2Authorization authorization = OAuth2Authorization.withRegisteredClient((RegisteredClient)client).token((OAuth2Token)accessToken, arg_0 -> ApiTokenService.generateApiTokenForScope$lambda$3(tenantId, client, scopes, arg_0)).authorizedScopes(scopes).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).principalName(client.getClientId()).build();
        this.getOauth2AuthorizationService().save(authorization);
        ApiToken apiToken = this.getCurrentApiToken(tenantId, scope);
        Intrinsics.checkNotNull((Object)apiToken);
        return apiToken;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ApiToken getCurrentApiToken(@NotNull TenantId tenantId, @NotNull Set<? extends Scope> scope) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        String clientId = this.getClientIdForScope(tenantId, scope);
        RegisteredClient client = this.getClientRepository().findByClientId(clientId);
        if (client == null) {
            return null;
        }
        Iterable iterable = (Iterable)QueryKt.andWhere((Query)QueriesKt.selectAll((FieldSet)((FieldSet)Oauth2Authorizations.INSTANCE)).where(arg_0 -> ApiTokenService.getCurrentApiToken$lambda$4(client, arg_0)), arg_0 -> ApiTokenService.getCurrentApiToken$lambda$5(tenantId, arg_0));
        boolean $i$f$map = false;
        void var7_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<Scope> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            void resultRow;
            ResultRow resultRow2 = (ResultRow)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Object object = resultRow.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenValue());
            Intrinsics.checkNotNull((Object)object);
            String string = (String)object;
            Object object2 = resultRow.get((Expression)Oauth2Authorizations.INSTANCE.getAccessTokenExpiresAt());
            Intrinsics.checkNotNull((Object)object2);
            Instant instant = (Instant)object2;
            Set set = StringUtils.commaDelimitedListToSet((String)((String)resultRow.get((Expression)Oauth2Authorizations.INSTANCE.getAuthorizedScopes())));
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"commaDelimitedListToSet(...)");
            Iterable iterable2 = set;
            Instant instant2 = instant;
            String string2 = string;
            boolean $i$f$map2 = false;
            void var18_18 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                String string3 = (String)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(Scope.valueOf((String)it));
            }
            collection = (List)destination$iv$iv2;
            Set set2 = CollectionsKt.toSet((Iterable)collection);
            Instant instant3 = instant2;
            String string4 = string2;
            collection2.add(new ApiToken(string4, instant3, set2));
        }
        return (ApiToken)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public RegisteredClient getOrCreateClientForScope(@NotNull TenantId tenantId, @NotNull Set<? extends Scope> scope) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(scope, (String)"scope");
        String clientId = this.getClientIdForScope(tenantId, scope);
        RegisteredClient client = this.getClientRepository().findByClientId(clientId);
        if (client != null) {
            boolean bl = Intrinsics.areEqual((Object)ExposedRegisteredClientRepositoryKt.tenantId((RegisteredClient)client), (Object)tenantId);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            return client;
        }
        ClientSettings.Builder builder = ClientSettings.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
        ClientSettings clientSettings = ExposedRegisteredClientRepositoryKt.tenantId((ClientSettings.Builder)builder, (TenantId)tenantId).requireProofKey(false).requireAuthorizationConsent(false).build();
        TokenSettings tokenSettings = TokenSettings.builder().accessTokenFormat(OAuth2TokenFormat.REFERENCE).accessTokenTimeToLive(Duration.ofDays(365L)).build();
        Iterable $this$map$iv = scope;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Scope scope2 = (Scope)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.name());
        }
        Set scopes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        RegisteredClient newClient = RegisteredClient.withId((String)UUID.randomUUID().toString()).clientId(clientId).clientSettings(clientSettings).tokenSettings(tokenSettings).scopes(arg_0 -> ApiTokenService.getOrCreateClientForScope$lambda$9(scopes, arg_0)).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).build();
        this.getClientRepository().save(newClient);
        Intrinsics.checkNotNull((Object)newClient);
        return newClient;
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    private String getClientIdForScope(TenantId tenantId, Set<? extends Scope> scope) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = scope;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void obj;
            Scope scope2 = (Scope)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(obj.toString());
        }
        String identifier = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null);
        return identifier + "_" + tenantId;
    }

    private static final void generateApiTokenForScope$lambda$3(TenantId $tenantId, RegisteredClient $client, Set $scopes, Map metadata) {
        Intrinsics.checkNotNullParameter((Object)$tenantId, (String)"$tenantId");
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$scopes, (String)"$scopes");
        Map claims = new LinkedHashMap();
        claims.put(TenantId.Companion.getJsonKey(), $tenantId.toTypedString());
        claims.put("username", $client.getClientId());
        claims.put("scope", StringUtils.collectionToCommaDelimitedString((Collection)$scopes));
        Intrinsics.checkNotNull((Object)metadata);
        metadata.put(OAuth2Authorization.Token.CLAIMS_METADATA_NAME, MapsKt.toMap((Map)claims));
    }

    private static final Op getCurrentApiToken$lambda$4(RegisteredClient $client, SqlExpressionBuilder $this$where) {
        Intrinsics.checkNotNullParameter((Object)$this$where, (String)"$this$where");
        return $this$where.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getRegisteredClientId(), (Object)UUID.fromString($client.getId()));
    }

    private static final Op getCurrentApiToken$lambda$5(TenantId $tenantId, SqlExpressionBuilder $this$andWhere) {
        Intrinsics.checkNotNullParameter((Object)$tenantId, (String)"$tenantId");
        Intrinsics.checkNotNullParameter((Object)$this$andWhere, (String)"$this$andWhere");
        return $this$andWhere.eq((ExpressionWithColumnType)Oauth2Authorizations.INSTANCE.getPrincipalTenantId(), (Object)$tenantId.getValue());
    }

    private static final void getOrCreateClientForScope$lambda$9(Set $scopes, Set it) {
        Intrinsics.checkNotNullParameter((Object)$scopes, (String)"$scopes");
        it.addAll($scopes);
    }
}

