/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.filter;

import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lde/justsoftware/authorization/filter/JwtFilter;", "Lde/justsoftware/jwtfilter/JwtAuthenticationProcessingFilter;", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "defaultTargetUrl", "", "<init>", "(Lde/justsoftware/jwtfilter/verifier/JwtVerifier;Ljava/lang/String;)V", "doFilter", "", "req", "Ljakarta/servlet/ServletRequest;", "res", "Ljakarta/servlet/ServletResponse;", "chain", "Ljakarta/servlet/FilterChain;", "just-authorization-server"})
public final class JwtFilter
extends JwtAuthenticationProcessingFilter {
    @NotNull
    private final String defaultTargetUrl;

    public JwtFilter(@NotNull JwtVerifier jwtVerifier, @NotNull String defaultTargetUrl) {
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        Intrinsics.checkNotNullParameter((Object)defaultTargetUrl, (String)"defaultTargetUrl");
        super(jwtVerifier);
        this.defaultTargetUrl = defaultTargetUrl;
    }

    public void doFilter(@NotNull ServletRequest req, @NotNull ServletResponse res, @NotNull FilterChain chain) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        FilterChain noOpFilterChain = JwtFilter::doFilter$lambda$0;
        super.doFilter(req, res, noOpFilterChain);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication instanceof JwtAuthenticationToken) {
            String principal = ((JwtAuthenticationToken)authentication).getPrincipal();
            TenantId tenantId = TenantId.Companion.fromString(String.valueOf(((JwtAuthenticationToken)authentication).getCustomJwtClaims().get((Object)"tenantId")));
            ProfileId profileId = ProfileId.Companion.fromString(((JwtAuthenticationToken)authentication).getPrincipal().toString());
            List list = CollectionsKt.listOf((Object)new SimpleGrantedAuthority("ROLE_USER"));
            String string = principal.toString();
            JustUser justUser = new JustUser(profileId, tenantId, string, null, list, true, true, true, true, null, 512, null);
            UsernamePasswordAuthenticationToken newAuth = UsernamePasswordAuthenticationToken.authenticated((Object)justUser, null, (Collection)CollectionsKt.listOf((Object)new SimpleGrantedAuthority("ROLE_USER")));
            SecurityContextHolder.getContext().setAuthentication((Authentication)newAuth);
            SavedRequestAwareAuthenticationSuccessHandler successHandler = new SavedRequestAwareAuthenticationSuccessHandler();
            successHandler.setDefaultTargetUrl(this.defaultTargetUrl);
            successHandler.onAuthenticationSuccess((HttpServletRequest)req, (HttpServletResponse)res, (Authentication)newAuth);
        }
        chain.doFilter(req, res);
    }

    private static final void doFilter$lambda$0(ServletRequest rq, ServletResponse rs) {
    }
}

