/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.controller.internal;

import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.settings.SettingsService;
import de.justsoftware.authorization.settings.TenantSettings;
import javax.annotation.ParametersAreNonnullByDefault;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal"}, produces={"application/json"})
@ParametersAreNonnullByDefault
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0017J\u0014\u0010\f\u001a\u0004\u0018\u00010\r2\b\b\u0001\u0010\b\u001a\u00020\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/authorization/controller/internal/InternalSettingsController;", "", "settingsService", "Lde/justsoftware/authorization/settings/SettingsService;", "<init>", "(Lde/justsoftware/authorization/settings/SettingsService;)V", "setMFAMandatory", "", "tenantId", "Lde/justsoftware/authorization/id/TenantId;", "mfaMandatory", "", "getTenantSettingsData", "Lde/justsoftware/authorization/settings/TenantSettings;", "just-authorization-server"})
public class InternalSettingsController {
    @NotNull
    private final SettingsService settingsService;

    public InternalSettingsController(@NotNull SettingsService settingsService) {
        Intrinsics.checkNotNullParameter((Object)settingsService, (String)"settingsService");
        this.settingsService = settingsService;
    }

    @PostMapping(value={"/settings/{tenantId}/mfaMandatory/{mfaMandatory}"})
    public void setMFAMandatory(@PathVariable @NotNull TenantId tenantId, @PathVariable boolean mfaMandatory) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.settingsService.upsert(new TenantSettings(tenantId, mfaMandatory));
    }

    @GetMapping(value={"/settings/{tenantId}"})
    @Nullable
    public TenantSettings getTenantSettingsData(@PathVariable @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.settingsService.get(tenantId);
    }
}

