/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.controller;

import de.justsoftware.authorization.controller.TOTPDeviceResponse;
import de.justsoftware.authorization.totp.TOTPAuthentication;
import de.justsoftware.authorization.totp.TOTPAuthenticationException;
import de.justsoftware.authorization.totp.TOTPAuthenticationService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.Principal;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/totp"})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0017JM\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\b\u0001\u0010\u0011\u001a\u00020\u00052\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0017\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/authorization/controller/TOTPLoginController;", "", "totpAuthenticationService", "Lde/justsoftware/authorization/totp/TOTPAuthenticationService;", "systemDomainPrefix", "", "<init>", "(Lde/justsoftware/authorization/totp/TOTPAuthenticationService;Ljava/lang/String;)V", "showRegisterDevicePage", "model", "Lorg/springframework/ui/Model;", "principal", "Ljava/security/Principal;", "csrfToken", "Lorg/springframework/security/web/csrf/CsrfToken;", "showTOTPLoginPage", "verifyTOTP", "code", "confirm", "", "request", "Ljakarta/servlet/http/HttpServletRequest;", "response", "Ljakarta/servlet/http/HttpServletResponse;", "(Ljava/lang/String;Ljava/lang/Boolean;Ljakarta/servlet/http/HttpServletRequest;Ljakarta/servlet/http/HttpServletResponse;Lorg/springframework/ui/Model;Lorg/springframework/security/web/csrf/CsrfToken;Ljava/security/Principal;)Ljava/lang/String;", "just-authorization-server"})
public class TOTPLoginController {
    @NotNull
    private final TOTPAuthenticationService totpAuthenticationService;
    @NotNull
    private final String systemDomainPrefix;

    public TOTPLoginController(@NotNull TOTPAuthenticationService totpAuthenticationService, @Value(value="${just.common.system.domainprefix}") @NotNull String systemDomainPrefix) {
        Intrinsics.checkNotNullParameter((Object)totpAuthenticationService, (String)"totpAuthenticationService");
        Intrinsics.checkNotNullParameter((Object)systemDomainPrefix, (String)"systemDomainPrefix");
        this.totpAuthenticationService = totpAuthenticationService;
        this.systemDomainPrefix = systemDomainPrefix;
    }

    @GetMapping(value={"/register"})
    @NotNull
    public String showRegisterDevicePage(@NotNull Model model, @NotNull Principal principal, @NotNull CsrfToken csrfToken) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        Intrinsics.checkNotNullParameter((Object)csrfToken, (String)"csrfToken");
        String string = principal.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (this.totpAuthenticationService.isDeviceConfirmed(string)) {
            return "redirect:/totp/login";
        }
        String string2 = principal.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        TOTPDeviceResponse result = this.totpAuthenticationService.addDevice(string2);
        model.addAttribute("secret", (Object)result.getDecryptedSecret());
        model.addAttribute("qrcode", (Object)result.getQrCode());
        model.addAttribute("csrf", (Object)csrfToken.getToken());
        return "totp-register";
    }

    @GetMapping(value={"/login"})
    @NotNull
    public String showTOTPLoginPage(@NotNull Model model, @NotNull CsrfToken csrfToken) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)csrfToken, (String)"csrfToken");
        model.addAttribute("csrf", (Object)csrfToken.getToken());
        return "totp-login";
    }

    @PostMapping(value={"/login"})
    @Nullable
    public String verifyTOTP(@RequestParam(value="code") @NotNull String code, @RequestParam(value="confirm") @Nullable Boolean confirm, @NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Model model, @NotNull CsrfToken csrfToken, @NotNull Principal principal) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)csrfToken, (String)"csrfToken");
        Intrinsics.checkNotNullParameter((Object)principal, (String)"principal");
        try {
            this.totpAuthenticationService.checkTOTPCode(code);
            Authentication currentAuthentication = SecurityContextHolder.getContext().getAuthentication();
            if (!(currentAuthentication instanceof TOTPAuthentication)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Authentication initialAuth = ((TOTPAuthentication)currentAuthentication).getInitial();
            SecurityContextHolder.getContext().setAuthentication(initialAuth);
            SavedRequestAwareAuthenticationSuccessHandler handler = new SavedRequestAwareAuthenticationSuccessHandler();
            handler.setDefaultTargetUrl(this.systemDomainPrefix);
            handler.onAuthenticationSuccess(request, response, initialAuth);
        }
        catch (TOTPAuthenticationException ex) {
            String string;
            model.addAttribute("error", (Object)ex.getMessage());
            Boolean bl = confirm;
            if (Intrinsics.areEqual((Object)bl, (Object)true)) {
                string = this.showRegisterDevicePage(model, principal, csrfToken);
            } else if (Intrinsics.areEqual((Object)bl, (Object)false) || bl == null) {
                string = this.showTOTPLoginPage(model, csrfToken);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }
        return null;
    }
}

