/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.authorization.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import de.justsoftware.authorization.config.FeatureToggleService;
import de.justsoftware.authorization.config.InvalidateSessionAndAddTrustedDeviceAndRedirectHandler;
import de.justsoftware.authorization.config.JustOauthClients;
import de.justsoftware.authorization.config.LogoutSuccessHandler;
import de.justsoftware.authorization.config.SecurityConfig;
import de.justsoftware.authorization.filter.JwtFilter;
import de.justsoftware.authorization.id.ProfileId;
import de.justsoftware.authorization.id.TenantId;
import de.justsoftware.authorization.oauth2.JustAuthenticationProvider;
import de.justsoftware.authorization.oauth2.JustUser;
import de.justsoftware.authorization.oauth2.JustUserDetailService;
import de.justsoftware.authorization.oauth2.MobileClientRefreshTokenAuthenticationConverter;
import de.justsoftware.authorization.oauth2.MobileClientRefreshTokenAuthenticationProvider;
import de.justsoftware.authorization.oauth2.MobileOauth2RefreshTokenGenerator;
import de.justsoftware.authorization.oauth2.client.ExposedOauth2AuthorizationService;
import de.justsoftware.authorization.oauth2.client.ExposedRegisteredClientRepository;
import de.justsoftware.authorization.oauth2.client.ExposedRegisteredClientRepositoryKt;
import de.justsoftware.authorization.oauth2.passwordGrant.OAuth2PasswordGrantAuthenticationConverter;
import de.justsoftware.authorization.oauth2.passwordGrant.OAuth2PasswordGrantAuthenticationProvider;
import de.justsoftware.authorization.token.RememberMeTokenRepository;
import de.justsoftware.authorization.totp.TOTPAuthentication;
import de.justsoftware.authorization.totp.TOTPAuthenticationService;
import de.justsoftware.authorization.totp.TOTPAuthenticationSuccessHandler;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import jakarta.servlet.Filter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.ThreadLocalTransactionManagerKt;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.RememberMeConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.DelegatingPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.core.OAuth2Token;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtEncoder;
import org.springframework.security.oauth2.jwt.NimbusJwtEncoder;
import org.springframework.security.oauth2.server.authorization.OAuth2AuthorizationService;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClient;
import org.springframework.security.oauth2.server.authorization.client.RegisteredClientRepository;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configuration.OAuth2AuthorizationServerConfiguration;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2AuthorizationServerConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2ClientAuthenticationConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OAuth2TokenEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OidcConfigurer;
import org.springframework.security.oauth2.server.authorization.config.annotation.web.configurers.OidcLogoutEndpointConfigurer;
import org.springframework.security.oauth2.server.authorization.settings.AuthorizationServerSettings;
import org.springframework.security.oauth2.server.authorization.token.DelegatingOAuth2TokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.JwtEncodingContext;
import org.springframework.security.oauth2.server.authorization.token.JwtGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2AccessTokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2RefreshTokenGenerator;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenClaimsContext;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenCustomizer;
import org.springframework.security.oauth2.server.authorization.token.OAuth2TokenGenerator;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@DependsOn(value={"liquibase"})
@RefreshScope
@Configuration
@EnableWebSecurity
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 62\u00020\u0001:\u00016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017JZ\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0010\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0017J:\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0017J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0017J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0017J \u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0017J \u0010\f\u001a\u00020\r2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0017J\u0016\u00100\u001a\u0002012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0017J\b\u00102\u001a\u000203H\u0017J\b\u00104\u001a\u000205H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lde/justsoftware/authorization/config/SecurityConfig;", "", "authProvider", "Lde/justsoftware/authorization/oauth2/JustAuthenticationProvider;", "<init>", "(Lde/justsoftware/authorization/oauth2/JustAuthenticationProvider;)V", "authManager", "Lorg/springframework/security/authentication/AuthenticationManager;", "http", "Lorg/springframework/security/config/annotation/web/builders/HttpSecurity;", "authorizationServerSecurityFilterChain", "Lorg/springframework/security/web/SecurityFilterChain;", "registeredClientRepository", "Lorg/springframework/security/oauth2/server/authorization/client/RegisteredClientRepository;", "justTokenGenerator", "Lorg/springframework/security/oauth2/server/authorization/token/OAuth2TokenGenerator;", "Lorg/springframework/security/oauth2/core/OAuth2Token;", "jwkSource", "Lcom/nimbusds/jose/jwk/source/JWKSource;", "Lcom/nimbusds/jose/proc/SecurityContext;", "rememberMeServices", "Lorg/springframework/security/web/authentication/rememberme/PersistentTokenBasedRememberMeServices;", "authorizationService", "Lde/justsoftware/authorization/oauth2/client/ExposedOauth2AuthorizationService;", "justAuthenticationProvider", "systemDomainPrefix", "", "defaultSecurityFilterChain", "Lorg/springframework/security/web/authentication/RememberMeServices;", "featureToggleService", "Lde/justsoftware/authorization/config/FeatureToggleService;", "jwtVerifier", "Lde/justsoftware/jwtfilter/verifier/JwtVerifier;", "totpAuthenticationService", "Lde/justsoftware/authorization/totp/TOTPAuthenticationService;", "mfaAuthorizationManager", "Lorg/springframework/security/authorization/AuthorizationManager;", "Lorg/springframework/security/web/access/intercept/RequestAuthorizationContext;", "rememberMeTokenRepository", "Lde/justsoftware/authorization/token/RememberMeTokenRepository;", "userDetailService", "Lde/justsoftware/authorization/oauth2/JustUserDetailService;", "dataSource", "Ljavax/sql/DataSource;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "justAuthClients", "Lde/justsoftware/authorization/config/JustOauthClients;", "jwtDecoder", "Lorg/springframework/security/oauth2/jwt/JwtDecoder;", "authorizationServerSettings", "Lorg/springframework/security/oauth2/server/authorization/settings/AuthorizationServerSettings;", "passwordEncoder", "Lorg/springframework/security/crypto/password/PasswordEncoder;", "Companion", "just-authorization-server"})
public class SecurityConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JustAuthenticationProvider authProvider;
    private static final int TORO_BCRYPT_STRENGTH = 12;
    private static final int KEY_SIZE = 2048;
    private static final int THIRTY_DAYS_IN_SECONDS = 2592000;
    @NotNull
    private static final String[] UNAUTHORIZED_PATHS;

    public SecurityConfig(@NotNull JustAuthenticationProvider authProvider) {
        Intrinsics.checkNotNullParameter((Object)authProvider, (String)"authProvider");
        this.authProvider = authProvider;
    }

    @Bean
    @NotNull
    public AuthenticationManager authManager(@NotNull HttpSecurity http) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        AuthenticationManagerBuilder authenticationManagerBuilder = (AuthenticationManagerBuilder)http.getSharedObject(AuthenticationManagerBuilder.class);
        authenticationManagerBuilder.authenticationProvider((AuthenticationProvider)this.authProvider);
        Object object = authenticationManagerBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (AuthenticationManager)object;
    }

    @Bean
    @Order(value=1)
    @NotNull
    public SecurityFilterChain authorizationServerSecurityFilterChain(@NotNull HttpSecurity http, @NotNull RegisteredClientRepository registeredClientRepository, @NotNull OAuth2TokenGenerator<? extends OAuth2Token> justTokenGenerator, @NotNull JWKSource<SecurityContext> jwkSource, @NotNull PersistentTokenBasedRememberMeServices rememberMeServices, @NotNull ExposedOauth2AuthorizationService authorizationService, @NotNull JustAuthenticationProvider justAuthenticationProvider, @Value(value="${just.common.system.domainprefix}") @NotNull String systemDomainPrefix) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)registeredClientRepository, (String)"registeredClientRepository");
        Intrinsics.checkNotNullParameter(justTokenGenerator, (String)"justTokenGenerator");
        Intrinsics.checkNotNullParameter(jwkSource, (String)"jwkSource");
        Intrinsics.checkNotNullParameter((Object)rememberMeServices, (String)"rememberMeServices");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter((Object)justAuthenticationProvider, (String)"justAuthenticationProvider");
        Intrinsics.checkNotNullParameter((Object)systemDomainPrefix, (String)"systemDomainPrefix");
        http.setSharedObject(JWKSource.class, jwkSource);
        OAuth2AuthorizationServerConfiguration.applyDefaultSecurity((HttpSecurity)http);
        ((OAuth2AuthorizationServerConfigurer)http.getConfigurer(OAuth2AuthorizationServerConfigurer.class)).oidc(arg_0 -> SecurityConfig.authorizationServerSecurityFilterChain$lambda$1(rememberMeServices, systemDomainPrefix, arg_0)).clientAuthentication(arg_0 -> SecurityConfig.authorizationServerSecurityFilterChain$lambda$2(registeredClientRepository, arg_0)).authorizationEndpoint(SecurityConfig::authorizationServerSecurityFilterChain$lambda$3).tokenEndpoint(arg_0 -> SecurityConfig.authorizationServerSecurityFilterChain$lambda$4(justAuthenticationProvider, authorizationService, justTokenGenerator, arg_0)).tokenGenerator(justTokenGenerator);
        http.exceptionHandling(SecurityConfig::authorizationServerSecurityFilterChain$lambda$5).oauth2ResourceServer(SecurityConfig::authorizationServerSecurityFilterChain$lambda$6).sessionManagement(SecurityConfig::authorizationServerSecurityFilterChain$lambda$7);
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    @Bean
    @Order(value=2)
    @NotNull
    public SecurityFilterChain defaultSecurityFilterChain(@NotNull HttpSecurity http, @Value(value="${just.common.system.domainprefix}") @NotNull String systemDomainPrefix, @NotNull RememberMeServices rememberMeServices, @NotNull FeatureToggleService featureToggleService, @NotNull JwtVerifier jwtVerifier, @NotNull TOTPAuthenticationService totpAuthenticationService) {
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)systemDomainPrefix, (String)"systemDomainPrefix");
        Intrinsics.checkNotNullParameter((Object)rememberMeServices, (String)"rememberMeServices");
        Intrinsics.checkNotNullParameter((Object)featureToggleService, (String)"featureToggleService");
        Intrinsics.checkNotNullParameter((Object)jwtVerifier, (String)"jwtVerifier");
        Intrinsics.checkNotNullParameter((Object)totpAuthenticationService, (String)"totpAuthenticationService");
        http.authorizeHttpRequests(arg_0 -> SecurityConfig.defaultSecurityFilterChain$lambda$8(this, arg_0)).formLogin(arg_0 -> SecurityConfig.defaultSecurityFilterChain$lambda$9(featureToggleService, systemDomainPrefix, totpAuthenticationService, arg_0)).authenticationManager(this.authManager(http)).csrf(SecurityConfig::defaultSecurityFilterChain$lambda$10).sessionManagement(SecurityConfig::defaultSecurityFilterChain$lambda$11).rememberMe(arg_0 -> SecurityConfig.defaultSecurityFilterChain$lambda$12(rememberMeServices, arg_0)).addFilterAfter((Filter)new JwtFilter(jwtVerifier, systemDomainPrefix).applyAllowCookieOnlyVerificationMatcher((RequestMatcher)new AntPathRequestMatcher("/login")), AbstractPreAuthenticatedProcessingFilter.class);
        Object object = http.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"build(...)");
        return (SecurityFilterChain)object;
    }

    @Bean
    @NotNull
    public AuthorizationManager<RequestAuthorizationContext> mfaAuthorizationManager() {
        return SecurityConfig::mfaAuthorizationManager$lambda$13;
    }

    @Bean
    @NotNull
    public PersistentTokenBasedRememberMeServices rememberMeServices(@NotNull RememberMeTokenRepository rememberMeTokenRepository, @NotNull JustUserDetailService userDetailService) {
        Intrinsics.checkNotNullParameter((Object)rememberMeTokenRepository, (String)"rememberMeTokenRepository");
        Intrinsics.checkNotNullParameter((Object)userDetailService, (String)"userDetailService");
        PersistentTokenBasedRememberMeServices service = new PersistentTokenBasedRememberMeServices("just", (UserDetailsService)userDetailService, (PersistentTokenRepository)rememberMeTokenRepository);
        service.setCookieName("remember");
        service.setParameter("remember");
        return service;
    }

    @RefreshScope
    @Bean
    @NotNull
    public OAuth2TokenGenerator<? extends OAuth2Token> justTokenGenerator(@NotNull JWKSource<SecurityContext> jwkSource) {
        Intrinsics.checkNotNullParameter(jwkSource, (String)"jwkSource");
        JwtGenerator jwtGenerator = new JwtGenerator((JwtEncoder)new NimbusJwtEncoder(jwkSource));
        OAuth2TokenCustomizer customizer = SecurityConfig::justTokenGenerator$lambda$14;
        jwtGenerator.setJwtCustomizer(customizer);
        OAuth2AccessTokenGenerator accessTokenGenerator = new OAuth2AccessTokenGenerator();
        accessTokenGenerator.setAccessTokenCustomizer(SecurityConfig::justTokenGenerator$lambda$15);
        OAuth2RefreshTokenGenerator refreshTokenGenerator = new OAuth2RefreshTokenGenerator();
        MobileOauth2RefreshTokenGenerator mobileRefreshTokenGenerator = new MobileOauth2RefreshTokenGenerator();
        OAuth2TokenGenerator[] oAuth2TokenGeneratorArray = new OAuth2TokenGenerator[]{jwtGenerator, accessTokenGenerator, refreshTokenGenerator, mobileRefreshTokenGenerator};
        return (OAuth2TokenGenerator)new DelegatingOAuth2TokenGenerator(oAuth2TokenGeneratorArray);
    }

    @Bean(value={"registeredClientRepository"})
    @NotNull
    public RegisteredClientRepository registeredClientRepository(@NotNull DataSource dataSource, @NotNull ObjectMapper objectMapper, @NotNull JustOauthClients justAuthClients) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)justAuthClients, (String)"justAuthClients");
        ExposedRegisteredClientRepository repository = new ExposedRegisteredClientRepository(objectMapper);
        Database.Companion.connect$default((Database.Companion)Database.Companion, (DataSource)dataSource, null, null, null, null, (int)30, null);
        ThreadLocalTransactionManagerKt.transaction$default(null, arg_0 -> SecurityConfig.registeredClientRepository$lambda$16(repository, justAuthClients, arg_0), (int)1, null);
        return (RegisteredClientRepository)repository;
    }

    @RefreshScope
    @Bean
    @NotNull
    public JwtDecoder jwtDecoder(@NotNull JWKSource<SecurityContext> jwkSource) {
        Intrinsics.checkNotNullParameter(jwkSource, (String)"jwkSource");
        JwtDecoder jwtDecoder = OAuth2AuthorizationServerConfiguration.jwtDecoder(jwkSource);
        Intrinsics.checkNotNullExpressionValue((Object)jwtDecoder, (String)"jwtDecoder(...)");
        return jwtDecoder;
    }

    @Bean
    @NotNull
    public AuthorizationServerSettings authorizationServerSettings() {
        AuthorizationServerSettings authorizationServerSettings = AuthorizationServerSettings.builder().build();
        Intrinsics.checkNotNullExpressionValue((Object)authorizationServerSettings, (String)"build(...)");
        return authorizationServerSettings;
    }

    @Bean
    @NotNull
    public PasswordEncoder passwordEncoder() {
        String defaultEncoding = "bcrypt";
        Map encoders = new HashMap();
        encoders.put(defaultEncoding, new BCryptPasswordEncoder(BCryptPasswordEncoder.BCryptVersion.$2B, 12));
        return (PasswordEncoder)new DelegatingPasswordEncoder(defaultEncoding, encoders);
    }

    private static final void authorizationServerSecurityFilterChain$lambda$1$lambda$0(PersistentTokenBasedRememberMeServices $rememberMeServices, String $systemDomainPrefix, OidcLogoutEndpointConfigurer l) {
        Intrinsics.checkNotNullParameter((Object)$rememberMeServices, (String)"$rememberMeServices");
        Intrinsics.checkNotNullParameter((Object)$systemDomainPrefix, (String)"$systemDomainPrefix");
        l.logoutResponseHandler((AuthenticationSuccessHandler)new LogoutSuccessHandler($rememberMeServices, $systemDomainPrefix));
    }

    private static final void authorizationServerSecurityFilterChain$lambda$1(PersistentTokenBasedRememberMeServices $rememberMeServices, String $systemDomainPrefix, OidcConfigurer oidc) {
        Intrinsics.checkNotNullParameter((Object)$rememberMeServices, (String)"$rememberMeServices");
        Intrinsics.checkNotNullParameter((Object)$systemDomainPrefix, (String)"$systemDomainPrefix");
        oidc.logoutEndpoint(arg_0 -> SecurityConfig.authorizationServerSecurityFilterChain$lambda$1$lambda$0($rememberMeServices, $systemDomainPrefix, arg_0));
    }

    private static final void authorizationServerSecurityFilterChain$lambda$2(RegisteredClientRepository $registeredClientRepository, OAuth2ClientAuthenticationConfigurer clientAuthentication) {
        Intrinsics.checkNotNullParameter((Object)$registeredClientRepository, (String)"$registeredClientRepository");
        clientAuthentication.authenticationConverter((AuthenticationConverter)new MobileClientRefreshTokenAuthenticationConverter()).authenticationProvider((AuthenticationProvider)new MobileClientRefreshTokenAuthenticationProvider($registeredClientRepository));
    }

    private static final void authorizationServerSecurityFilterChain$lambda$3(OAuth2AuthorizationEndpointConfigurer it) {
        it.authorizationResponseHandler((AuthenticationSuccessHandler)new InvalidateSessionAndAddTrustedDeviceAndRedirectHandler());
    }

    private static final void authorizationServerSecurityFilterChain$lambda$4(JustAuthenticationProvider $justAuthenticationProvider, ExposedOauth2AuthorizationService $authorizationService, OAuth2TokenGenerator $justTokenGenerator, OAuth2TokenEndpointConfigurer it) {
        Intrinsics.checkNotNullParameter((Object)$justAuthenticationProvider, (String)"$justAuthenticationProvider");
        Intrinsics.checkNotNullParameter((Object)$authorizationService, (String)"$authorizationService");
        Intrinsics.checkNotNullParameter((Object)$justTokenGenerator, (String)"$justTokenGenerator");
        it.accessTokenRequestConverter((AuthenticationConverter)new OAuth2PasswordGrantAuthenticationConverter()).authenticationProvider((AuthenticationProvider)new OAuth2PasswordGrantAuthenticationProvider($justAuthenticationProvider, (OAuth2AuthorizationService)$authorizationService, $justTokenGenerator));
    }

    private static final void authorizationServerSecurityFilterChain$lambda$5(ExceptionHandlingConfigurer exceptions) {
        Intrinsics.checkNotNullParameter((Object)exceptions, (String)"exceptions");
        MediaType[] mediaTypeArray = new MediaType[]{MediaType.TEXT_HTML};
        exceptions.defaultAuthenticationEntryPointFor((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint("/login"), (RequestMatcher)new MediaTypeRequestMatcher(mediaTypeArray));
    }

    private static final void authorizationServerSecurityFilterChain$lambda$6(OAuth2ResourceServerConfigurer resourceServer) {
        Intrinsics.checkNotNullParameter((Object)resourceServer, (String)"resourceServer");
        resourceServer.jwt(Customizer.withDefaults());
    }

    private static final void authorizationServerSecurityFilterChain$lambda$7(SessionManagementConfigurer it) {
        it.sessionCreationPolicy(SessionCreationPolicy.NEVER);
    }

    private static final void defaultSecurityFilterChain$lambda$8(SecurityConfig this$0, AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String[] stringArray = UNAUTHORIZED_PATHS;
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(Arrays.copyOf(stringArray, stringArray.length))).permitAll();
        stringArray = new String[]{"/totp"};
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.requestMatchers(stringArray)).access(this$0.mfaAuthorizationManager());
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)it.anyRequest()).authenticated();
    }

    private static final void defaultSecurityFilterChain$lambda$9(FeatureToggleService $featureToggleService, String $systemDomainPrefix, TOTPAuthenticationService $totpAuthenticationService, FormLoginConfigurer formLogin) {
        Intrinsics.checkNotNullParameter((Object)$featureToggleService, (String)"$featureToggleService");
        Intrinsics.checkNotNullParameter((Object)$systemDomainPrefix, (String)"$systemDomainPrefix");
        Intrinsics.checkNotNullParameter((Object)$totpAuthenticationService, (String)"$totpAuthenticationService");
        ((FormLoginConfigurer)formLogin.loginPage("/login").permitAll()).successHandler((AuthenticationSuccessHandler)new TOTPAuthenticationSuccessHandler($featureToggleService, $systemDomainPrefix, $totpAuthenticationService));
    }

    private static final void defaultSecurityFilterChain$lambda$10(CsrfConfigurer csrf) {
        String[] stringArray = UNAUTHORIZED_PATHS;
        csrf.ignoringRequestMatchers(Arrays.copyOf(stringArray, stringArray.length));
    }

    private static final void defaultSecurityFilterChain$lambda$11(SessionManagementConfigurer session) {
        session.sessionCreationPolicy(SessionCreationPolicy.IF_REQUIRED);
    }

    private static final void defaultSecurityFilterChain$lambda$12(RememberMeServices $rememberMeServices, RememberMeConfigurer remember) {
        Intrinsics.checkNotNullParameter((Object)$rememberMeServices, (String)"$rememberMeServices");
        remember.rememberMeServices($rememberMeServices).tokenValiditySeconds(2592000).useSecureCookie(true).authenticationSuccessHandler((AuthenticationSuccessHandler)new SavedRequestAwareAuthenticationSuccessHandler());
    }

    private static final AuthorizationDecision mfaAuthorizationManager$lambda$13(Supplier authentication, RequestAuthorizationContext context) {
        return new AuthorizationDecision(authentication.get() instanceof TOTPAuthentication);
    }

    private static final void justTokenGenerator$lambda$14(JwtEncodingContext it) {
        Object principal = ((AbstractAuthenticationToken)it.getPrincipal()).getPrincipal();
        if (principal instanceof JustUser) {
            if (((JustUser)principal).getTenantId() != null) {
                it.getClaims().claim(TenantId.Companion.getJsonKey(), (Object)((JustUser)principal).getTenantId().toTypedString());
            }
            it.getClaims().claim(ProfileId.Companion.getJsonKey(), (Object)((JustUser)principal).getProfileId().toTypedString());
        }
    }

    private static final void justTokenGenerator$lambda$15(OAuth2TokenClaimsContext it) {
        Object principal = ((AbstractAuthenticationToken)it.getPrincipal()).getPrincipal();
        if (principal instanceof JustUser) {
            if (((JustUser)principal).getTenantId() != null) {
                it.getClaims().claim(TenantId.Companion.getJsonKey(), (Object)((JustUser)principal).getTenantId().toTypedString());
            }
            it.getClaims().claim(ProfileId.Companion.getJsonKey(), (Object)((JustUser)principal).getProfileId().toTypedString());
        } else if (principal instanceof String) {
            RegisteredClient client;
            RegisteredClient registeredClient = client = (RegisteredClient)it.get(RegisteredClient.class);
            if ((registeredClient != null ? ExposedRegisteredClientRepositoryKt.tenantId((RegisteredClient)registeredClient) : null) != null) {
                TenantId tenantId = ExposedRegisteredClientRepositoryKt.tenantId((RegisteredClient)client);
                it.getClaims().claim(TenantId.Companion.getJsonKey(), (Object)(tenantId != null ? tenantId.toTypedString() : null));
            }
        }
    }

    private static final Unit registeredClientRepository$lambda$16(ExposedRegisteredClientRepository $repository, JustOauthClients $justAuthClients, Transaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$repository, (String)"$repository");
        Intrinsics.checkNotNullParameter((Object)$justAuthClients, (String)"$justAuthClients");
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        RegisteredClient registeredClient = $repository.findByClientId("just-login-mobile");
        $repository.save($justAuthClients.toroMobileLoginClient(registeredClient != null ? registeredClient.getId() : null));
        RegisteredClient registeredClient2 = $repository.findByClientId("just-login");
        $repository.save($justAuthClients.toroJustLoginClient(registeredClient2 != null ? registeredClient2.getId() : null));
        RegisteredClient registeredClient3 = $repository.findByClientId($justAuthClients.getIntrospectionClientId());
        $repository.save($justAuthClients.gatewayIntrospectionClient(registeredClient3 != null ? registeredClient3.getId() : null));
        RegisteredClient registeredClient4 = $repository.findByClientId("swagger");
        $repository.save($justAuthClients.swaggerClient(registeredClient4 != null ? registeredClient4.getId() : null));
        return Unit.INSTANCE;
    }

    static {
        String[] stringArray = new String[]{"/oauth2/token/**", "/internal/**", "/error", "/images/**"};
        UNAUTHORIZED_PATHS = stringArray;
    }
}

