/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.republish;

import de.justsoftware.admin.domain.appsettings.AppSettingsPermissionService;
import de.justsoftware.admin.domain.appsettings.AppSettingsService;
import de.justsoftware.admin.domain.appsettings.model.AppPermission;
import de.justsoftware.admin.domain.deletedtenant.DeletedTenantService;
import de.justsoftware.admin.domain.deletedtenant.model.DeletedTenant;
import de.justsoftware.admin.domain.tenant.IdpConfigService;
import de.justsoftware.admin.domain.tenant.TenantInvitationService;
import de.justsoftware.admin.domain.tenant.TenantPermissionService;
import de.justsoftware.admin.domain.tenant.TenantService;
import de.justsoftware.admin.domain.tenant.TrackingSettingsService;
import de.justsoftware.admin.domain.tenant.model.IdentityProviderConfig;
import de.justsoftware.admin.domain.tenant.model.Tenant;
import de.justsoftware.admin.domain.tenant.model.TenantInvitation;
import de.justsoftware.admin.domain.tenant.model.TenantPermission;
import de.justsoftware.admin.domain.user.UserService;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.kafka.publisher.Publisher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0012J\u0016\u0010\u001d\u001a\u00020\u00192\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lde/justsoftware/admin/domain/republish/RepublishService;", "", "appSettingsService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsService;", "appSettingsPermissionService", "Lde/justsoftware/admin/domain/appsettings/AppSettingsPermissionService;", "publisher", "Lde/justsoftware/admin/kafka/publisher/Publisher;", "deletedTenantService", "Lde/justsoftware/admin/domain/deletedtenant/DeletedTenantService;", "idpConfigService", "Lde/justsoftware/admin/domain/tenant/IdpConfigService;", "tenantInvitationService", "Lde/justsoftware/admin/domain/tenant/TenantInvitationService;", "tenantPermissionService", "Lde/justsoftware/admin/domain/tenant/TenantPermissionService;", "tenantService", "Lde/justsoftware/admin/domain/tenant/TenantService;", "userService", "Lde/justsoftware/admin/domain/user/UserService;", "trackingSettingsService", "Lde/justsoftware/admin/domain/tenant/TrackingSettingsService;", "<init>", "(Lde/justsoftware/admin/domain/appsettings/AppSettingsService;Lde/justsoftware/admin/domain/appsettings/AppSettingsPermissionService;Lde/justsoftware/admin/kafka/publisher/Publisher;Lde/justsoftware/admin/domain/deletedtenant/DeletedTenantService;Lde/justsoftware/admin/domain/tenant/IdpConfigService;Lde/justsoftware/admin/domain/tenant/TenantInvitationService;Lde/justsoftware/admin/domain/tenant/TenantPermissionService;Lde/justsoftware/admin/domain/tenant/TenantService;Lde/justsoftware/admin/domain/user/UserService;Lde/justsoftware/admin/domain/tenant/TrackingSettingsService;)V", "republishAllAppConfigs", "", "republishAllIdpConfigs", "republishAllTenants", "republishDeletedTenants", "republishTenantData", "allTenants", "", "Lde/justsoftware/admin/domain/tenant/model/Tenant;", "admin-service"})
@SourceDebugExtension(value={"SMAP\nRepublishService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepublishService.kt\nde/justsoftware/admin/domain/republish/RepublishService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1863#2,2:100\n1557#2:102\n1628#2,3:103\n1863#2,2:106\n1863#2,2:108\n1557#2:110\n1628#2,3:111\n1863#2,2:114\n*S KotlinDebug\n*F\n+ 1 RepublishService.kt\nde/justsoftware/admin/domain/republish/RepublishService\n*L\n31#1:100,2\n53#1:102\n53#1:103,3\n78#1:106,2\n87#1:108,2\n96#1:110\n96#1:111,3\n45#1:114,2\n*E\n"})
public class RepublishService {
    @NotNull
    private final AppSettingsService appSettingsService;
    @NotNull
    private final AppSettingsPermissionService appSettingsPermissionService;
    @NotNull
    private final Publisher publisher;
    @NotNull
    private final DeletedTenantService deletedTenantService;
    @NotNull
    private final IdpConfigService idpConfigService;
    @NotNull
    private final TenantInvitationService tenantInvitationService;
    @NotNull
    private final TenantPermissionService tenantPermissionService;
    @NotNull
    private final TenantService tenantService;
    @NotNull
    private final UserService userService;
    @NotNull
    private final TrackingSettingsService trackingSettingsService;

    public RepublishService(@NotNull AppSettingsService appSettingsService, @NotNull AppSettingsPermissionService appSettingsPermissionService, @NotNull Publisher publisher, @NotNull DeletedTenantService deletedTenantService, @NotNull IdpConfigService idpConfigService, @NotNull TenantInvitationService tenantInvitationService, @NotNull TenantPermissionService tenantPermissionService, @NotNull TenantService tenantService, @NotNull UserService userService, @NotNull TrackingSettingsService trackingSettingsService) {
        Intrinsics.checkNotNullParameter((Object)appSettingsService, (String)"appSettingsService");
        Intrinsics.checkNotNullParameter((Object)appSettingsPermissionService, (String)"appSettingsPermissionService");
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)deletedTenantService, (String)"deletedTenantService");
        Intrinsics.checkNotNullParameter((Object)idpConfigService, (String)"idpConfigService");
        Intrinsics.checkNotNullParameter((Object)tenantInvitationService, (String)"tenantInvitationService");
        Intrinsics.checkNotNullParameter((Object)tenantPermissionService, (String)"tenantPermissionService");
        Intrinsics.checkNotNullParameter((Object)tenantService, (String)"tenantService");
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        Intrinsics.checkNotNullParameter((Object)trackingSettingsService, (String)"trackingSettingsService");
        this.appSettingsService = appSettingsService;
        this.appSettingsPermissionService = appSettingsPermissionService;
        this.publisher = publisher;
        this.deletedTenantService = deletedTenantService;
        this.idpConfigService = idpConfigService;
        this.tenantInvitationService = tenantInvitationService;
        this.tenantPermissionService = tenantPermissionService;
        this.tenantService = tenantService;
        this.userService = userService;
        this.trackingSettingsService = trackingSettingsService;
    }

    public void republishAllAppConfigs() {
        Iterable $this$forEach$iv = this.tenantService.getTenantIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TenantId it = (TenantId)element$iv;
            boolean bl = false;
            Map appsWithPlacements = this.appSettingsService.getAppsWithPlacements(it);
            this.publisher.republishApps(it, appsWithPlacements);
        }
    }

    public void republishAllIdpConfigs() {
        Set allIdpConfigs = this.idpConfigService.getAll();
        this.publisher.republishOAuthClients(() -> RepublishService.republishAllIdpConfigs$lambda$2(allIdpConfigs, this));
    }

    /*
     * WARNING - void declaration
     */
    public void republishAllTenants() {
        void $this$mapTo$iv$iv;
        List allTenants = this.tenantService.getTenants();
        Iterable $this$map$iv = allTenants;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tenant tenant = (Tenant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List allTenantIds = (List)destination$iv$iv;
        this.republishTenantData((Collection)allTenants);
        this.republishDeletedTenants();
        this.publisher.republishTenantPermissions((Collection)allTenantIds, (Collection)this.userService.getAllUserGroups(), () -> RepublishService.republishAllTenants$lambda$5(this));
        this.publisher.republishCoreAppIdsToPermission((Collection)allTenantIds);
        this.publisher.republishAppPermissions(() -> RepublishService.republishAllTenants$lambda$7(this));
        this.republishAllAppConfigs();
        this.republishAllIdpConfigs();
    }

    private void republishDeletedTenants() {
        Set deletedTenants = this.deletedTenantService.getAll();
        Iterable $this$forEach$iv = deletedTenants;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeletedTenant it = (DeletedTenant)element$iv;
            boolean bl = false;
            Publisher.publishDeletedTenant$default((Publisher)this.publisher, (TenantId)it.getTenantId(), null, null, (int)6, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void republishTenantData(Collection<Tenant> allTenants) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$forEach$iv = CollectionsKt.toSet((Iterable)allTenants);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tenant it = (Tenant)element$iv;
            boolean bl = false;
            this.publisher.publishExistingTenant(it, this.tenantService.getSettings(it.getId()), (TenantInvitation)CollectionsKt.firstOrNull((List)this.tenantInvitationService.getTenantInvitations(it.getId())), this.trackingSettingsService.findTrackingByTenantId(it.getId()));
        }
        $this$forEach$iv = allTenants;
        Publisher publisher = this.publisher;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tenant tenant = (Tenant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        publisher.republishTenantIdsToPermission((Collection)((List)destination$iv$iv));
    }

    private static final void republishAllIdpConfigs$lambda$2(Set $allIdpConfigs, RepublishService this$0) {
        Iterable $this$forEach$iv = $allIdpConfigs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IdentityProviderConfig it = (IdentityProviderConfig)element$iv;
            boolean bl = false;
            this$0.publisher.publishOAuthClientChange(it);
        }
    }

    private static final Unit republishAllTenants$lambda$5$lambda$4(RepublishService this$0, TenantPermission it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.publisher.publishTenantPermission(it);
        return Unit.INSTANCE;
    }

    private static final Unit republishAllTenants$lambda$5(RepublishService this$0) {
        this$0.tenantPermissionService.forEachPermission(arg_0 -> RepublishService.republishAllTenants$lambda$5$lambda$4(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit republishAllTenants$lambda$7$lambda$6(RepublishService this$0, AppPermission it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.publisher.publishAppPermission(it);
        return Unit.INSTANCE;
    }

    private static final Unit republishAllTenants$lambda$7(RepublishService this$0) {
        this$0.appSettingsPermissionService.forEachPermission(arg_0 -> RepublishService.republishAllTenants$lambda$7$lambda$6(this$0, arg_0));
        return Unit.INSTANCE;
    }
}

