/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.connector.news;

import com.netflix.graphql.dgs.client.GraphQLResponse;
import com.netflix.graphql.dgs.client.MonoGraphQLClient;
import com.netflix.graphql.dgs.client.codegen.InputValueSerializer;
import de.justsoftware.admin.connector.news.NewsChannels;
import de.justsoftware.admin.graphql.generated.types.NewsAppSettings;
import de.justsoftware.admin.graphql.generated.types.NewsAppSettingsInput;
import de.justsoftware.admin.graphql.generated.types.NewsChannel;
import de.justsoftware.admin.graphql.generated.types.NewsCover;
import de.justsoftware.admin.graphql.generated.types.NewsCoverInput;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\tH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\f\u001a\u00020\u0011H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/admin/connector/news/NewsAppConnector;", "", "newsAppGraphQlClient", "Lcom/netflix/graphql/dgs/client/MonoGraphQLClient;", "<init>", "(Lcom/netflix/graphql/dgs/client/MonoGraphQLClient;)V", "inputSerializer", "Lcom/netflix/graphql/dgs/client/codegen/InputValueSerializer;", "getSettings", "Lreactor/core/publisher/Mono;", "Lde/justsoftware/admin/graphql/generated/types/NewsAppSettings;", "editSettings", "input", "Lde/justsoftware/admin/graphql/generated/types/NewsAppSettingsInput;", "getNewsCover", "Lde/justsoftware/admin/graphql/generated/types/NewsCover;", "editNewsCover", "Lde/justsoftware/admin/graphql/generated/types/NewsCoverInput;", "getChannels", "", "Lde/justsoftware/admin/graphql/generated/types/NewsChannel;", "admin-service"})
public class NewsAppConnector {
    @NotNull
    private final MonoGraphQLClient newsAppGraphQlClient;
    @NotNull
    private final InputValueSerializer inputSerializer;

    public NewsAppConnector(@NotNull MonoGraphQLClient newsAppGraphQlClient) {
        Intrinsics.checkNotNullParameter((Object)newsAppGraphQlClient, (String)"newsAppGraphQlClient");
        this.newsAppGraphQlClient = newsAppGraphQlClient;
        this.inputSerializer = new InputValueSerializer(null, 1, null);
    }

    @NotNull
    public Mono<NewsAppSettings> getSettings() {
        String request = "query {\n    settings {\n        id\n        allMayReadSubscriptionProfiles\n        allowAdditionalInfoInMailNotification\n    }\n}";
        Mono mono = this.newsAppGraphQlClient.reactiveExecuteQuery(request).map(arg_0 -> NewsAppConnector.getSettings$lambda$1(NewsAppConnector::getSettings$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public Mono<NewsAppSettings> editSettings(@NotNull NewsAppSettingsInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String request = StringsKt.trimIndent((String)("\n            mutation {\n                updateSettings(input: " + this.inputSerializer.serialize((Object)input) + ") {\n                    id\n                    allMayReadSubscriptionProfiles\n                    allowAdditionalInfoInMailNotification\n                }\n            }\n        "));
        Mono mono = this.newsAppGraphQlClient.reactiveExecuteQuery(request).map(arg_0 -> NewsAppConnector.editSettings$lambda$3(NewsAppConnector::editSettings$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public Mono<NewsCover> getNewsCover() {
        String request = "query {\n    newsCover {\n        id\n        openOnStart\n        cycleDelay\n        sections {\n            id\n            title\n            pinnedOnly\n            position\n            channelIds\n            channels {\n                id\n                title\n            }\n        }\n    }\n}";
        Mono mono = this.newsAppGraphQlClient.reactiveExecuteQuery(request).map(arg_0 -> NewsAppConnector.getNewsCover$lambda$5(NewsAppConnector::getNewsCover$lambda$4, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public Mono<NewsCover> editNewsCover(@NotNull NewsCoverInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String request = StringsKt.trimIndent((String)("\n            mutation {\n                updateNewsCover(input: " + this.inputSerializer.serialize((Object)input) + ") {\n                   id\n                    openOnStart\n                    cycleDelay\n                    sections {\n                        id\n                        title\n                        pinnedOnly\n                        position\n                        channelIds\n                        channels {\n                            id\n                            title\n                        }\n                    }\n                }\n            }\n        "));
        Mono mono = this.newsAppGraphQlClient.reactiveExecuteQuery(request).map(arg_0 -> NewsAppConnector.editNewsCover$lambda$7(NewsAppConnector::editNewsCover$lambda$6, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    @NotNull
    public Mono<List<NewsChannel>> getChannels() {
        String request = "query {\n    channels {\n        id\n        title\n    }\n}";
        Mono mono = this.newsAppGraphQlClient.reactiveExecuteQuery(request).map(arg_0 -> NewsAppConnector.getChannels$lambda$9(NewsAppConnector::getChannels$lambda$8, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"map(...)");
        return mono;
    }

    private static final NewsAppSettings getSettings$lambda$0(GraphQLResponse r) {
        return (NewsAppSettings)r.extractValueAsObject("data.settings", NewsAppSettings.class);
    }

    private static final NewsAppSettings getSettings$lambda$1(Function1 $tmp0, Object p0) {
        return (NewsAppSettings)$tmp0.invoke(p0);
    }

    private static final NewsAppSettings editSettings$lambda$2(GraphQLResponse r) {
        return (NewsAppSettings)r.extractValueAsObject("data.updateSettings", NewsAppSettings.class);
    }

    private static final NewsAppSettings editSettings$lambda$3(Function1 $tmp0, Object p0) {
        return (NewsAppSettings)$tmp0.invoke(p0);
    }

    private static final NewsCover getNewsCover$lambda$4(GraphQLResponse r) {
        return (NewsCover)r.extractValueAsObject("data.newsCover", NewsCover.class);
    }

    private static final NewsCover getNewsCover$lambda$5(Function1 $tmp0, Object p0) {
        return (NewsCover)$tmp0.invoke(p0);
    }

    private static final NewsCover editNewsCover$lambda$6(GraphQLResponse r) {
        return (NewsCover)r.extractValueAsObject("data.updateNewsCover", NewsCover.class);
    }

    private static final NewsCover editNewsCover$lambda$7(Function1 $tmp0, Object p0) {
        return (NewsCover)$tmp0.invoke(p0);
    }

    private static final List getChannels$lambda$8(GraphQLResponse r) {
        return (List)r.extractValueAsObject("data.channels", NewsChannels.class);
    }

    private static final List getChannels$lambda$9(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

