/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.QueryTimeout;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.CpuAllowedLimit;
import org.apache.solr.search.QueryLimitsExceededException;
import org.apache.solr.search.TimeAllowedLimit;
import org.apache.solr.util.TestInjection;

public class QueryLimits
implements QueryTimeout {
    private final List<QueryTimeout> limits = new ArrayList<QueryTimeout>(3);
    public static QueryLimits NONE = new QueryLimits();
    private final SolrQueryResponse rsp;
    private final boolean allowPartialResults;
    private volatile boolean limitsTripped = false;

    private QueryLimits() {
        this(null, null);
    }

    public QueryLimits(SolrQueryRequest req, SolrQueryResponse rsp) {
        this.rsp = rsp;
        boolean bl = this.allowPartialResults = req != null ? req.getParams().getBool("partialResults", true) : true;
        if (req != null) {
            if (TimeAllowedLimit.hasTimeLimit(req)) {
                this.limits.add(new TimeAllowedLimit(req));
            }
            if (CpuAllowedLimit.hasCpuLimit(req)) {
                this.limits.add(new CpuAllowedLimit(req));
            }
        }
        if (TestInjection.queryTimeout != null) {
            this.limits.add(TestInjection.queryTimeout);
        }
    }

    public boolean shouldExit() {
        if (this.limitsTripped) {
            return true;
        }
        for (QueryTimeout limit : this.limits) {
            if (!limit.shouldExit()) continue;
            this.limitsTripped = true;
            break;
        }
        return this.limitsTripped;
    }

    public String formatExceptionMessage(String label) {
        return "Limits exceeded!" + (String)(label != null ? " (" + label + ")" : "") + ": " + this.limitStatusMessage();
    }

    public boolean maybeExitWithPartialResults(String label) throws QueryLimitsExceededException {
        if (this.isLimitsEnabled() && this.shouldExit()) {
            if (this.allowPartialResults) {
                if (this.rsp != null) {
                    this.rsp.setPartialResults();
                    this.rsp.addPartialResponseDetail(this.formatExceptionMessage(label));
                }
                return true;
            }
            throw new QueryLimitsExceededException(this.formatExceptionMessage(label));
        }
        return false;
    }

    public String limitStatusMessage() {
        if (this.limits.isEmpty()) {
            return "This request is unlimited.";
        }
        StringBuilder sb = new StringBuilder("Query limits: ");
        for (QueryTimeout limit : this.limits) {
            sb.append("[");
            sb.append(limit.getClass().getSimpleName());
            sb.append(":");
            sb.append(limit.shouldExit() ? "LIMIT EXCEEDED" : "within limit");
            sb.append("]");
        }
        return sb.toString();
    }

    public boolean isLimitsEnabled() {
        return !this.limits.isEmpty();
    }

    public static QueryLimits getCurrentLimits() {
        SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
        return info != null ? info.getLimits() : NONE;
    }
}

