/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.mobile.service;

import de.justsoftware.notificationservice.authorization.AuthorizationContext;
import de.justsoftware.notificationservice.mobile.model.MobilePlatform;
import de.justsoftware.notificationservice.mobile.model.MobilePushToken;
import de.justsoftware.notificationservice.mobile.persistence.MobilePushTokenRepository;
import de.justsoftware.notificationservice.mobile.persistence.model.DbMobilePushToken;
import de.justsoftware.notificationservice.model.Profile;
import de.justsoftware.notificationservice.model.TenantId;
import de.justsoftware.notificationservice.model.event.ProfileUpdateEvent;
import de.justsoftware.notificationservice.persistence.model.ProfileId;
import de.justsoftware.notificationservice.util.CollectionUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.event.EventListener;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J>\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0016\u0010\u001b\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0017JL\u0010&\u001a\u00020'2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020\u0013H\u0012J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020'0.2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0012J\f\u0010/\u001a\u000200*\u00020\u001eH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lde/justsoftware/notificationservice/mobile/service/MobilePushTokenService;", "", "mobilePushTokenRepository", "Lde/justsoftware/notificationservice/mobile/persistence/MobilePushTokenRepository;", "auditingHandler", "Lorg/springframework/data/auditing/AuditingHandler;", "<init>", "(Lde/justsoftware/notificationservice/mobile/persistence/MobilePushTokenRepository;Lorg/springframework/data/auditing/AuditingHandler;)V", "registerPushToken", "Lde/justsoftware/notificationservice/mobile/model/MobilePushToken;", "token", "", "mobilePlatform", "Lde/justsoftware/notificationservice/mobile/model/MobilePlatform;", "mobilePlatformVersion", "publicKey", "authContext", "Lde/justsoftware/notificationservice/authorization/AuthorizationContext;", "iosSilenceAlerts", "", "unregisterPushToken", "", "findByProfileIds", "", "profileIds", "", "Lde/justsoftware/notificationservice/persistence/model/ProfileId;", "deletePushTokens", "ids", "", "Lde/justsoftware/notificationservice/mobile/model/MobilePushToken$Id;", "findAll", "Lorg/springframework/data/domain/Slice;", "pageable", "Lorg/springframework/data/domain/Pageable;", "onProfileUpdates", "event", "Lde/justsoftware/notificationservice/model/event/ProfileUpdateEvent;", "findOrCreate", "Lde/justsoftware/notificationservice/mobile/persistence/model/DbMobilePushToken;", "profileId", "tenantId", "Lde/justsoftware/notificationservice/model/TenantId;", "locale", "Ljava/util/Locale;", "findByTokenAndPlatform", "Ljava/util/Optional;", "toDbId", "Lde/justsoftware/notificationservice/mobile/persistence/model/DbMobilePushToken$Id;", "notification-service"})
@SourceDebugExtension(value={"SMAP\nMobilePushTokenService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobilePushTokenService.kt\nde/justsoftware/notificationservice/mobile/service/MobilePushTokenService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 CollectionUtil.kt\nde/justsoftware/notificationservice/util/CollectionUtilKt\n*L\n1#1,131:1\n1#2:132\n1563#3:133\n1634#3,3:134\n1563#3:137\n1634#3,3:138\n1634#3,3:142\n17#4:141\n*S KotlinDebug\n*F\n+ 1 MobilePushTokenService.kt\nde/justsoftware/notificationservice/mobile/service/MobilePushTokenService\n*L\n67#1:133\n67#1:134,3\n68#1:137\n68#1:138,3\n73#1:142,3\n73#1:141\n*E\n"})
public class MobilePushTokenService {
    @NotNull
    private final MobilePushTokenRepository mobilePushTokenRepository;
    @NotNull
    private final AuditingHandler auditingHandler;

    public MobilePushTokenService(@NotNull MobilePushTokenRepository mobilePushTokenRepository, @NotNull AuditingHandler auditingHandler) {
        Intrinsics.checkNotNullParameter((Object)mobilePushTokenRepository, (String)"mobilePushTokenRepository");
        Intrinsics.checkNotNullParameter((Object)auditingHandler, (String)"auditingHandler");
        this.mobilePushTokenRepository = mobilePushTokenRepository;
        this.auditingHandler = auditingHandler;
    }

    @NotNull
    public MobilePushToken registerPushToken(@NotNull String token, @NotNull MobilePlatform mobilePlatform, @Nullable String mobilePlatformVersion, @Nullable String publicKey, @NotNull AuthorizationContext authContext, boolean iosSilenceAlerts) {
        Locale p0;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)mobilePlatform, (String)"mobilePlatform");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (StringsKt.isBlank((CharSequence)token)) {
            throw new IllegalArgumentException("Token is blank");
        }
        Locale locale = authContext.getLocale();
        ProfileId profileId = authContext.getProfileId();
        Object object = authContext.getTenantId();
        locale = this.findOrCreate(token, mobilePlatform, mobilePlatformVersion, publicKey, profileId, object, locale, iosSilenceAlerts);
        profileId = this.auditingHandler;
        object = locale;
        DbMobilePushToken.Companion companion = DbMobilePushToken.Companion;
        boolean bl = false;
        locale = (DbMobilePushToken)profileId.markModified((Object)p0);
        profileId = this.mobilePushTokenRepository;
        p0 = locale;
        boolean bl2 = false;
        DbMobilePushToken dbMobilePushToken = (DbMobilePushToken)profileId.save((Object)p0);
        Intrinsics.checkNotNullExpressionValue((Object)dbMobilePushToken, (String)"let(...)");
        return companion.toMobilePushToken(dbMobilePushToken);
    }

    public static /* synthetic */ MobilePushToken registerPushToken$default(MobilePushTokenService mobilePushTokenService, String string, MobilePlatform mobilePlatform, String string2, String string3, AuthorizationContext authorizationContext, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerPushToken");
        }
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return mobilePushTokenService.registerPushToken(string, mobilePlatform, string2, string3, authorizationContext, bl);
    }

    public void unregisterPushToken(@NotNull String token, @NotNull MobilePlatform mobilePlatform, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)mobilePlatform, (String)"mobilePlatform");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (StringsKt.isBlank((CharSequence)token)) {
            throw new IllegalArgumentException("Token is blank");
        }
        this.findByTokenAndPlatform(token, mobilePlatform).filter(arg_0 -> MobilePushTokenService.unregisterPushToken$lambda$2(arg_0 -> MobilePushTokenService.unregisterPushToken$lambda$1(authContext, arg_0), arg_0)).ifPresent(arg_0 -> MobilePushTokenService.unregisterPushToken$lambda$3((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<MobilePushToken> findByProfileIds(@NotNull Iterable<? extends ProfileId> profileIds) {
        DbMobilePushToken p0;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable<? extends ProfileId> iterable = profileIds;
        Object object = this.mobilePushTokenRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getId());
        }
        $this$map$iv = object.findByProfileIdIn((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (DbMobilePushToken)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(DbMobilePushToken.Companion.toMobilePushToken((DbMobilePushToken)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public void deletePushTokens(@NotNull Collection<MobilePushToken.Id> ids) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (ids.isEmpty()) {
            return;
        }
        Iterable $this$mapToSet$iv = ids;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MobilePushToken.Id id = (MobilePushToken.Id)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toDbId((MobilePushToken.Id)it));
        }
        Set set = (Set)destination$iv$iv;
        MobilePushTokenRepository mobilePushTokenRepository = this.mobilePushTokenRepository;
        Iterable p0 = set;
        boolean bl = false;
        mobilePushTokenRepository.deleteAllById(p0);
    }

    @NotNull
    public Slice<MobilePushToken> findAll(@NotNull Pageable pageable) {
        Intrinsics.checkNotNullParameter((Object)pageable, (String)"pageable");
        Slice slice = this.mobilePushTokenRepository.findAllBy(pageable).map(arg_0 -> MobilePushTokenService.findAll$lambda$9(MobilePushTokenService::findAll$lambda$8, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)slice, (String)"map(...)");
        return slice;
    }

    @EventListener
    @Transactional
    public void onProfileUpdates(@NotNull ProfileUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Profile profile = event.getProfile();
        if (profile.getStatus() != Profile.Status.ACTIVE) {
            this.mobilePushTokenRepository.deleteByProfileId(profile.getId().getId());
        }
    }

    private DbMobilePushToken findOrCreate(String token, MobilePlatform mobilePlatform, String mobilePlatformVersion, String publicKey, ProfileId profileId, TenantId tenantId, Locale locale, boolean iosSilenceAlerts) {
        DbMobilePushToken dbMobilePushToken = this.findByTokenAndPlatform(token, mobilePlatform).map(arg_0 -> MobilePushTokenService.findOrCreate$lambda$12(arg_0 -> MobilePushTokenService.findOrCreate$lambda$11(mobilePlatformVersion, publicKey, profileId, tenantId, locale, iosSilenceAlerts, arg_0), arg_0)).orElseGet(() -> MobilePushTokenService.findOrCreate$lambda$13(token, mobilePlatform, mobilePlatformVersion, publicKey, profileId, tenantId, locale, iosSilenceAlerts));
        Intrinsics.checkNotNullExpressionValue((Object)dbMobilePushToken, (String)"orElseGet(...)");
        return dbMobilePushToken;
    }

    private Optional<DbMobilePushToken> findByTokenAndPlatform(String token, MobilePlatform mobilePlatform) {
        Optional optional = this.mobilePushTokenRepository.findById((Object)new DbMobilePushToken.Id(token, mobilePlatform));
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findById(...)");
        return optional;
    }

    private DbMobilePushToken.Id toDbId(MobilePushToken.Id $this$toDbId) {
        return new DbMobilePushToken.Id($this$toDbId.getToken(), $this$toDbId.getMobilePlatform());
    }

    private static final boolean unregisterPushToken$lambda$1(AuthorizationContext $authContext, DbMobilePushToken it) {
        return it.getProfileId() == $authContext.getProfileId().getId();
    }

    private static final boolean unregisterPushToken$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void unregisterPushToken$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final MobilePushToken findAll$lambda$8(DbMobilePushToken it) {
        Intrinsics.checkNotNull((Object)it);
        return DbMobilePushToken.Companion.toMobilePushToken(it);
    }

    private static final MobilePushToken findAll$lambda$9(Function1 $tmp0, Object p0) {
        return (MobilePushToken)$tmp0.invoke(p0);
    }

    private static final DbMobilePushToken findOrCreate$lambda$11(String $mobilePlatformVersion, String $publicKey, ProfileId $profileId, TenantId $tenantId, Locale $locale, boolean $iosSilenceAlerts, DbMobilePushToken it) {
        DbMobilePushToken dbMobilePushToken;
        DbMobilePushToken $this$findOrCreate_u24lambda_u2411_u24lambda_u2410 = dbMobilePushToken = it;
        boolean bl = false;
        $this$findOrCreate_u24lambda_u2411_u24lambda_u2410.setMobilePlatformVersion($mobilePlatformVersion);
        String string = $publicKey;
        if (string == null) {
            string = $this$findOrCreate_u24lambda_u2411_u24lambda_u2410.getPublicKey();
        }
        $this$findOrCreate_u24lambda_u2411_u24lambda_u2410.setPublicKey(string);
        $this$findOrCreate_u24lambda_u2411_u24lambda_u2410.setProfileId($profileId.getId());
        $this$findOrCreate_u24lambda_u2411_u24lambda_u2410.setTenantId($tenantId.getValue());
        $this$findOrCreate_u24lambda_u2411_u24lambda_u2410.setLocale($locale);
        $this$findOrCreate_u24lambda_u2411_u24lambda_u2410.setIosSilenceAlerts($iosSilenceAlerts);
        return dbMobilePushToken;
    }

    private static final DbMobilePushToken findOrCreate$lambda$12(Function1 $tmp0, Object p0) {
        return (DbMobilePushToken)$tmp0.invoke(p0);
    }

    private static final DbMobilePushToken findOrCreate$lambda$13(String $token, MobilePlatform $mobilePlatform, String $mobilePlatformVersion, String $publicKey, ProfileId $profileId, TenantId $tenantId, Locale $locale, boolean $iosSilenceAlerts) {
        return new DbMobilePushToken($token, $mobilePlatform, $mobilePlatformVersion, $publicKey, $profileId.getId(), $tenantId.getValue(), $locale, $iosSilenceAlerts);
    }
}

