/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.kafka;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.admin.NewTopic;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.core.KafkaAdmin;

@Profile(value={"!test"})
@Configuration
@ParametersAreNonnullByDefault
public class KafkaTopicConfiguration {
    private static final String SEVEN_DAYS_IN_MS = "604800000";

    @Nonnull
    @Bean
    public KafkaAdmin admin(@Value(value="${kafka.bootstrapServers}") String bootstrapServer) {
        ImmutableMap configs = ImmutableMap.of((Object)"bootstrap.servers", (Object)bootstrapServer);
        KafkaAdmin kafkaAdmin = new KafkaAdmin((Map)configs);
        kafkaAdmin.setFatalIfBrokerNotAvailable(true);
        return kafkaAdmin;
    }

    @Bean
    @Nonnull
    public NewTopic notificationDispatchTopic() {
        NewTopic topic = new NewTopic("just.notification.dispatch", 5, 1);
        topic.configs((Map)ImmutableMap.of((Object)"delete.retention.ms", (Object)SEVEN_DAYS_IN_MS, (Object)"segment.ms", (Object)SEVEN_DAYS_IN_MS, (Object)"cleanup.policy", (Object)"delete"));
        return topic;
    }
}

