/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.kafka;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.wikiservice.kafka.model.KafkaTenant;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.common.serialization.Deserializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u0018\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/wikiservice/kafka/KafkaTenantDeserializer;", "Lorg/apache/kafka/common/serialization/Deserializer;", "Lde/justsoftware/wikiservice/kafka/model/KafkaTenant;", "<init>", "()V", "jsonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "deserialize", "topic", "", "data", "", "wiki-service"})
public final class KafkaTenantDeserializer
implements Deserializer<KafkaTenant> {
    @NotNull
    public static final KafkaTenantDeserializer INSTANCE = new KafkaTenantDeserializer();
    private static final ObjectMapper jsonMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    private KafkaTenantDeserializer() {
    }

    @Nullable
    public KafkaTenant deserialize(@NotNull String topic, @Nullable byte[] data) {
        KafkaTenant kafkaTenant;
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        try {
            if (data == null) {
                return null;
            }
            kafkaTenant = (KafkaTenant)jsonMapper.readValue(data, KafkaTenant.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to deserialize data to KafkaTenant", e);
        }
        return kafkaTenant;
    }
}

