/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.model.Profile;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.persistence.ProfileRepository;
import de.justsoftware.wikiservice.persistence.model.DbProfile;
import de.justsoftware.wikiservice.util.CollectionUtilsKt;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/wikiservice/business/ProfileService;", "", "profileRepository", "Lde/justsoftware/wikiservice/persistence/ProfileRepository;", "<init>", "(Lde/justsoftware/wikiservice/persistence/ProfileRepository;)V", "save", "", "profile", "Lde/justsoftware/wikiservice/business/model/Profile;", "readByIds", "", "Lde/justsoftware/wikiservice/model/ProfileId;", "profileIds", "", "findById", "profileId", "getById", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nProfileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileService.kt\nde/justsoftware/wikiservice/business/ProfileService\n+ 2 CollectionUtils.kt\nde/justsoftware/wikiservice/util/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,33:1\n7#2:34\n1628#3,3:35\n1202#3,2:38\n1230#3,4:40\n1246#3,4:46\n462#4:44\n412#4:45\n1#5:50\n*S KotlinDebug\n*F\n+ 1 ProfileService.kt\nde/justsoftware/wikiservice/business/ProfileService\n*L\n23#1:34\n23#1:35,3\n24#1:38,2\n24#1:40,4\n25#1:46,4\n25#1:44\n25#1:45\n*E\n"})
public class ProfileService {
    @NotNull
    private final ProfileRepository profileRepository;

    @Autowired
    public ProfileService(@NotNull ProfileRepository profileRepository) {
        Intrinsics.checkNotNullParameter((Object)profileRepository, (String)"profileRepository");
        this.profileRepository = profileRepository;
    }

    public void save(@NotNull Profile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        this.profileRepository.save((Object)DbProfile.Companion.toDbProfile(profile));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, Profile> readByIds(@NotNull Set<ProfileId> profileIds) {
        void $this$mapValuesTo$iv$iv;
        void $this$associateByTo$iv$iv;
        DbProfile it;
        Collection<Object> collection;
        Iterable $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable iterable = profileIds;
        Object object = this.profileRepository;
        boolean $i$f$mapToSet = false;
        void var5_7 = $this$mapToSet$iv;
        Object destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ProfileId profileId = (ProfileId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List list = object.findAllById((Iterable)((Set)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findAllById(...)");
        Iterable $this$associateBy$iv = list;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        $this$mapTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void profile;
            it = (DbProfile)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(new ProfileId(profile.getId()), element$iv$iv);
        }
        Object $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        Object capacity$iv22 = $this$mapValues$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it2;
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl2 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            collection = it$iv$iv.getKey();
            object = map;
            boolean bl3 = false;
            Object v = it2.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            Profile profile = DbProfile.Companion.toProfile((DbProfile)v);
            object.put(collection, profile);
        }
        return destination$iv$iv2;
    }

    @Nullable
    public Profile findById(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Optional<Profile> optional = this.profileRepository.findById((Object)profileId.getId()).map(arg_0 -> ProfileService.findById$lambda$4(ProfileService::findById$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map(...)");
        return (Profile)OptionalsKt.getOrNull(optional);
    }

    @NotNull
    public Profile getById(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Profile profile = this.findById(profileId);
        if (profile == null) {
            boolean bl = false;
            String string = "Could not load Profile with " + profileId + ". Profile does not exist.";
            throw new IllegalStateException(string.toString());
        }
        return profile;
    }

    private static final Profile findById$lambda$3(DbProfile it) {
        Intrinsics.checkNotNull((Object)it);
        return DbProfile.Companion.toProfile(it);
    }

    private static final Profile findById$lambda$4(Function1 $tmp0, Object p0) {
        return (Profile)$tmp0.invoke(p0);
    }
}

