/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.authorization;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.permission.client.model.AuthorizationResult;
import de.justsoftware.permission.client.model.CoreApp;
import de.justsoftware.permission.client.model.Role;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.authorization.model.PermissionAction;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.exceptions.NotAllowedException;
import de.justsoftware.wikiservice.business.exceptions.NotFoundException;
import de.justsoftware.wikiservice.business.model.Wiki;
import de.justsoftware.wikiservice.model.AbstractId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.TenantId;
import de.justsoftware.wikiservice.model.WikiId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0007\u0018\u0000 22\u00020\u0001:\u00012B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015J\u0014\u0010\u0019\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bJ\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015J\u000e\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0015J\u0006\u0010\u001e\u001a\u00020\u0017J\u0014\u0010\u001f\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bJ\u0014\u0010 \u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bJ\u0014\u0010!\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bJ\u0016\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0015J\u001e\u0010%\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010&\u001a\u00020'H\u0002J+\u0010(\u001a\u00020\u0017\"\b\b\u0000\u0010)*\u00020*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u00020\u00120,H\u0001\u00a2\u0006\u0002\b-J2\u0010.\u001a\u000e\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u00020\u00130,\"\b\b\u0000\u0010)*\u00020*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u00020\u00120,H\u0002J2\u0010/\u001a\u000e\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u00020\u00130,\"\b\b\u0000\u0010)*\u00020*2\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u00020\u00120,H\u0002J!\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bH\u0001\u00a2\u0006\u0002\b1R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00050\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lde/justsoftware/wikiservice/authorization/AuthContext;", "", "user", "Lde/justsoftware/wikiservice/model/ProfileId;", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "authService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "<init>", "(Lde/justsoftware/wikiservice/model/ProfileId;Lde/justsoftware/wikiservice/model/TenantId;Lde/justsoftware/wikiservice/authorization/AuthorizationService;Lde/justsoftware/wikiservice/business/WikiService;)V", "getUser", "()Lde/justsoftware/wikiservice/model/ProfileId;", "getTenantId", "()Lde/justsoftware/wikiservice/model/TenantId;", "roleCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lde/justsoftware/permission/client/model/Role;", "Lde/justsoftware/permission/client/model/AuthorizationResult;", "tenantCache", "Lde/justsoftware/wikiservice/model/WikiId;", "checkReadWiki", "", "wikiId", "checkReadArticleVersionHistory", "wikiIds", "", "checkWriteWiki", "checkManageWiki", "checkCreateWiki", "checkReadWikis", "checkWriteWikis", "checkManageWikis", "checkMoveWikiContent", "fromWiki", "toWiki", "checkWikis", "permissionAction", "Lde/justsoftware/wikiservice/authorization/model/PermissionAction;", "check", "ID", "Lde/justsoftware/wikiservice/model/AbstractId;", "roles", "", "check$wiki_service", "getAuthorizationResults", "getAndCacheRoles", "getTenants", "getTenants$wiki_service", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nAuthContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthContext.kt\nde/justsoftware/wikiservice/authorization/AuthContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 CollectionUtils.kt\nde/justsoftware/wikiservice/util/CollectionUtilsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,191:1\n1279#2,2:192\n1293#2,4:194\n1279#2,2:198\n1293#2,4:200\n1611#2,9:208\n1863#2:217\n1864#2:219\n1620#2:220\n1187#2,2:222\n1261#2,4:224\n1246#2,4:238\n774#2:242\n865#2,2:243\n1279#2,2:245\n1293#2,4:247\n216#3,2:204\n80#4,2:206\n82#4:221\n1#5:218\n1#5:235\n487#6,7:228\n477#6:236\n423#6:237\n*S KotlinDebug\n*F\n+ 1 AuthContext.kt\nde/justsoftware/wikiservice/authorization/AuthContext\n*L\n74#1:192,2\n74#1:194,4\n77#1:198,2\n77#1:200,4\n124#1:208,9\n124#1:217\n124#1:219\n124#1:220\n124#1:222,2\n124#1:224,4\n149#1:238,4\n166#1:242\n166#1:243,2\n176#1:245,2\n176#1:247,4\n88#1:204,2\n124#1:206,2\n124#1:221\n124#1:218\n134#1:228,7\n149#1:236\n149#1:237\n*E\n"})
public final class AuthContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfileId user;
    @NotNull
    private final TenantId tenantId;
    @NotNull
    private final AuthorizationService authService;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final Cache<Role, AuthorizationResult> roleCache;
    @NotNull
    private final Cache<WikiId, TenantId> tenantCache;
    private static final Logger log = LoggerFactory.getLogger(AuthContext.class);

    public AuthContext(@NotNull ProfileId user, @NotNull TenantId tenantId, @NotNull AuthorizationService authService, @NotNull WikiService wikiService) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)authService, (String)"authService");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        this.user = user;
        this.tenantId = tenantId;
        this.authService = authService;
        this.wikiService = wikiService;
        Cache cache = Caffeine.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.roleCache = cache;
        Cache cache2 = Caffeine.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
        this.tenantCache = cache2;
    }

    @NotNull
    public final ProfileId getUser() {
        return this.user;
    }

    @NotNull
    public final TenantId getTenantId() {
        return this.tenantId;
    }

    public final void checkReadWiki(@NotNull WikiId wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        this.checkReadWikis(SetsKt.setOf((Object)wikiId));
    }

    public final void checkReadArticleVersionHistory(@NotNull Set<WikiId> wikiIds) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        for (Map.Entry entry : this.authService.mayReadArticleVersionHistory(wikiIds, this.user, this.tenantId).entrySet()) {
            WikiId wiki = (WikiId)entry.getKey();
            boolean canReadArticleVersionHistory = (Boolean)entry.getValue();
            if (canReadArticleVersionHistory) continue;
            throw new NotAllowedException("Failed permission check on " + wiki);
        }
    }

    public final void checkWriteWiki(@NotNull WikiId wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        this.checkWriteWikis(SetsKt.setOf((Object)wikiId));
    }

    public final void checkManageWiki(@NotNull WikiId wikiId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        this.checkManageWikis(SetsKt.setOf((Object)wikiId));
    }

    public final void checkCreateWiki() {
        this.check$wiki_service(MapsKt.mapOf((Pair)TuplesKt.to((Object)this.tenantId, (Object)Role.writeApp((CoreApp)CoreApp.WIKI, (UUID)this.tenantId.getId()))));
    }

    public final void checkReadWikis(@NotNull Set<WikiId> wikiIds) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        this.checkWikis(wikiIds, PermissionAction.READ);
    }

    public final void checkWriteWikis(@NotNull Set<WikiId> wikiIds) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        this.checkWikis(wikiIds, PermissionAction.WRITE);
    }

    public final void checkManageWikis(@NotNull Set<WikiId> wikiIds) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        this.checkWikis(wikiIds, PermissionAction.MANAGE);
    }

    public final void checkMoveWikiContent(@NotNull WikiId fromWiki, @NotNull WikiId toWiki) {
        Intrinsics.checkNotNullParameter((Object)fromWiki, (String)"fromWiki");
        Intrinsics.checkNotNullParameter((Object)toWiki, (String)"toWiki");
        Object[] objectArray = new WikiId[]{fromWiki, toWiki};
        if (this.getTenants$wiki_service(SetsKt.setOf((Object[])objectArray)).size() > 1) {
            throw new NotAllowedException("Moving articles or chapters between different tenants is not allowed");
        }
        objectArray = new WikiId[]{fromWiki, toWiki};
        this.checkWriteWikis(SetsKt.setOf((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private final void checkWikis(Set<WikiId> wikiIds, PermissionAction permissionAction) {
        void $this$associateWith$iv;
        Role role;
        Map map;
        Object t;
        if (wikiIds.isEmpty()) {
            return;
        }
        Iterable $this$associateWith$iv2 = wikiIds;
        boolean $i$f$associateWith22 = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv2, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv2;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void id;
            WikiId wikiId = (WikiId)element$iv$iv;
            t = element$iv$iv;
            map = result$iv;
            boolean bl = false;
            role = Role.itemRole((String)permissionAction.name(), (String)id.toString());
            map.put(t, role);
        }
        Map actionRoles = result$iv;
        Iterable $i$f$associateWith22 = this.getTenants$wiki_service(wikiIds);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv2 = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv2 = $this$associateWith$iv;
        boolean $i$f$associateWithTo2 = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv2) {
            void tenantId;
            TenantId bl = (TenantId)element$iv$iv;
            t = element$iv$iv;
            map = result$iv2;
            boolean bl2 = false;
            role = Role.tenantRead((UUID)tenantId.getId());
            map.put(t, role);
        }
        Map tenantRoles = result$iv2;
        this.check$wiki_service(MapsKt.plus((Map)actionRoles, (Map)tenantRoles));
    }

    @VisibleForTesting
    public final <ID extends AbstractId> void check$wiki_service(@NotNull Map<ID, Role> roles) {
        Intrinsics.checkNotNullParameter(roles, (String)"roles");
        Map $this$forEach$iv = this.getAuthorizationResults(roles);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry result = element$iv = iterator.next();
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[((AuthorizationResult)result.getValue()).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    if (log.isDebugEnabled()) {
                        log.debug(result.getKey() + " does not exist");
                    }
                    throw new NotFoundException("Failed permission check on " + result.getKey());
                }
                default: {
                    if (log.isDebugEnabled()) {
                        Role failedRole = (Role)MapsKt.getValue(roles, result.getKey());
                        if (failedRole.isTenantRole()) {
                            log.debug(this.user + " is not part of tenant " + result.getKey());
                        } else {
                            log.debug(this.user + " is not allowed to " + failedRole);
                        }
                    }
                    throw new NotAllowedException("Failed permission check on " + result.getKey());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <ID extends AbstractId> Map<ID, AuthorizationResult> getAuthorizationResults(Map<ID, Role> roles) {
        void $this$associateTo$iv$iv$iv;
        void $this$associate$iv$iv;
        void $this$mapNotNullTo$iv$iv$iv;
        Iterable $this$mapNotNull$iv$iv;
        Map<ID, Role> $this$mapValuesNotNull$iv = roles;
        boolean $i$f$mapValuesNotNull = false;
        Iterable iterable = $this$mapValuesNotNull$iv.entrySet();
        boolean $i$f$mapNotNull = false;
        void var7_10 = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv$iv;
            Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry$iv = (Map.Entry)element$iv$iv$iv;
            boolean bl2 = false;
            Map.Entry it = entry$iv;
            boolean bl3 = false;
            if ((AuthorizationResult)this.roleCache.getIfPresent(it.getValue()) != null) {
                AuthorizationResult it$iv;
                boolean bl4 = false;
                pair = TuplesKt.to(entry$iv.getKey(), (Object)it$iv);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv$iv = pair;
            boolean bl5 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv$iv, (int)10)), (int)16);
        destination$iv$iv$iv = $this$associate$iv$iv;
        Map destination$iv$iv$iv2 = new LinkedHashMap(capacity$iv$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv$iv : $this$associateTo$iv$iv$iv) {
            Map map = destination$iv$iv$iv2;
            Pair it$iv = (Pair)element$iv$iv$iv;
            boolean bl = false;
            Pair pair = it$iv;
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map cachedRoleAuthResults = destination$iv$iv$iv2;
        if (cachedRoleAuthResults.size() == roles.size()) {
            if (log.isDebugEnabled()) {
                log.debug("Authorization check cache hit for roles " + roles.values());
            }
            return cachedRoleAuthResults;
        }
        Map<ID, Role> $this$filterKeys$iv = roles;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<ID, Role> result$iv = new LinkedHashMap<ID, Role>();
        for (Map.Entry<ID, Role> entry$iv : $this$filterKeys$iv.entrySet()) {
            AbstractId it = (AbstractId)entry$iv.getKey();
            boolean bl = false;
            if (!(!cachedRoleAuthResults.containsKey(it))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map roleAuthResultToLoad = result$iv;
        Map loadedRoleAuthResults = this.getAndCacheRoles(roleAuthResultToLoad);
        Map allRoleAuthResults = MapsKt.plus((Map)loadedRoleAuthResults, (Map)cachedRoleAuthResults);
        if (allRoleAuthResults.size() != roles.size()) {
            throw new NotFoundException("Failed to load all auth results");
        }
        return allRoleAuthResults;
    }

    /*
     * WARNING - void declaration
     */
    private final <ID extends AbstractId> Map<ID, AuthorizationResult> getAndCacheRoles(Map<ID, Role> roles) {
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map map;
        Map $this$getAndCacheRoles_u24lambda_u246 = map = this.authService.hasRoles(roles, this.user);
        boolean bl = false;
        Map map2 = $this$getAndCacheRoles_u24lambda_u246;
        Cache cache = this.roleCache;
        boolean $i$f$mapKeys = false;
        void var8_8 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Role role;
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)roles.get(it.getKey()));
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map4 = map3;
            boolean bl3 = false;
            Object v = it$iv$iv.getValue();
            map4.put(role, v);
        }
        cache.putAll(destination$iv$iv);
        return MapsKt.toMap((Map)map);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final Set<TenantId> getTenants$wiki_service(@NotNull Set<WikiId> wikiIds) {
        void $this$associateWith$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Map map = this.tenantCache.getAllPresent((Iterable)wikiIds);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAllPresent(...)");
        Map cachedTenants = MapsKt.toMap((Map)map);
        if (cachedTenants.size() == wikiIds.size()) {
            if (log.isDebugEnabled()) {
                log.debug("Tenant cache hit for " + cachedTenants.values());
            }
            return CollectionsKt.toSet((Iterable)cachedTenants.values());
        }
        Iterable $this$filter$iv = wikiIds;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WikiId it = (WikiId)element$iv$iv;
            boolean bl = false;
            if (!(!cachedTenants.containsKey(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List wikisToLoad = (List)destination$iv$iv;
        Map loadedWikis = this.wikiService.readByIds(CollectionsKt.toSet((Iterable)wikisToLoad));
        if (!((Collection)CollectionsKt.minus((Iterable)wikisToLoad, (Iterable)loadedWikis.keySet())).isEmpty()) {
            throw new NotFoundException("Failed to load all wikis to get their tenants");
        }
        $this$filterTo$iv$iv = wikisToLoad;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        void $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            WikiId wikiId = (WikiId)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            TenantId tenantId = ((Wiki)MapsKt.getValue((Map)loadedWikis, (Object)it)).getTenantId();
            map2.put(t, tenantId);
        }
        Map loadedWikiTenants = result$iv;
        if (log.isDebugEnabled()) {
            log.debug("Tenant cache miss for " + loadedWikiTenants.values());
        }
        this.tenantCache.putAll(loadedWikiTenants);
        return SetsKt.plus((Set)CollectionsKt.toSet((Iterable)cachedTenants.values()), (Iterable)loadedWikiTenants.values());
    }
}

