/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.web.design;

import com.google.common.base.Charsets;
import de.justsoftware.onx.design.shared.model.Theme;
import de.justsoftware.onx.tenantdesign.ThemeService;
import de.justsoftware.web.design.theme.ThemeRenderer;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ro.isdc.wro.model.resource.locator.UriLocator;

@ParametersAreNonnullByDefault
@Service(value="freemarkerThemeLocator")
public class FreemarkerThemeUriLocator
implements UriLocator {
    public static final String ALIAS = "freemarker";
    private static final Logger LOG = LoggerFactory.getLogger(FreemarkerThemeUriLocator.class);
    private final ThemeService _themeService;
    private final ThemeRenderer _themeRenderer;

    @Autowired
    public FreemarkerThemeUriLocator(ThemeService themeService, ThemeRenderer themeRenderer) {
        this._themeService = themeService;
        this._themeRenderer = themeRenderer;
    }

    public boolean accept(String uri) {
        return uri != null && uri.startsWith(ALIAS);
    }

    public InputStream locate(String uri) throws IOException {
        String templateName = uri.substring(ALIAS.length() + 1);
        try {
            String variablesString = this.renderVariablesAndThemes(templateName);
            return new ByteArrayInputStream(variablesString.getBytes(Charsets.UTF_8));
        }
        catch (TemplateException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return new ByteArrayInputStream("".getBytes(Charsets.UTF_8));
        }
    }

    @Nonnull
    private String renderVariablesAndThemes(String templateName) throws IOException, TemplateException {
        StringBuilder writer = new StringBuilder();
        Theme defaultTheme = this._themeService.getLegacyTheme(null);
        writer.append(this._themeRenderer.renderTemplateWithGlobalVariables(defaultTheme, templateName));
        String lessString = writer.toString();
        return lessString;
    }
}

