/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.publicAPI.config;

import de.justsoftware.publicAPI.generated.wiki.apis.ExportControllerApi;
import de.justsoftware.publicAPI.model.ClusterPosition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestInitializer;
import org.springframework.web.client.RestClient;

@Configuration
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0002\u001a\u00020\u0006H\u0017J$\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00032\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lde/justsoftware/publicAPI/config/ServiceConfiguration;", "", "clusterPosition", "", "<init>", "(Ljava/lang/String;)V", "Lde/justsoftware/publicAPI/model/ClusterPosition;", "exportControllerApi", "Lde/justsoftware/publicAPI/generated/wiki/apis/ExportControllerApi;", "wikiBaseUrl", "commonRequestInitializer", "Lorg/springframework/http/client/ClientHttpRequestInitializer;", "restClientBuilder", "Lorg/springframework/web/client/RestClient$Builder;", "public-api-service"})
public class ServiceConfiguration {
    @NotNull
    private final String clusterPosition;

    public ServiceConfiguration(@Value(value="${service.clusterPosition:SECONDARY}") @NotNull String clusterPosition) {
        Intrinsics.checkNotNullParameter((Object)clusterPosition, (String)"clusterPosition");
        this.clusterPosition = clusterPosition;
    }

    @Bean
    @NotNull
    public ClusterPosition clusterPosition() {
        return Intrinsics.areEqual((Object)this.clusterPosition, (Object)"PRIMARY") ? ClusterPosition.PRIMARY : ClusterPosition.SECONDARY;
    }

    @Bean(value={"commonRequestExportControllerApi"})
    @NotNull
    public ExportControllerApi exportControllerApi(@Value(value="${just.wiki.api.baseUrl}") @NotNull String wikiBaseUrl, @Qualifier(value="commonRequestInitializer") @NotNull ClientHttpRequestInitializer commonRequestInitializer, @NotNull RestClient.Builder restClientBuilder) {
        Intrinsics.checkNotNullParameter((Object)wikiBaseUrl, (String)"wikiBaseUrl");
        Intrinsics.checkNotNullParameter((Object)commonRequestInitializer, (String)"commonRequestInitializer");
        Intrinsics.checkNotNullParameter((Object)restClientBuilder, (String)"restClientBuilder");
        RestClient restClient = restClientBuilder.requestInitializer(commonRequestInitializer).baseUrl(wikiBaseUrl).build();
        Intrinsics.checkNotNullExpressionValue((Object)restClient, (String)"build(...)");
        return new ExportControllerApi(restClient);
    }
}

