/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.util;

import com.fasterxml.jackson.databind.node.TextNode;
import com.unboundid.scim2.common.exceptions.PreconditionFailedException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.types.Name;
import com.unboundid.scim2.common.types.UserResource;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ResourceUtils {
    public static final String MANAGER_PATH = "urn:ietf:params:scim:schemas:extension:enterprise:2.0:User:manager";
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtils.class);

    public static void validateUserResource(UserResource user) throws PreconditionFailedException {
        ArrayList<String> missingAttributes = new ArrayList<String>();
        String firstName = null;
        String lastName = null;
        String email = user.getUserName();
        Name name = user.getName();
        if (name != null) {
            firstName = name.getGivenName();
            lastName = name.getFamilyName();
        }
        if (email == null) {
            missingAttributes.add("userName");
        }
        if (name == null) {
            missingAttributes.add("name");
        }
        if (firstName == null) {
            missingAttributes.add("givenName");
        }
        if (lastName == null) {
            missingAttributes.add("familyName");
        }
        if (user.getExternalId() == null) {
            missingAttributes.add("externalId");
        }
        if (missingAttributes.isEmpty()) {
            return;
        }
        String errorMsg = "Missing attributes: " + String.join((CharSequence)", ", missingAttributes);
        throw new PreconditionFailedException(errorMsg);
    }

    public static void removeInvalidManagerValue(UserResource user) {
        List managerValues;
        try {
            managerValues = user.getExtensionValues(MANAGER_PATH);
        }
        catch (ScimException e) {
            return;
        }
        if (managerValues.size() == 1 && managerValues.get(0) instanceof TextNode) {
            try {
                user.removeExtensionValues(MANAGER_PATH);
            }
            catch (ScimException e) {
                LOG.error("Found invalid manager attribute but was unable to remove it. User: {}", (Object)user, (Object)e);
            }
        }
    }
}

