/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.persistence;

import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.persistence.model.DbProfile;
import jakarta.persistence.Table;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Table(name="Profile")
@ParametersAreNonnullByDefault
public interface ProfileRepository
extends JpaRepository<DbProfile, UUID> {
    @Nonnull
    public Optional<DbProfile> findById(Long var1);

    @Transactional
    public void deleteById(Long var1);

    @Transactional
    public void deleteByTenantIdAndUuid(UUID var1, UUID var2);

    @Transactional
    default public void deleteByTenantIdAndUuid(TenantId tenantId, UUID id) {
        this.deleteByTenantIdAndUuid((UUID)tenantId.getId(), id);
    }

    @Nonnull
    public Optional<DbProfile> findByTenantIdAndUuid(UUID var1, UUID var2);

    @Nonnull
    default public Optional<DbProfile> findByTenantIdAndUuid(TenantId tenantId, UUID uid) {
        return this.findByTenantIdAndUuid((UUID)tenantId.getId(), uid);
    }

    @Nonnull
    public Optional<DbProfile> findByTenantIdAndEmailIgnoreCase(UUID var1, String var2);

    @Nonnull
    default public Optional<DbProfile> findByTenantIdAndEmailIgnoreCase(TenantId tenantId, String email) {
        return this.findByTenantIdAndEmailIgnoreCase((UUID)tenantId.getId(), email);
    }
}

