/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security;

import de.justsoftware.gateway.security.AuthenticationToJwtStringConverter;
import de.justsoftware.gateway.security.JustAuthToken;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@ParametersAreNonnullByDefault
public class AddJustTokenHeaderFilter
implements GlobalFilter,
Ordered {
    private final AuthenticationToJwtStringConverter _converter;

    public AddJustTokenHeaderFilter(AuthenticationToJwtStringConverter converter) {
        this._converter = converter;
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        return exchange.getPrincipal().map(p -> this.withJustIdHeader(exchange, p)).defaultIfEmpty((Object)exchange).flatMap(arg_0 -> ((GatewayFilterChain)chain).filter(arg_0));
    }

    @Nonnull
    private ServerWebExchange withJustIdHeader(ServerWebExchange exchange, Principal p) {
        if (p instanceof JustAuthToken && !exchange.getRequest().getHeaders().containsKey((Object)"just-token")) {
            String jwt = this._converter.convert((JustAuthToken)p);
            return exchange.mutate().request(r -> {
                String path = exchange.getRequest().getPath().subPath(0).value();
                r.headers(headers -> {
                    headers.add("just-token", jwt);
                    if (!path.startsWith("/auth/")) {
                        headers.remove((Object)"Authorization");
                    }
                });
            }).build();
        }
        if (p instanceof JwtAuthenticationToken) {
            return exchange.mutate().request(r -> r.header("Authorization", new String[0])).build();
        }
        return exchange;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

