/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.filter;

import de.justsoftware.gateway.security.JustAuthToken;
import de.justsoftware.gateway.security.filter.JustSocialAppCookieGatewayFilterFactory;
import de.justsoftware.gateway.stats.UserStatsService;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;

@ParametersAreNonnullByDefault
@Component
public class UsageStatsGatewayFilterFactory
extends AbstractGatewayFilterFactory<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(UsageStatsGatewayFilterFactory.class);
    final UserStatsService _userStatsService;

    public UsageStatsGatewayFilterFactory(UserStatsService userStatsService) {
        this._userStatsService = userStatsService;
    }

    @Nonnull
    public GatewayFilter apply(Object config) {
        return (exchange, chain) -> exchange.getPrincipal().doOnSuccess(p -> this.trackPrincipal(p, exchange)).then(chain.filter(exchange));
    }

    public void trackPrincipal(Principal p, ServerWebExchange exchange) {
        UserStatsService.UserActivityType type;
        if (p instanceof JwtAuthenticationToken) {
            JwtAuthenticationToken jwt = (JwtAuthenticationToken)p;
            type = JustSocialAppCookieGatewayFilterFactory.isJustSocialApp((ServerWebExchange)exchange) ? UserStatsService.UserActivityType.ACCESS_MOBILE : UserStatsService.UserActivityType.ACCESS_DESKTOP;
            this._userStatsService.trackAccess((Authentication)jwt, type);
        }
        if (p instanceof JustAuthToken) {
            JustAuthToken token = (JustAuthToken)p;
            type = JustSocialAppCookieGatewayFilterFactory.isJustSocialApp((ServerWebExchange)exchange) ? UserStatsService.UserActivityType.ACCESS_MOBILE : UserStatsService.UserActivityType.ACCESS_DESKTOP;
            this._userStatsService.trackAccess((Authentication)token, type);
        }
    }
}

