/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.config;

import de.justsoftware.drive.business.authorization.AuthorizationContextProvider;
import de.justsoftware.drive.business.authorization.PersonAuthorizationContext;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.rest.config.AbstractAuthorizationContextResolver;
import de.justsoftware.drive.rest.exceptions.UnauthorizedException;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;

@ParametersAreNonnullByDefault
public class AuthorizationContextResolver
extends AbstractAuthorizationContextResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationContextResolver.class);
    private final AuthorizationContextProvider _authorizationContextProvider;

    public AuthorizationContextResolver(AuthorizationContextProvider authorizationContextProvider) {
        this._authorizationContextProvider = authorizationContextProvider;
    }

    @Nonnull
    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="we want to throw only UnauthorizedException")
    public PersonAuthorizationContext resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws UnauthorizedException {
        try {
            JwtAuthenticationToken authentication = (JwtAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
            PersonId userId = this.parsePersonId(authentication.getPrincipal());
            TenantId tenantId = new TenantId(UUID.fromString(authentication.getCustomJwtClaims().get((Object)"tenantId").toString().split(",")[1]));
            return this._authorizationContextProvider.forPersonWithTenant(userId, tenantId);
        }
        catch (UnauthorizedException e) {
            throw new UnauthorizedException("An error occurred authorizing your request.");
        }
        catch (NullPointerException e) {
            throw new UnauthorizedException("An error occurred during the evaluation of your credentials. One or more arguments may be null.");
        }
    }

    @Nonnull
    private PersonId parsePersonId(String profileId) {
        String[] profileIdParts = profileId.split(",");
        if (profileIdParts.length < 2 || !profileIdParts[0].equals("PROFILE")) {
            throw this.unauthorized(profileId);
        }
        try {
            return new PersonId(Long.parseLong(profileIdParts[1]));
        }
        catch (NumberFormatException e) {
            throw this.unauthorized(profileId);
        }
    }

    @Nonnull
    private UnauthorizedException unauthorized(@Nullable String remoteUser) {
        LOGGER.warn("We received an unparsable profile ID from Just: '" + remoteUser + "'");
        return new UnauthorizedException("An error occurred authorizing your request.");
    }
}

