/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.file;

import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.file.model.VirusScanBo;
import de.justsoftware.drive.common.file.model.VirusScanCreateBo;
import de.justsoftware.drive.common.file.model.VirusScanUpdateStatusBo;
import de.justsoftware.drive.persistence.file.VirusScanDAO;
import de.justsoftware.drive.persistence.file.VirusScanMapper;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class VirusScanDAOImpl
implements VirusScanDAO {
    private final VirusScanMapper _virusScanMapper;

    @Autowired
    public VirusScanDAOImpl(VirusScanMapper virusScanMapper) {
        this._virusScanMapper = virusScanMapper;
    }

    public void addVirusScanRequestIfNotExists(StorageId storageId) {
        this._virusScanMapper.insertVirusScan(new VirusScanCreateBo(storageId));
    }

    public void setVirusScanStatus(VirusScanBo virusScanBo) {
        this._virusScanMapper.setVirusScanResult(virusScanBo);
    }

    public void overrideVirusScanStatus(VirusScanUpdateStatusBo statusUpdateBo) {
        this._virusScanMapper.overrideVirusScanStatus(statusUpdateBo);
    }

    public VirusScanBo findVirusScanStatus(StorageId storageId) {
        return this._virusScanMapper.findVirusScanStatus(storageId);
    }

    public void deleteVirusScanStatus(Set<StorageId> storageId) {
        if (!storageId.isEmpty()) {
            this._virusScanMapper.deleteVirusScanStatus(storageId);
        }
    }

    public List<StorageId> findAllWithStatusNotScannedLatestFirst(int limit) {
        return this._virusScanMapper.findAllWithStatusNotScannedLatestFirst(new RowBounds(0, limit));
    }

    public int countQueuedVirusScans() {
        return this._virusScanMapper.countQueuedVirusScans();
    }
}

