/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.justsoftware.drive.business.file.VirusScannerService;
import de.justsoftware.drive.business.kafka.VirusScanResultKafkaDto;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.file.model.VirusScanBo;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class VirusScanKafkaConsumer {
    public static final String JUST_VIRUS_SCAN_RESULTS_TOPIC = "just.virus.scan.results";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule());
    private static final Logger LOG = LoggerFactory.getLogger(VirusScanKafkaConsumer.class);
    private final VirusScannerService _virusScannerService;

    @Autowired
    VirusScanKafkaConsumer(VirusScannerService virusScannerService) {
        this._virusScannerService = virusScannerService;
    }

    @KafkaListener(id="just.virus.scan.resultConsumer", topics={"just.virus.scan.results"}, containerFactory="virusScanResultListenerContainerFactory")
    public void listen(@Header(value="kafka_receivedMessageKey") StorageId storageId, @Payload String json) {
        try {
            VirusScanResultKafkaDto virusScanResult = (VirusScanResultKafkaDto)OBJECT_MAPPER.readValue(json, VirusScanResultKafkaDto.class);
            this._virusScannerService.handleVirusScanResult(new VirusScanBo(storageId, virusScanResult.virusScanStatus(), virusScanResult.scanDate()));
        }
        catch (JsonProcessingException e) {
            LOG.error("error while reading payload JSON string", (Throwable)e);
        }
    }
}

