/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.common;

import com.google.common.base.Charsets;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public final class ZookeeperUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperUtil.class);
    private static final String ZOOKEEPER_DISCONNECTED_ERROR = "Not connected to zookeeper. Can not create read {}";
    private static final String CACHE_EMPTY_ERROR = "Can not read {}. Cache is empty";

    private ZookeeperUtil() {
    }

    @CheckForNull
    public static NodeCache createNodeCache(@Nullable CuratorFramework zookeeperClient, String path) {
        if (zookeeperClient == null) {
            return null;
        }
        NodeCache keyCache = new NodeCache(zookeeperClient, path);
        try {
            keyCache.start(true);
            return keyCache;
        }
        catch (Exception e) {
            LOG.error("Could not initialize " + path + " cache", (Throwable)e);
            return null;
        }
    }

    @Nonnull
    public static Optional<String> getStringFromNodeCache(String path, @Nullable NodeCache cache) {
        if (cache == null) {
            LOG.warn("Not connected to zookeeper. Can not create read {}", (Object)path);
            return Optional.empty();
        }
        ChildData currentData = cache.getCurrentData();
        if (currentData == null) {
            LOG.warn("Can not read {}. Cache is empty", (Object)path);
            return Optional.empty();
        }
        byte[] bytes = currentData.getData();
        if (bytes == null) {
            LOG.warn("Can not read {}. Cache is empty", (Object)path);
            return Optional.empty();
        }
        return Optional.of(new String(bytes, Charsets.UTF_8));
    }

    public static boolean getBooleanFromNodeCache(String path, @Nullable NodeCache cache, boolean defaultValue) {
        Optional s = ZookeeperUtil.getStringFromNodeCache((String)path, (NodeCache)cache);
        if (!s.isPresent()) {
            return defaultValue;
        }
        return Boolean.parseBoolean((String)s.get());
    }
}

