/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.authorization.impl;

import de.justsoftware.drive.business.authorization.AuthorizationContextProvider;
import de.justsoftware.drive.business.authorization.AuthorizationResolver;
import de.justsoftware.drive.business.authorization.PersonAuthorizationContext;
import de.justsoftware.drive.business.authorization.impl.DefaultAuthorizationContext;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class AuthorizationContextProviderImpl
implements AuthorizationContextProvider {
    private final AuthorizationResolver _authorizationResolver;
    private final PermissionRequestConnector _permissionRequestConnector;

    @Autowired
    public AuthorizationContextProviderImpl(AuthorizationResolver authorizationResolver, PermissionRequestConnector permissionRequestConnector) {
        this._permissionRequestConnector = permissionRequestConnector;
        this._authorizationResolver = authorizationResolver;
    }

    public PersonAuthorizationContext forPerson(PersonId personId) {
        return new DefaultAuthorizationContext(personId, null, this._authorizationResolver, this._permissionRequestConnector);
    }

    public PersonAuthorizationContext forPersonWithTenant(PersonId personId, TenantId tenantId) {
        return new DefaultAuthorizationContext(personId, tenantId, this._authorizationResolver, this._permissionRequestConnector);
    }
}

