/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.util;

import de.justsoftware.justdocumentz.util.ConditionalDeleteVisitor;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\rJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/justdocumentz/util/FileUtils;", "", "()V", "logger", "Lorg/slf4j/Logger;", "deleteFile", "", "path", "Ljava/nio/file/Path;", "deleteWhere", "", "rootPath", "predicate", "Lkotlin/Function2;", "Ljava/nio/file/attribute/BasicFileAttributes;", "isDirectoryEmpty", "dir", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\nde/justsoftware/justdocumentz/util/FileUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n*L\n1#1,92:1\n1#2:93\n9#3:94\n*S KotlinDebug\n*F\n+ 1 FileUtils.kt\nde/justsoftware/justdocumentz/util/FileUtils\n*L\n63#1:94\n*E\n"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE;
    @NotNull
    private static final Logger logger;

    private FileUtils() {
    }

    public final boolean deleteFile(@NotNull Path path) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object2 = this;
        try {
            FileUtils $this$deleteFile_u24lambda_u240 = object2;
            boolean bl = false;
            Files.delete(path);
            object = Result.constructor-impl((Object)true);
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e = object = throwable;
            boolean bl = false;
            logger.error("Failed to delete file: " + path, (Throwable)e);
        }
        object = false;
        return (Boolean)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isDirectoryEmpty(@NotNull Path dir) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!Files.isDirectory(dir, new LinkOption[0])) return false;
        AutoCloseable autoCloseable = Files.list(dir);
        Throwable throwable = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl2 = false;
            bl = !it.findAny().isPresent();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        if (!bl) return false;
        return true;
    }

    public final long deleteWhere(@NotNull Path rootPath, @NotNull Function2<? super Path, ? super BasicFileAttributes, Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        ConditionalDeleteVisitor visitor = new ConditionalDeleteVisitor(rootPath, predicate);
        Files.walkFileTree(rootPath, (FileVisitor)visitor);
        return visitor.getDeletedCount();
    }

    static {
        FileUtils $this$logger$iv = INSTANCE = new FileUtils();
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(FileUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        FileUtils.logger = logger;
    }
}

