/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.conversions.document;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.justdocumentz.common.ContainerImageService;
import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.config.PodmanConfig;
import de.justsoftware.justdocumentz.conversions.ConversionService;
import de.justsoftware.justdocumentz.conversions.UnsupportedConversionException;
import de.justsoftware.justdocumentz.conversions.document.DocumentConversionService;
import de.justsoftware.justdocumentz.conversions.document.FileTypeDetectionService;
import de.justsoftware.justdocumentz.conversions.document.Pdf2IFrameConversionService;
import de.justsoftware.justdocumentz.monitoring.ConversionAvailabilityTracker;
import de.justsoftware.justdocumentz.util.CommandLineUtilsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 +2\u00020\u0001:\u0001+B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"H\u0016J\u0018\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\"H\u0012J\u001b\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0017\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b)\u0010*R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006,"}, d2={"Lde/justsoftware/justdocumentz/conversions/document/DocumentConversionService;", "Lde/justsoftware/justdocumentz/conversions/ConversionService;", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "containerImageService", "Lde/justsoftware/justdocumentz/common/ContainerImageService;", "fileTypeDetectionService", "Lde/justsoftware/justdocumentz/conversions/document/FileTypeDetectionService;", "pdf2IFrameConversionService", "Lde/justsoftware/justdocumentz/conversions/document/Pdf2IFrameConversionService;", "environment", "Lorg/springframework/core/env/Environment;", "availabilityTracker", "Lde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;Lde/justsoftware/justdocumentz/common/ContainerImageService;Lde/justsoftware/justdocumentz/conversions/document/FileTypeDetectionService;Lde/justsoftware/justdocumentz/conversions/document/Pdf2IFrameConversionService;Lorg/springframework/core/env/Environment;Lde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker;)V", "getAvailabilityTracker", "()Lde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker;", "getConfig", "()Lde/justsoftware/justdocumentz/config/JudoConfig;", "getContainerImageService", "()Lde/justsoftware/justdocumentz/common/ContainerImageService;", "getEnvironment", "()Lorg/springframework/core/env/Environment;", "getFileTypeDetectionService", "()Lde/justsoftware/justdocumentz/conversions/document/FileTypeDetectionService;", "justContainerVersion", "", "libreOfficeImage", "logger", "Lorg/slf4j/Logger;", "getPdf2IFrameConversionService", "()Lde/justsoftware/justdocumentz/conversions/document/Pdf2IFrameConversionService;", "convert", "", "Ljava/nio/file/Path;", "inputFile", "tempDir", "convertToPdf", "onApplicationStartedEvent", "Lkotlin/Result;", "", "onApplicationStartedEvent-d1pmJ48", "()Ljava/lang/Object;", "Companion", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nDocumentConversionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentConversionService.kt\nde/justsoftware/justdocumentz/conversions/document/DocumentConversionService\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,309:1\n9#2:310\n1#3:311\n1549#4:312\n1620#4,3:313\n*S KotlinDebug\n*F\n+ 1 DocumentConversionService.kt\nde/justsoftware/justdocumentz/conversions/document/DocumentConversionService\n*L\n65#1:310\n125#1:312\n125#1:313,3\n*E\n"})
public class DocumentConversionService
implements ConversionService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final JudoConfig config;
    @NotNull
    private final ContainerImageService containerImageService;
    @NotNull
    private final FileTypeDetectionService fileTypeDetectionService;
    @NotNull
    private final Pdf2IFrameConversionService pdf2IFrameConversionService;
    @NotNull
    private final Environment environment;
    @NotNull
    private final ConversionAvailabilityTracker availabilityTracker;
    @NotNull
    private final Logger logger;
    @Nullable
    private final String justContainerVersion;
    @NotNull
    private final String libreOfficeImage;
    @NotNull
    private static final Set<String> fileTypeBlacklist;
    @NotNull
    private static final Set<String> fileTypeWhitelist;
    @NotNull
    private static final String pdfExportConfiguration;

    public DocumentConversionService(@NotNull JudoConfig config, @NotNull ContainerImageService containerImageService, @NotNull FileTypeDetectionService fileTypeDetectionService, @NotNull Pdf2IFrameConversionService pdf2IFrameConversionService, @NotNull Environment environment, @NotNull ConversionAvailabilityTracker availabilityTracker) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)containerImageService, (String)"containerImageService");
        Intrinsics.checkNotNullParameter((Object)fileTypeDetectionService, (String)"fileTypeDetectionService");
        Intrinsics.checkNotNullParameter((Object)pdf2IFrameConversionService, (String)"pdf2IFrameConversionService");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)availabilityTracker, (String)"availabilityTracker");
        this.config = config;
        this.containerImageService = containerImageService;
        this.fileTypeDetectionService = fileTypeDetectionService;
        this.pdf2IFrameConversionService = pdf2IFrameConversionService;
        this.environment = environment;
        this.availabilityTracker = availabilityTracker;
        DocumentConversionService $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(DocumentConversionService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.justContainerVersion = this.getEnvironment().getProperty("just.containerVersion");
        this.libreOfficeImage = "docker.io/justsocial/just-pdf-converter:" + this.justContainerVersion;
    }

    @NotNull
    public JudoConfig getConfig() {
        return this.config;
    }

    @NotNull
    public ContainerImageService getContainerImageService() {
        return this.containerImageService;
    }

    @NotNull
    public FileTypeDetectionService getFileTypeDetectionService() {
        return this.fileTypeDetectionService;
    }

    @NotNull
    public Pdf2IFrameConversionService getPdf2IFrameConversionService() {
        return this.pdf2IFrameConversionService;
    }

    @NotNull
    public Environment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public ConversionAvailabilityTracker getAvailabilityTracker() {
        return this.availabilityTracker;
    }

    @EventListener(value={ApplicationStartedEvent.class})
    @NotNull
    public Object onApplicationStartedEvent-d1pmJ48() {
        Object object;
        block5: {
            Object object2;
            object = this;
            try {
                DocumentConversionService $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241 = object;
                boolean bl = false;
                String[] stringArray = $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getEnvironment().getActiveProfiles();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
                if (ArraysKt.contains((Object[])stringArray, (Object)"jenkins")) {
                    $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getAvailabilityTracker().setDocumentAvailable(true);
                    $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.logger.info("Skipping " + $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getClass().getSimpleName() + " initialization in Jenkins");
                } else {
                    $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.logger.info("Initializing " + $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getClass().getSimpleName() + "...");
                    if (!$this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getContainerImageService().isPodmanAvailable()) {
                        boolean $i$a$-check-DocumentConversionService$onApplicationStartedEvent$1$22 = false;
                        String $i$a$-check-DocumentConversionService$onApplicationStartedEvent$1$22 = "Podman is not available on this system. Please install Podman to use PDF conversion.";
                        throw new IllegalStateException($i$a$-check-DocumentConversionService$onApplicationStartedEvent$1$22.toString());
                    }
                    $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getContainerImageService().ensureImageAvailable($this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.libreOfficeImage);
                    $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getAvailabilityTracker().setDocumentAvailable(true);
                }
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block5;
            Object e = object2 = throwable;
            boolean bl = false;
            this.getAvailabilityTracker().setDocumentAvailable(false);
            this.logger.error("Failed to initialize document conversion", (Throwable)e);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Path> convert(@NotNull Path inputFile, @NotNull Path tempDir) throws UnsupportedConversionException {
        Collection<Path> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable<Path> iterable;
        String string;
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        String it = string = this.getFileTypeDetectionService().detectType(inputFile);
        boolean bl = false;
        this.logger.debug("detectedType: {}", (Object)it);
        String detectedType = string;
        boolean isBlacklisted = fileTypeBlacklist.contains(detectedType);
        boolean isWhitelisted = fileTypeWhitelist.contains(detectedType);
        boolean isMsOffice = this.getFileTypeDetectionService().isMsOfficeArchive(inputFile);
        if (isBlacklisted || !isWhitelisted && !isMsOffice) {
            throw new UnsupportedConversionException(inputFile + " of type '" + detectedType + "' can not be converted to PDF.");
        }
        Path it2 = iterable = Intrinsics.areEqual((Object)detectedType, (Object)"PDF document") ? inputFile : this.convertToPdf(inputFile, tempDir);
        boolean bl2 = false;
        this.logger.debug("Path to PDF: {}", (Object)it2);
        Path pdfFile = iterable;
        Iterable<Path> files = iterable = this.getPdf2IFrameConversionService().convert(pdfFile, tempDir);
        boolean bl3 = false;
        Iterable iterable2 = files;
        Path path = tempDir;
        String string2 = "Files to publish from tempDir {}: {}";
        Logger logger = this.logger;
        boolean $i$f$map = false;
        void var16_18 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            Path path2 = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            collection.add(tempDir.relativize((Path)it3));
        }
        collection = (List)destination$iv$iv;
        logger.debug(string2, (Object)path, (Object)collection);
        return iterable;
    }

    private Path convertToPdf(Path inputFile, Path tempDir) {
        if (!Files.exists(inputFile, new LinkOption[0])) {
            boolean $i$a$-require-DocumentConversionService$convertToPdf$22 = false;
            String $i$a$-require-DocumentConversionService$convertToPdf$22 = "File " + inputFile + " does not exist";
            throw new IllegalArgumentException($i$a$-require-DocumentConversionService$convertToPdf$22.toString());
        }
        String containerInputDir = "/tmp/libreoffice-input";
        String containerOutputDir = "/tmp/libreoffice-output";
        Object[] objectArray = new String[]{"-v", inputFile.getParent().toAbsolutePath() + ":" + containerInputDir + ":ro,z", "-v", tempDir.toAbsolutePath() + ":" + containerOutputDir + ":z", this.libreOfficeImage, "libreoffice", "--headless", "--invisible", "--convert-to", "pdf:draw_pdf_Export:" + pdfExportConfiguration, "--outdir", containerOutputDir, containerInputDir + "/" + inputFile.getFileName()};
        CommandLineUtilsKt.podmanRun-BZiP2OM$default((List)CollectionsKt.listOf((Object[])objectArray), (PodmanConfig)this.getConfig().getPodman().getLibreoffice(), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)), (boolean)false, null, (int)24, null);
        Path tempPdfFile = tempDir.resolve(PathsKt.getNameWithoutExtension((Path)inputFile) + ".pdf");
        if (!Files.exists(tempPdfFile, new LinkOption[0])) {
            boolean bl = false;
            String string = "PDF conversion appeared to succeed but output file not found: " + tempPdfFile;
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNull((Object)tempPdfFile);
        return tempPdfFile;
    }

    public static final /* synthetic */ Set access$getFileTypeBlacklist$cp() {
        return fileTypeBlacklist;
    }

    public static final /* synthetic */ Set access$getFileTypeWhitelist$cp() {
        return fileTypeWhitelist;
    }

    public static final /* synthetic */ String access$getPdfExportConfiguration$cp() {
        return pdfExportConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Set set;
        Object reader2;
        Companion = new Companion(null);
        InputStream inputStream = Companion.getClass().getClassLoader().getResourceAsStream("assets/default.blacklist");
        if (inputStream == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Object it = inputStream;
        boolean bl = false;
        Closeable closeable = new BufferedReader(new InputStreamReader((InputStream)it));
        Throwable throwable = null;
        try {
            reader2 = (BufferedReader)closeable;
            boolean bl2 = false;
            reader2 = CollectionsKt.toSet((Iterable)TextStreamsKt.readLines((Reader)((Reader)reader2)));
        }
        catch (Throwable reader2) {
            throwable = reader2;
            throw reader2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        fileTypeBlacklist = reader2;
        InputStream inputStream2 = Companion.getClass().getClassLoader().getResourceAsStream("assets/default.whitelist");
        if (inputStream2 == null) {
            it = "Required value was null.";
            throw new IllegalArgumentException(it.toString());
        }
        it = inputStream2;
        boolean bl32 = false;
        closeable = new BufferedReader(new InputStreamReader((InputStream)it));
        throwable = null;
        try {
            reader2 = (BufferedReader)closeable;
            boolean bl4 = false;
            set = CollectionsKt.toSet((Iterable)TextStreamsKt.readLines((Reader)((Reader)reader2)));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        fileTypeWhitelist = set;
        URL uRL = Companion.getClass().getClassLoader().getResource("assets/libreoffice-pdf-export-config.json");
        if (uRL == null) {
            String bl32 = "Required value was null.";
            throw new IllegalArgumentException(bl32.toString());
        }
        URL it2 = uRL;
        boolean bl5 = false;
        ObjectMapper objectMapper = new ObjectMapper();
        String string = objectMapper.writeValueAsString((Object)objectMapper.readTree(it2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"let(...)");
        pdfExportConfiguration = string;
    }
}

