/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.controller;

import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.util.FileUtilsKt;
import de.justsoftware.justdocumentz.util.StoragePaths;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0012J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lde/justsoftware/justdocumentz/controller/DocumentApiService;", "", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "storagePaths", "Lde/justsoftware/justdocumentz/util/StoragePaths;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;Lde/justsoftware/justdocumentz/util/StoragePaths;)V", "getConfig", "()Lde/justsoftware/justdocumentz/config/JudoConfig;", "logger", "Lorg/slf4j/Logger;", "getStoragePaths", "()Lde/justsoftware/justdocumentz/util/StoragePaths;", "delete", "", "documentId", "Ljava/util/UUID;", "deleteAll", "", "documentIds", "", "deletePreviewSources", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nDocumentApiController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentApiController.kt\nde/justsoftware/justdocumentz/controller/DocumentApiService\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n9#2:82\n1#3:83\n*S KotlinDebug\n*F\n+ 1 DocumentApiController.kt\nde/justsoftware/justdocumentz/controller/DocumentApiService\n*L\n37#1:82\n*E\n"})
public class DocumentApiService {
    @NotNull
    private final JudoConfig config;
    @NotNull
    private final StoragePaths storagePaths;
    @NotNull
    private final Logger logger;

    public DocumentApiService(@NotNull JudoConfig config, @NotNull StoragePaths storagePaths) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)storagePaths, (String)"storagePaths");
        this.config = config;
        this.storagePaths = storagePaths;
        DocumentApiService $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(DocumentApiService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public JudoConfig getConfig() {
        return this.config;
    }

    @NotNull
    public StoragePaths getStoragePaths() {
        return this.storagePaths;
    }

    public void deletePreviewSources() {
        this.logger.info("Deleting all preview sources.");
        FileUtilsKt.deleteDirectory((Path)this.getConfig().getCacheDirPath(), (boolean)false);
    }

    public void deleteAll(@NotNull List<UUID> documentIds) {
        Intrinsics.checkNotNullParameter(documentIds, (String)"documentIds");
        this.logger.info("Delete documents: {}", documentIds);
        for (UUID documentId : documentIds) {
            Throwable throwable;
            Object $this$deleteAll_u24lambda_u240;
            DocumentApiService documentApiService = this;
            try {
                $this$deleteAll_u24lambda_u240 = documentApiService;
                boolean bl = false;
                $this$deleteAll_u24lambda_u240 = Result.constructor-impl((Object)$this$deleteAll_u24lambda_u240.delete(documentId));
            }
            catch (Throwable bl) {
                $this$deleteAll_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            documentApiService = $this$deleteAll_u24lambda_u240;
            if (Result.isSuccess-impl((Object)documentApiService)) {
                boolean deletionComplete = (Boolean)documentApiService;
                boolean bl = false;
                if (deletionComplete) {
                    this.logger.debug("Deleted {}", (Object)documentId);
                } else {
                    this.logger.warn("Document, video, or cover image to delete did not exist: " + documentId);
                }
            }
            if (Result.exceptionOrNull-impl((Object)documentApiService) == null) continue;
            Throwable e = throwable;
            boolean bl = false;
            this.logger.warn("Error while trying to delete " + documentId + ": " + e.getMessage());
        }
    }

    private boolean delete(UUID documentId) {
        boolean bl;
        StoragePaths storagePaths = this.getStoragePaths();
        String string = documentId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        Path it = storagePaths.documentPreviewRoot(string);
        boolean bl2 = false;
        if (Files.isDirectory(it, new LinkOption[0])) {
            FileUtilsKt.deleteDirectory((Path)it, (boolean)true);
            bl = true;
        } else {
            bl = false;
        }
        boolean documentRootDeleted = bl;
        StoragePaths storagePaths2 = this.getStoragePaths();
        String string2 = documentId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        Path it2 = storagePaths2.coverImage(string2);
        boolean bl3 = false;
        boolean coverImageDeleted = Files.deleteIfExists(it2);
        StoragePaths storagePaths3 = this.getStoragePaths();
        String string3 = documentId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        Path it3 = storagePaths3.convertedVideo(string3);
        boolean bl4 = false;
        boolean convertedVideoDeleted = Files.deleteIfExists(it3);
        return documentRootDeleted || coverImageDeleted && convertedVideoDeleted;
    }
}

