/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.config;

import de.justsoftware.justdocumentz.config.KafkaConfig;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.support.serializer.JsonDeserializer;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\b\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0017J\b\u0010\u000e\u001a\u00020\rH\u0017JF\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\t0\u0010\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\u0006\u0010\u0011\u001a\u00020\u00032\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/justdocumentz/config/KafkaConfig;", "", "bootstrapServers", "", "(Ljava/lang/String;)V", "getBootstrapServers", "()Ljava/lang/String;", "baseLongRunningConsumerProps", "", "V", "valueType", "Ljava/lang/Class;", "conversionStatusTopic", "Lorg/apache/kafka/clients/admin/NewTopic;", "conversionTaskTopic", "createLongRunningConsumerFactory", "Lorg/springframework/kafka/core/ConsumerFactory;", "groupId", "additionalProps", "Companion", "just-documentz"})
public class KafkaConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String bootstrapServers;
    @NotNull
    public static final String CONVERSION_TASK_TOPIC = "just.documents.conversion.taskv2";
    @NotNull
    public static final String CONVERSION_STATUS_TOPIC = "just.documents.conversion.status";
    @NotNull
    private static final Map<String, String> DEFAULT_TOPIC_CONFIG;

    public KafkaConfig(@Value(value="${spring.kafka.bootstrap-servers}") @NotNull String bootstrapServers) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        this.bootstrapServers = bootstrapServers;
    }

    @NotNull
    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @NotNull
    public <V> Map<String, Object> baseLongRunningConsumerProps(@NotNull Class<V> valueType) {
        Intrinsics.checkNotNullParameter(valueType, (String)"valueType");
        Pair[] pairArray = new Pair[8];
        pairArray[0] = TuplesKt.to((Object)"bootstrap.servers", (Object)this.getBootstrapServers());
        pairArray[1] = TuplesKt.to((Object)"auto.offset.reset", (Object)"earliest");
        pairArray[2] = TuplesKt.to((Object)"key.deserializer", StringDeserializer.class);
        pairArray[3] = TuplesKt.to((Object)"value.deserializer", JsonDeserializer.class);
        pairArray[4] = TuplesKt.to((Object)"spring.json.trusted.packages", (Object)"*");
        pairArray[5] = TuplesKt.to((Object)"spring.json.value.default.type", (Object)valueType.getName());
        pairArray[6] = TuplesKt.to((Object)"max.poll.records", (Object)1);
        pairArray[7] = TuplesKt.to((Object)"max.poll.interval.ms", (Object)((int)Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)20, (DurationUnit)DurationUnit.MINUTES))));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public <V> ConsumerFactory<String, V> createLongRunningConsumerFactory(@NotNull Class<V> valueType, @NotNull String groupId, @NotNull Map<String, ? extends Object> additionalProps) {
        Intrinsics.checkNotNullParameter(valueType, (String)"valueType");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter(additionalProps, (String)"additionalProps");
        Map props = MapsKt.plus((Map)MapsKt.plus((Map)this.baseLongRunningConsumerProps(valueType), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"group.id", (Object)groupId))), additionalProps);
        return (ConsumerFactory)new DefaultKafkaConsumerFactory(props);
    }

    public static /* synthetic */ ConsumerFactory createLongRunningConsumerFactory$default(KafkaConfig kafkaConfig, Class clazz, String string, Map map, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createLongRunningConsumerFactory");
        }
        if ((n & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        return kafkaConfig.createLongRunningConsumerFactory(clazz, string, map);
    }

    @Bean
    @NotNull
    public NewTopic conversionTaskTopic() {
        NewTopic topic = new NewTopic(CONVERSION_TASK_TOPIC, 5, 1);
        NewTopic newTopic = topic.configs(DEFAULT_TOPIC_CONFIG);
        Intrinsics.checkNotNullExpressionValue((Object)newTopic, (String)"configs(...)");
        return newTopic;
    }

    @Bean
    @NotNull
    public NewTopic conversionStatusTopic() {
        NewTopic topic = new NewTopic(CONVERSION_STATUS_TOPIC, 5, 1);
        NewTopic newTopic = topic.configs(DEFAULT_TOPIC_CONFIG);
        Intrinsics.checkNotNullExpressionValue((Object)newTopic, (String)"configs(...)");
        return newTopic;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"delete.retention.ms", (Object)"604800000"), TuplesKt.to((Object)"segment.ms", (Object)"604800000"), TuplesKt.to((Object)"cleanup.policy", (Object)"delete")};
        DEFAULT_TOPIC_CONFIG = MapsKt.mapOf((Pair[])pairArray);
    }
}

