/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.common;

import de.justsoftware.justdocumentz.common.FileCacheService;
import de.justsoftware.justdocumentz.common.StorageServerFileNotFoundException;
import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.util.FileUtilsKt;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0012J3\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0012J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u001c"}, d2={"Lde/justsoftware/justdocumentz/common/FileCacheServiceImpl;", "Lde/justsoftware/justdocumentz/common/FileCacheService;", "environment", "Lorg/springframework/core/env/Environment;", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "(Lorg/springframework/core/env/Environment;Lde/justsoftware/justdocumentz/config/JudoConfig;)V", "getConfig", "()Lde/justsoftware/justdocumentz/config/JudoConfig;", "getEnvironment", "()Lorg/springframework/core/env/Environment;", "logger", "Lorg/slf4j/Logger;", "connectToStorage", "Ljava/net/URLConnection;", "remoteUrl", "", "downloadToFileCache", "Lkotlin/Result;", "Ljava/nio/file/Path;", "id", "overwrite", "", "downloadToFileCache-0E7RQCE", "(Ljava/lang/String;Ljava/lang/String;Z)Ljava/lang/Object;", "getCacheFile", "removeFromFileCache", "", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nFileCacheService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileCacheService.kt\nde/justsoftware/justdocumentz/common/FileCacheServiceImpl\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n9#2:87\n1#3:88\n*S KotlinDebug\n*F\n+ 1 FileCacheService.kt\nde/justsoftware/justdocumentz/common/FileCacheServiceImpl\n*L\n36#1:87\n*E\n"})
public class FileCacheServiceImpl
implements FileCacheService {
    @NotNull
    private final Environment environment;
    @NotNull
    private final JudoConfig config;
    @NotNull
    private final Logger logger;

    public FileCacheServiceImpl(@NotNull Environment environment, @NotNull JudoConfig config) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.environment = environment;
        this.config = config;
        FileCacheServiceImpl $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(FileCacheServiceImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public Environment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public JudoConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Object downloadToFileCache-0E7RQCE(@NotNull String id, @NotNull String remoteUrl, boolean overwrite) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)remoteUrl, (String)"remoteUrl");
        FileCacheServiceImpl fileCacheServiceImpl = this;
        try {
            FileCacheServiceImpl $this$downloadToFileCache_0E7RQCE_u24lambda_u241 = fileCacheServiceImpl;
            boolean bl = false;
            Path targetFile = $this$downloadToFileCache_0E7RQCE_u24lambda_u241.getCacheFile(id);
            if (!overwrite && Files.isRegularFile(targetFile, new LinkOption[0])) {
                $this$downloadToFileCache_0E7RQCE_u24lambda_u241.logger.debug("File already cached for id " + id + ", return existing file");
            } else {
                try {
                    long l;
                    $this$downloadToFileCache_0E7RQCE_u24lambda_u241.logger.debug("Download original from storage server for id " + id + ".");
                    URLConnection connection = $this$downloadToFileCache_0E7RQCE_u24lambda_u241.connectToStorage(remoteUrl);
                    long expected = connection.getContentLengthLong();
                    Closeable closeable = connection.getInputStream();
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl2 = false;
                        CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                        l = Files.copy(it, targetFile, copyOptionArray);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    long length = l;
                    if (expected > 0L && expected != length) {
                        throw new IOException("Expected " + expected + " bytes but wrote " + length + " bytes");
                    }
                }
                catch (FileNotFoundException ex) {
                    throw new StorageServerFileNotFoundException(remoteUrl, (Throwable)ex);
                }
            }
            object = Result.constructor-impl((Object)targetFile);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return object;
    }

    public void removeFromFileCache(@NotNull String id) {
        block2: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Path file = this.getCacheFile(id);
            Object object2 = this;
            try {
                FileCacheServiceImpl $this$removeFromFileCache_u24lambda_u242 = object2;
                boolean bl = false;
                object = Result.constructor-impl((Object)Files.deleteIfExists(file));
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            this.logger.warn("Failed to delete file from cache: " + file);
        }
    }

    private Path getCacheFile(String id) {
        Path path;
        Path it = path = this.getConfig().getCacheDirPath();
        boolean bl = false;
        FileUtilsKt.ensureDirectoryExists((Path)it);
        Path path2 = path.resolve(id);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    private URLConnection connectToStorage(String remoteUrl) {
        String[] stringArray = this.getEnvironment().getActiveProfiles();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getActiveProfiles(...)");
        boolean isDev = ArraysKt.contains((Object[])stringArray, (Object)"dev");
        URL prodUrl = new URL(remoteUrl);
        URL url = isDev ? new URL(prodUrl.getProtocol(), prodUrl.getHost(), 8002, prodUrl.getFile()) : prodUrl;
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"openConnection(...)");
        return uRLConnection;
    }
}

