/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.judo.kafka.conversion;

import de.justsoftware.judo.services.converter.ConverterService;
import de.justsoftware.judoclient.model.ConversionTask;
import java.io.IOException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class ConversionTaskListener {
    private static final Logger LOG = LoggerFactory.getLogger(ConversionTaskListener.class);
    private final ConverterService _converterService;

    @Autowired
    public ConversionTaskListener(ConverterService converterService) {
        this._converterService = converterService;
    }

    @KafkaListener(topics={"just.documents.conversion.taskv2"}, containerFactory="conversionTaskListenerContainerFactory")
    public void listen(@Payload ConversionTask conversionTask) throws IOException {
        LOG.info("Fetched conversion task for preview id '{}' from Kafka. storage-url: {}", (Object)conversionTask.getId(), (Object)conversionTask.getRemoteUrl());
        this._converterService.startConversion(conversionTask);
    }
}

