/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.PeopleService;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.model.LimitOffset;
import de.justsoftware.chat.model.Offset;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.PeopleItemType;
import de.justsoftware.chat.model.TenantId;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;
import org.springframework.web.util.UriBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00142\u00020\u0001:\u0003\u0012\u0013\u0014B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J6\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/chat/business/PeopleService;", "", "peopleApiUrl", "", "restClient", "Lorg/springframework/web/client/RestClient;", "<init>", "(Ljava/lang/String;Lorg/springframework/web/client/RestClient;)V", "searchParticipants", "", "Lde/justsoftware/chat/model/ParticipantId;", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "query", "offset", "Lde/justsoftware/chat/model/Offset;", "types", "Lde/justsoftware/chat/model/PeopleItemType;", "SearchResult", "SearchResultRow", "Companion", "chat-service"})
@SourceDebugExtension(value={"SMAP\nPeopleService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PeopleService.kt\nde/justsoftware/chat/business/PeopleService\n+ 2 RestClientUtils.kt\nde/justsoftware/chat/util/RestClientUtilsKt\n+ 3 RestClientExtensions.kt\norg/springframework/web/client/RestClientExtensionsKt\n*L\n1#1,50:1\n18#2:51\n43#3:52\n*S KotlinDebug\n*F\n+ 1 PeopleService.kt\nde/justsoftware/chat/business/PeopleService\n*L\n38#1:51\n38#1:52\n*E\n"})
public class PeopleService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String peopleApiUrl;
    @NotNull
    private final RestClient restClient;

    public PeopleService(@Value(value="${just.people.api.url}") @NotNull String peopleApiUrl, @Qualifier(value="apiGatewayRestClient") @NotNull RestClient restClient) {
        Intrinsics.checkNotNullParameter((Object)peopleApiUrl, (String)"peopleApiUrl");
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        this.peopleApiUrl = peopleApiUrl;
        this.restClient = restClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ParticipantId> searchParticipants(@NotNull TenantId tenantId, @NotNull String query, @NotNull Offset offset, @NotNull List<? extends PeopleItemType> types) {
        void $this$bodyOrNotFound$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        LimitOffset limitOffset = Offset.Companion.asLimitOffset(offset);
        RestClient.ResponseSpec responseSpec = this.restClient.get().uri(this.peopleApiUrl + "/search/names", arg_0 -> PeopleService.searchParticipants$lambda$0(tenantId, limitOffset, query, types, arg_0)).retrieve();
        Intrinsics.checkNotNullExpressionValue((Object)responseSpec, (String)"retrieve(...)");
        RestClient.ResponseSpec responseSpec2 = responseSpec;
        boolean $i$f$bodyOrNotFound = false;
        void $this$body$iv$iv = $this$bodyOrNotFound$iv;
        boolean $i$f$body = false;
        Object object = $this$body$iv$iv.body((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        if (object == null) {
            throw new NotFoundException("Empty response body");
        }
        return Companion.access$toParticipantIds((Companion)Companion, (SearchResult)((SearchResult)object));
    }

    public static /* synthetic */ List searchParticipants$default(PeopleService peopleService, TenantId tenantId, String string, Offset offset, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: searchParticipants");
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        return peopleService.searchParticipants(tenantId, string, offset, list);
    }

    private static final URI searchParticipants$lambda$0(TenantId $tenantId, LimitOffset $limitOffset, String $query, List $types, UriBuilder uriBuilder) {
        Object[] objectArray = new Object[]{$tenantId.toCanonicalId()};
        UriBuilder uriBuilder2 = uriBuilder.queryParam("tenantId", objectArray);
        objectArray = new Object[]{$limitOffset.getOffset()};
        UriBuilder uriBuilder3 = uriBuilder2.queryParam("offset", objectArray);
        objectArray = new Object[]{$limitOffset.getLimit()};
        uriBuilder3.queryParam("limit", objectArray);
        if (!StringsKt.isBlank((CharSequence)$query)) {
            objectArray = new Object[]{$query};
            uriBuilder.queryParam("query", objectArray);
        }
        if (!((Collection)$types).isEmpty()) {
            objectArray = new Object[]{CollectionsKt.joinToString$default((Iterable)$types, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)};
            uriBuilder.queryParam("type", objectArray);
        }
        return uriBuilder.build(new Object[0]);
    }
}

