/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.user;

import de.justsoftware.admin.domain.user.model.Grantee;
import de.justsoftware.admin.domain.user.model.Profile;
import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.domain.user.persistence.ProfileDao;
import de.justsoftware.admin.domain.user.persistence.UserGroupDao;
import de.justsoftware.admin.exceptions.NotFoundException;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.id.UserGroupId;
import de.justsoftware.admin.id.UserId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\u0017H\u0016J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0016J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00172\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0017H\u0016J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lde/justsoftware/admin/domain/user/UserService;", "", "profileDao", "Lde/justsoftware/admin/domain/user/persistence/ProfileDao;", "userGroupDao", "Lde/justsoftware/admin/domain/user/persistence/UserGroupDao;", "<init>", "(Lde/justsoftware/admin/domain/user/persistence/ProfileDao;Lde/justsoftware/admin/domain/user/persistence/UserGroupDao;)V", "saveProfile", "Lde/justsoftware/admin/domain/user/model/Profile;", "profile", "saveUserGroup", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "userGroup", "deleteProfile", "Lde/justsoftware/admin/id/ProfileId;", "profileId", "deleteUserGroup", "Lde/justsoftware/admin/id/UserGroupId;", "userGroupId", "findProfile", "findUserGroup", "getAllUserGroups", "", "getProfilesByIds", "", "profileIds", "", "getByIds", "Lde/justsoftware/admin/domain/user/model/Grantee;", "ids", "Lde/justsoftware/admin/id/UserId;", "getAllTenantUsersGroup", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "admin-service"})
@SourceDebugExtension(value={"SMAP\nUserService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserService.kt\nde/justsoftware/admin/domain/user/UserService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1869#2,2:95\n1056#2:97\n*S KotlinDebug\n*F\n+ 1 UserService.kt\nde/justsoftware/admin/domain/user/UserService\n*L\n75#1:95,2\n86#1:97\n*E\n"})
public class UserService {
    @NotNull
    private final ProfileDao profileDao;
    @NotNull
    private final UserGroupDao userGroupDao;

    public UserService(@NotNull ProfileDao profileDao, @NotNull UserGroupDao userGroupDao) {
        Intrinsics.checkNotNullParameter((Object)profileDao, (String)"profileDao");
        Intrinsics.checkNotNullParameter((Object)userGroupDao, (String)"userGroupDao");
        this.profileDao = profileDao;
        this.userGroupDao = userGroupDao;
    }

    @NotNull
    public Profile saveProfile(@NotNull Profile profile) {
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        this.profileDao.save(profile);
        return profile;
    }

    @NotNull
    public UserGroup saveUserGroup(@NotNull UserGroup userGroup) {
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        this.userGroupDao.save$admin_service(userGroup);
        return userGroup;
    }

    @NotNull
    public ProfileId deleteProfile(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.profileDao.delete(profileId);
        return profileId;
    }

    @NotNull
    public UserGroupId deleteUserGroup(@NotNull UserGroupId userGroupId) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        this.userGroupDao.delete(userGroupId);
        return userGroupId;
    }

    @Nullable
    public Profile findProfile(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        return (Profile)CollectionsKt.firstOrNull((Iterable)this.profileDao.getByIds((Collection)SetsKt.setOf((Object)profileId)));
    }

    @Nullable
    public UserGroup findUserGroup(@NotNull UserGroupId userGroupId) {
        Intrinsics.checkNotNullParameter((Object)userGroupId, (String)"userGroupId");
        return (UserGroup)CollectionsKt.firstOrNull((Iterable)this.userGroupDao.getByIds((Collection)SetsKt.setOf((Object)userGroupId)));
    }

    @NotNull
    public List<UserGroup> getAllUserGroups() {
        return this.userGroupDao.getAll();
    }

    @NotNull
    public Set<Profile> getProfilesByIds(@NotNull Collection<ProfileId> profileIds) {
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        return this.profileDao.getByIds(profileIds);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Grantee> getByIds(@NotNull List<? extends UserId> ids) {
        void $this$sortedBy$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        List profileIds = new ArrayList();
        List groupIds = new ArrayList();
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            UserId it = (UserId)element$iv;
            boolean bl2 = false;
            UserId userId = it;
            if (userId instanceof ProfileId) {
                bl = profileIds.add(it);
                continue;
            }
            if (userId instanceof UserGroupId) {
                bl = groupIds.add(it);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        Set profiles = this.profileDao.getByIds((Collection)profileIds);
        Set groups = this.userGroupDao.getByIds((Collection)groupIds);
        Iterable iterable = SetsKt.plus((Set)profiles, (Iterable)groups);
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
    }

    @NotNull
    public UserGroup getAllTenantUsersGroup(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        UserGroup userGroup = this.userGroupDao.findAllTenantUsersGroup(tenantId);
        if (userGroup == null) {
            throw new NotFoundException("No AllTenantUsersGroup found");
        }
        return userGroup;
    }
}

