#!/bin/bash
LASTTEST_DIRECTORY="{{ io_lasttest_directory }}"
TEST_SIZE="{{ io_test_size }}"
TEST_DURATION="{{ io_test_duration }}"
REPORTING_FILE="{{ io_reporting_file }}"

mkdir -p "$LASTTEST_DIRECTORY"
# Starting fio disk benchmark
fio --name=write_iops --directory="$LASTTEST_DIRECTORY" --size="$TEST_SIZE" \
--time_based --runtime="$TEST_DURATION" --ramp_time=2s --ioengine=libaio --direct=1 \
--verify=0 --bs=4K --iodepth=256 --rw=randwrite --group_reporting=1  \
--iodepth_batch_submit=256  --iodepth_batch_complete_max=256 > "$REPORTING_FILE"
chmod 644 "$REPORTING_FILE"
rm -r "$LASTTEST_DIRECTORY"
